/*
 * Decompiled with CFR 0.152.
 */
package ru.justagod.plugin.util;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.justagod.mincer.Mincer;
import ru.justagod.model.ClassModel;
import ru.justagod.model.ClassParent;
import ru.justagod.model.ClassTypeReference;
import ru.justagod.plugin.processing.model.InvokeClass;
import ru.justagod.plugin.processing.model.ProjectModel;
import shadow.org.objectweb.asm.Handle;
import shadow.org.objectweb.asm.Opcodes;
import shadow.org.objectweb.asm.tree.AbstractInsnNode;
import shadow.org.objectweb.asm.tree.FieldInsnNode;
import shadow.org.objectweb.asm.tree.FrameNode;
import shadow.org.objectweb.asm.tree.InsnNode;
import shadow.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import shadow.org.objectweb.asm.tree.JumpInsnNode;
import shadow.org.objectweb.asm.tree.LabelNode;
import shadow.org.objectweb.asm.tree.LdcInsnNode;
import shadow.org.objectweb.asm.tree.LineNumberNode;
import shadow.org.objectweb.asm.tree.LookupSwitchInsnNode;
import shadow.org.objectweb.asm.tree.MethodInsnNode;
import shadow.org.objectweb.asm.tree.MultiANewArrayInsnNode;
import shadow.org.objectweb.asm.tree.TableSwitchInsnNode;
import shadow.org.objectweb.asm.tree.TypeInsnNode;
import shadow.org.objectweb.asm.tree.VarInsnNode;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0005R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lru/justagod/plugin/util/CutterUtils;", "", "()V", "opcodes", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "findInvokeClass", "Lru/justagod/plugin/processing/model/InvokeClass;", "ref", "Lru/justagod/model/ClassTypeReference;", "mincer", "Lru/justagod/mincer/Mincer;", "model", "Lru/justagod/plugin/processing/model/ProjectModel;", "nodeToString", "node", "Lshadow/org/objectweb/asm/tree/AbstractInsnNode;", "opcodeToString", "opcode", "cutter"})
public final class CutterUtils {
    private static final HashMap<Integer, String> opcodes;
    public static final CutterUtils INSTANCE;

    @Nullable
    public final InvokeClass findInvokeClass(@NotNull ClassTypeReference ref, @NotNull Mincer mincer, @NotNull ProjectModel model2) {
        Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
        Intrinsics.checkParameterIsNotNull((Object)mincer, (String)"mincer");
        Intrinsics.checkParameterIsNotNull((Object)model2, (String)"model");
        InvokeClass result = null;
        for (InvokeClass invokeClass : model2.getInvokeClasses()) {
            if (!mincer.getInheritance().isChild(ref, invokeClass.getName(), true)) continue;
            if (result != null) {
                String string = ref + " inherits more than one invoke class";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            result = invokeClass;
        }
        if (result != null && Intrinsics.areEqual((Object)ref, (Object)result.getName()) ^ true) {
            boolean bl;
            ClassModel refModel;
            block9: {
                refModel = mincer.getFactory().makeModel(ref, null);
                Iterable $receiver$iv = refModel.getInterfaces();
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        ClassParent it = (ClassParent)element$iv;
                        if (!Intrinsics.areEqual((Object)it.getRawType(), (Object)result.getName())) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (!bl) {
                ClassParent classParent = refModel.getSuperClass();
                if (classParent == null) {
                    Intrinsics.throwNpe();
                }
                if (Intrinsics.areEqual((Object)classParent.getRawType(), (Object)result.getName()) ^ true) {
                    String string = ref + " implements " + result.getName() + " but not like direct child. It's not allowed behavior.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
        }
        return result;
    }

    @NotNull
    public final String opcodeToString(int opcode) {
        return (String)MapsKt.getValue((Map)opcodes, (Object)opcode);
    }

    @NotNull
    public final String nodeToString(@NotNull AbstractInsnNode node) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        AbstractInsnNode abstractInsnNode = node;
        if (abstractInsnNode instanceof MethodInsnNode) {
            string = this.opcodeToString(((MethodInsnNode)node).getOpcode()) + ' ' + ((MethodInsnNode)node).owner + '.' + ((MethodInsnNode)node).name + ((MethodInsnNode)node).desc + " itf = " + ((MethodInsnNode)node).itf;
        } else if (abstractInsnNode instanceof FieldInsnNode) {
            string = this.opcodeToString(((FieldInsnNode)node).getOpcode()) + ' ' + ((FieldInsnNode)node).owner + '.' + ((FieldInsnNode)node).name + ((FieldInsnNode)node).desc;
        } else if (abstractInsnNode instanceof TableSwitchInsnNode) {
            string = "~~~switch~~~";
        } else if (abstractInsnNode instanceof LineNumberNode) {
            string = "" + ((LineNumberNode)node).line + ':';
        } else if (abstractInsnNode instanceof LabelNode) {
            String string2 = ((LabelNode)node).getLabel().toString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"node.label.toString()");
        } else if (abstractInsnNode instanceof MultiANewArrayInsnNode) {
            string = this.opcodeToString(((MultiANewArrayInsnNode)node).getOpcode()) + ' ' + ((MultiANewArrayInsnNode)node).desc + ' ' + ((MultiANewArrayInsnNode)node).dims;
        } else if (abstractInsnNode instanceof LdcInsnNode) {
            string = ((LdcInsnNode)node).cst.getClass().getName() + ": " + ((LdcInsnNode)node).cst;
        } else if (abstractInsnNode instanceof TypeInsnNode) {
            string = this.opcodeToString(((TypeInsnNode)node).getOpcode()) + " " + ((TypeInsnNode)node).desc;
        } else if (abstractInsnNode instanceof VarInsnNode) {
            string = this.opcodeToString(((VarInsnNode)node).getOpcode()) + " " + ((VarInsnNode)node).var;
        } else if (abstractInsnNode instanceof FrameNode) {
            string = "~~~frame~~~";
        } else if (abstractInsnNode instanceof InvokeDynamicInsnNode) {
            StringBuilder stringBuilder = new StringBuilder().append(this.opcodeToString(((InvokeDynamicInsnNode)node).getOpcode())).append(((InvokeDynamicInsnNode)node).name).append(((InvokeDynamicInsnNode)node).desc).append(" [");
            Handle handle = ((InvokeDynamicInsnNode)node).bsm;
            Intrinsics.checkExpressionValueIsNotNull((Object)handle, (String)"node.bsm");
            StringBuilder stringBuilder2 = stringBuilder.append(handle.getOwner()).append('.');
            Handle handle2 = ((InvokeDynamicInsnNode)node).bsm;
            Intrinsics.checkExpressionValueIsNotNull((Object)handle2, (String)"node.bsm");
            StringBuilder stringBuilder3 = stringBuilder2.append(handle2.getName());
            Handle handle3 = ((InvokeDynamicInsnNode)node).bsm;
            Intrinsics.checkExpressionValueIsNotNull((Object)handle3, (String)"node.bsm");
            StringBuilder stringBuilder4 = stringBuilder3.append(handle3.getDesc()).append(" tag = ");
            Handle handle4 = ((InvokeDynamicInsnNode)node).bsm;
            Intrinsics.checkExpressionValueIsNotNull((Object)handle4, (String)"node.bsm");
            StringBuilder stringBuilder5 = stringBuilder4.append(handle4.getTag()).append(" itf = ");
            Handle handle5 = ((InvokeDynamicInsnNode)node).bsm;
            Intrinsics.checkExpressionValueIsNotNull((Object)handle5, (String)"node.bsm");
            StringBuilder stringBuilder6 = stringBuilder5.append(handle5.isInterface()).append("] {");
            Intrinsics.checkExpressionValueIsNotNull((Object)((InvokeDynamicInsnNode)node).bsmArgs, (String)"node.bsmArgs");
            string = stringBuilder6.append(ArraysKt.joinToString$default((Object[])((InvokeDynamicInsnNode)node).bsmArgs, null, null, null, (int)0, null, null, (int)63, null)).append('}').toString();
        } else if (abstractInsnNode instanceof JumpInsnNode) {
            StringBuilder stringBuilder = new StringBuilder().append(this.opcodeToString(((JumpInsnNode)node).getOpcode())).append(" ");
            LabelNode labelNode = ((JumpInsnNode)node).label;
            Intrinsics.checkExpressionValueIsNotNull((Object)labelNode, (String)"node.label");
            string = stringBuilder.append(labelNode.getLabel()).toString();
        } else if (abstractInsnNode instanceof InsnNode) {
            string = this.opcodeToString(((InsnNode)node).getOpcode());
        } else if (abstractInsnNode instanceof LookupSwitchInsnNode) {
            string = "~~~lookup~~~";
        } else {
            String string3 = "";
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        return string;
    }

    private CutterUtils() {
    }

    static {
        CutterUtils cutterUtils;
        INSTANCE = cutterUtils = new CutterUtils();
        opcodes = new HashMap();
        for (Field field2 : Opcodes.class.getFields()) {
            String string;
            Map map = opcodes;
            Object object = field2.get(null);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
            }
            Integer n = (Integer)object;
            Field field3 = field2;
            Intrinsics.checkExpressionValueIsNotNull((Object)field3, (String)"field");
            Intrinsics.checkExpressionValueIsNotNull((Object)field3.getName(), (String)"field.name");
            map.put(n, string);
        }
    }
}

