/*
 * Decompiled with CFR 0.152.
 */
package ru.justagod.plugin.processing.pipeline;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.justagod.mincer.control.MincerArchive;
import ru.justagod.mincer.control.MincerResultType;
import ru.justagod.mincer.pipeline.Pipeline;
import ru.justagod.mincer.processor.ClassInfo;
import ru.justagod.mincer.processor.SubMincer;
import ru.justagod.mincer.processor.WorkerContext;
import ru.justagod.model.ClassTypeReference;
import ru.justagod.model.InheritanceHelper;
import ru.justagod.plugin.data.DynSideMarker;
import ru.justagod.plugin.data.SideName;
import ru.justagod.plugin.processing.model.InvokeClass;
import ru.justagod.plugin.processing.model.MethodDesc;
import ru.justagod.plugin.processing.model.PathHelper;
import ru.justagod.plugin.processing.model.ProjectModel;
import ru.justagod.plugin.processing.model.SidesTree;
import ru.justagod.plugin.processing.pipeline.FourthAnalyzerMincer;
import ru.justagod.plugin.processing.pipeline.SidlyInstructionsIter;
import ru.justagod.plugin.util.CutterUtils;
import ru.justagod.plugin.util.MiscellaneousKt;
import shadow.org.objectweb.asm.Handle;
import shadow.org.objectweb.asm.Type;
import shadow.org.objectweb.asm.tree.AbstractInsnNode;
import shadow.org.objectweb.asm.tree.ClassNode;
import shadow.org.objectweb.asm.tree.InsnList;
import shadow.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import shadow.org.objectweb.asm.tree.MethodNode;
import shadow.org.objectweb.asm.tree.TypeInsnNode;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ4\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J2\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u00152\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J6\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u001dH\u0016J\u001c\u0010\u001e\u001a\u00020\u001f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\f\u0010 \u001a\u00020!*\u00020!H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lru/justagod/plugin/processing/pipeline/FourthAnalyzerMincer;", "Lru/justagod/mincer/processor/SubMincer;", "Lru/justagod/plugin/processing/model/ProjectModel;", "primalSides", "", "Lru/justagod/plugin/data/SideName;", "markers", "", "Lru/justagod/plugin/data/DynSideMarker;", "(Ljava/util/Set;Ljava/util/List;)V", "lambdasCounter", "", "analyzeInvokeDynamic", "Lshadow/org/objectweb/asm/tree/MethodNode;", "instruction", "Lshadow/org/objectweb/asm/tree/InvokeDynamicInsnNode;", "context", "Lru/justagod/mincer/processor/WorkerContext;", "sides", "analyzeTypeInsn", "", "Lshadow/org/objectweb/asm/tree/TypeInsnNode;", "endProcessing", "input", "cache", "Lru/justagod/mincer/control/MincerArchive;", "inheritance", "Lru/justagod/model/InheritanceHelper;", "pipeline", "Lru/justagod/mincer/pipeline/Pipeline;", "process", "Lru/justagod/mincer/control/MincerResultType;", "sha1", "", "cutter"})
public final class FourthAnalyzerMincer
implements SubMincer<ProjectModel, ProjectModel> {
    private int lambdasCounter;
    private final Set<SideName> primalSides;
    private final List<DynSideMarker> markers;

    @Override
    @NotNull
    public MincerResultType process(@NotNull WorkerContext<ProjectModel, ProjectModel> context) {
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        ClassInfo classInfo = context.getInfo();
        if (classInfo == null) {
            Intrinsics.throwNpe();
        }
        ClassNode node = classInfo.getNode();
        ArrayList additionalMethods = new ArrayList();
        List<MethodNode> list = node.methods;
        if (list != null) {
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                MethodNode it = (MethodNode)element$iv;
                try {
                    SidesTree sidesTree = context.getInput().getSidesTree();
                    ClassTypeReference classTypeReference = context.getName();
                    String string = it.name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
                    String string2 = it.desc;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.desc");
                    Set<SideName> sides = sidesTree.get(PathHelper.INSTANCE.method(classTypeReference, string, string2), this.primalSides);
                    InsnList insnList = it.instructions;
                    Intrinsics.checkExpressionValueIsNotNull((Object)insnList, (String)"it.instructions");
                    SidlyInstructionsIter.Companion.iterate(insnList, sides, this.markers, (Function1<? super Pair<? extends AbstractInsnNode, ? extends Set<SideName>>, Unit>)((Function1)new Function1<Pair<? extends AbstractInsnNode, ? extends Set<? extends SideName>>, Unit>(this, context, additionalMethods){
                        final /* synthetic */ FourthAnalyzerMincer this$0;
                        final /* synthetic */ WorkerContext $context$inlined;
                        final /* synthetic */ ArrayList $additionalMethods$inlined;
                        {
                            this.this$0 = fourthAnalyzerMincer;
                            this.$context$inlined = workerContext;
                            this.$additionalMethods$inlined = arrayList;
                            super(1);
                        }

                        public final void invoke(@NotNull Pair<? extends AbstractInsnNode, ? extends Set<SideName>> $instruction_sides) {
                            Intrinsics.checkParameterIsNotNull($instruction_sides, (String)"<name for destructuring parameter 0>");
                            AbstractInsnNode instruction = (AbstractInsnNode)$instruction_sides.component1();
                            Set sides = (Set)$instruction_sides.component2();
                            if (instruction instanceof InvokeDynamicInsnNode) {
                                MethodNode m = FourthAnalyzerMincer.access$analyzeInvokeDynamic(this.this$0, (InvokeDynamicInsnNode)instruction, this.$context$inlined, sides);
                                if (m != null) {
                                    Collection collection = this.$additionalMethods$inlined;
                                    collection.add(m);
                                }
                            } else if (instruction instanceof TypeInsnNode) {
                                FourthAnalyzerMincer.access$analyzeTypeInsn(this.this$0, (TypeInsnNode)instruction, this.$context$inlined, sides);
                            }
                        }
                    }));
                }
                catch (Exception e) {
                    throw (Throwable)new RuntimeException("Exception while processing method " + it.name + it.desc, e);
                }
                catch (Error e) {
                    throw (Throwable)new Error("Error while processing method " + it.name + it.desc, e);
                }
            }
        }
        node.methods.addAll(additionalMethods);
        return additionalMethods.isEmpty() ? MincerResultType.SKIPPED : MincerResultType.MODIFIED;
    }

    private final void analyzeTypeInsn(TypeInsnNode instruction, WorkerContext<ProjectModel, ProjectModel> context, Set<SideName> sides) {
        Type type = Type.getObjectType(instruction.desc);
        Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"Type.getObjectType(instruction.desc)");
        String string = type.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Type.getObjectType(instruction.desc).internalName");
        ClassTypeReference type2 = new ClassTypeReference(StringsKt.replace$default((String)string, (char)'/', (char)'.', (boolean)false, (int)4, null));
        try {
            context.getMincer().getNodes().makeNode(type2);
        }
        catch (Exception e) {
            return;
        }
        if (StringsKt.startsWith$default((String)type2.getName(), (String)context.getName().getName(), (boolean)false, (int)2, null)) {
            boolean bl;
            block7: {
                Iterable $receiver$iv = CollectionsKt.drop((Iterable)type2.getPath(), (int)context.getName().getPath().size());
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        String it = (String)element$iv;
                        if (!(StringsKt.toIntOrNull((String)it) != null)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                context.getInput().getSidesTree().set(type2.getPath(), sides);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final MethodNode analyzeInvokeDynamic(InvokeDynamicInsnNode instruction, WorkerContext<ProjectModel, ProjectModel> context, Set<SideName> sides) {
        Handle handle = instruction.bsm;
        Intrinsics.checkExpressionValueIsNotNull((Object)handle, (String)"instruction.bsm");
        if (Intrinsics.areEqual((Object)handle.getOwner(), (Object)"java/lang/invoke/LambdaMetafactory")) {
            Handle handle2 = instruction.bsm;
            Intrinsics.checkExpressionValueIsNotNull((Object)handle2, (String)"instruction.bsm");
            if (Intrinsics.areEqual((Object)handle2.getName(), (Object)"metafactory") ^ true) {
                Handle handle3 = instruction.bsm;
                Intrinsics.checkExpressionValueIsNotNull((Object)handle3, (String)"instruction.bsm");
                if (Intrinsics.areEqual((Object)handle3.getName(), (Object)"altMetafactory")) {
                    String string = "WTF";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
            Handle handle4 = instruction.bsm;
            Intrinsics.checkExpressionValueIsNotNull((Object)handle4, (String)"instruction.bsm");
            if (Intrinsics.areEqual((Object)handle4.getName(), (Object)"altMetafactory")) {
                boolean serializable;
                Object object = instruction.bsmArgs[3];
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                boolean bl = serializable = ((Integer)object & 1) != 0;
                if (serializable) {
                    String string = "\u041e\u0421\u0423\u0416\u0414\u0410\u042e";
                    System.out.println((Object)string);
                }
            }
            Type type = Type.getReturnType(instruction.desc);
            Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"Type.getReturnType(instruction.desc)");
            ClassTypeReference targetInterface = ClassTypeReference.Companion.fromDesc(type);
            InvokeClass invokeClass = CutterUtils.INSTANCE.findInvokeClass(targetInterface, context.getMincer(), context.getInput());
            Object object = instruction.bsmArgs[1];
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.objectweb.asm.Handle");
            }
            Handle implMethod = (Handle)object;
            if (Intrinsics.areEqual((Object)implMethod.getOwner(), (Object)StringsKt.replace$default((String)context.getName().getName(), (char)'.', (char)'/', (boolean)false, (int)4, null))) {
                Object v10;
                Set set;
                block29: {
                    ClassInfo classInfo = context.getInfo();
                    if (classInfo == null) {
                        Intrinsics.throwNpe();
                    }
                    List<MethodNode> list = classInfo.getNode().methods;
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"context.info!!.node.methods");
                    Set set2 = set = (Set)((Object)list);
                    for (Object t : set2) {
                        MethodNode it = (MethodNode)t;
                        if (!(Intrinsics.areEqual((Object)it.name, (Object)implMethod.getName()) && Intrinsics.areEqual((Object)it.desc, (Object)implMethod.getDesc()))) continue;
                        v10 = t;
                        break block29;
                    }
                    v10 = null;
                }
                if (v10 == null) {
                    Intrinsics.throwNpe();
                }
                MethodNode lambdaMethod = v10;
                if ((lambdaMethod.access & 0x1000) != 0 || invokeClass != null) {
                    if (invokeClass != null) {
                        String string = implMethod.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"implMethod.name");
                        String string2 = implMethod.getDesc();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"implMethod.desc");
                        context.getInput().getLambdaMethods().computeIfAbsent(context.getName(), analyzeInvokeDynamic.1.INSTANCE).add(new MethodDesc(string, string2));
                    }
                    set = sides;
                    List list = CollectionsKt.plus((Collection)context.getName().getPath(), (Object)(implMethod.getName() + implMethod.getDesc()));
                    SidesTree sidesTree = context.getInput().getSidesTree();
                    Set it = set;
                    Set set3 = invokeClass != null ? CollectionsKt.toSet((Iterable)MiscellaneousKt.intersection(it, (Collection)invokeClass.getSides())) : it;
                    sidesTree.set(list, set3);
                }
            } else if (invokeClass != null) {
                int n;
                String name = "lambda$" + this.lambdasCounter + '$' + this.sha1(implMethod.getOwner() + "." + implMethod.getName() + implMethod.getDesc());
                Object[] objectArray = Type.getArgumentTypes(implMethod.getDesc());
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"Type.getArgumentTypes(implMethod.desc)");
                List parameters2 = ArraysKt.toMutableList((Object[])objectArray);
                if (implMethod.getTag() == 5 || implMethod.getTag() == 7 || implMethod.getTag() == 9) {
                    parameters2.add(0, Type.getType("L" + implMethod.getOwner() + ";"));
                } else if (implMethod.getTag() != 6 && implMethod.getTag() != 8) {
                    return null;
                }
                Type returnType = Type.getReturnType(implMethod.getDesc());
                StringBuilder stringBuilder = new StringBuilder().append("(").append(CollectionsKt.joinToString$default((Iterable)parameters2, (CharSequence)"", null, null, (int)0, null, (Function1)analyzeInvokeDynamic.desc.1.INSTANCE, (int)30, null)).append(")");
                Type type2 = returnType;
                Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"returnType");
                String desc2 = stringBuilder.append(type2.getDescriptor()).toString();
                MethodNode method2 = new MethodNode(4105, name, desc2, null, null);
                method2.visitCode();
                boolean it = false;
                for (Type type3 : (Iterable)parameters2) {
                    void index;
                    method2.visitVarInsn(type3.getOpcode(21), (int)index);
                    ++index;
                }
                if (implMethod.getTag() == 8) {
                    method2.visitTypeInsn(187, implMethod.getOwner());
                    method2.visitInsn(89);
                }
                switch (implMethod.getTag()) {
                    case 5: {
                        n = 182;
                        break;
                    }
                    case 7: 
                    case 8: {
                        n = 183;
                        break;
                    }
                    case 6: {
                        n = 184;
                        break;
                    }
                    case 9: {
                        n = 185;
                        break;
                    }
                    default: {
                        String string = "WTF";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                }
                int opcode = n;
                method2.visitMethodInsn(opcode, implMethod.getOwner(), implMethod.getName(), implMethod.getDesc(), implMethod.isInterface());
                if (Intrinsics.areEqual((Object)returnType.getDescriptor(), (Object)"V")) {
                    method2.visitInsn(177);
                } else {
                    method2.visitInsn(returnType.getOpcode(172));
                }
                Object[] objectArray2 = instruction.bsmArgs;
                ClassInfo classInfo = context.getInfo();
                if (classInfo == null) {
                    Intrinsics.throwNpe();
                }
                objectArray2[1] = new Handle(6, classInfo.getNode().name, name, desc2, context.getInfo().getData().getAccess().isInterface());
                context.getInput().getLambdaMethods().computeIfAbsent(context.getName(), analyzeInvokeDynamic.3.INSTANCE).add(new MethodDesc(name, desc2));
                context.getInput().getSidesTree().set(CollectionsKt.plus((Collection)context.getName().getPath(), (Object)(name + desc2)), CollectionsKt.toSet((Iterable)MiscellaneousKt.intersection(sides, (Collection)invokeClass.getSides())));
                return method2;
            }
        }
        return null;
    }

    private final String sha1(@NotNull String $receiver) {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        String string = $receiver;
        MessageDigest messageDigest = digest;
        Charset charset = Charsets.UTF_8;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byte[] checksum = messageDigest.digest(byArray2);
        String string3 = new BigInteger(1, checksum).toString(16);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"BigInteger(1, checksum).toString(16)");
        return string3;
    }

    @Override
    public void endProcessing(@NotNull ProjectModel input, @Nullable MincerArchive cache, @NotNull InheritanceHelper inheritance, @NotNull Pipeline<? super ProjectModel, ProjectModel> pipeline) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)inheritance, (String)"inheritance");
        Intrinsics.checkParameterIsNotNull(pipeline, (String)"pipeline");
        input.getSidesTree().identify(null);
        pipeline.setValue(input);
        if (Intrinsics.areEqual((Object)System.getProperty("print-sides"), (Object)"true")) {
            ProjectModel projectModel = pipeline.getValue();
            if (projectModel == null) {
                Intrinsics.throwNpe();
            }
            String string = SidesTree.toString$default(projectModel.getSidesTree(), CollectionsKt.toSet((Iterable)this.primalSides), null, 2, null);
            System.out.println((Object)string);
        }
    }

    public FourthAnalyzerMincer(@NotNull Set<SideName> primalSides, @NotNull List<? extends DynSideMarker> markers) {
        Intrinsics.checkParameterIsNotNull(primalSides, (String)"primalSides");
        Intrinsics.checkParameterIsNotNull(markers, (String)"markers");
        this.primalSides = primalSides;
        this.markers = markers;
    }

    @Override
    public void startProcessing(@NotNull ProjectModel input, @Nullable MincerArchive cache, @NotNull InheritanceHelper inheritance, @NotNull Pipeline<? super ProjectModel, ProjectModel> pipeline) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)inheritance, (String)"inheritance");
        Intrinsics.checkParameterIsNotNull(pipeline, (String)"pipeline");
        SubMincer.DefaultImpls.startProcessing(this, input, cache, inheritance, pipeline);
    }

    @Nullable
    public static final /* synthetic */ MethodNode access$analyzeInvokeDynamic(FourthAnalyzerMincer $this, @NotNull InvokeDynamicInsnNode instruction, @NotNull WorkerContext context, @NotNull Set sides) {
        return $this.analyzeInvokeDynamic(instruction, context, sides);
    }

    public static final /* synthetic */ void access$analyzeTypeInsn(FourthAnalyzerMincer $this, @NotNull TypeInsnNode instruction, @NotNull WorkerContext context, @NotNull Set sides) {
        $this.analyzeTypeInsn(instruction, context, sides);
    }
}

