/*
 * Decompiled with CFR 0.152.
 */
package ru.justagod.mincer.util;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.zeroturnaround.zip.ZipEntryCallback;
import org.zeroturnaround.zip.ZipUtil;
import ru.justagod.mincer.control.MincerControlPane;
import ru.justagod.mincer.control.MincerResult;
import ru.justagod.mincer.control.MincerResultType;
import ru.justagod.mincer.util.MincerUtils;
import ru.justagod.mincer.util.recursiveness.ByteArraySource;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\r2\u0006\u0010\u000e\u001a\u00020\b\u00a8\u0006\u000f"}, d2={"Lru/justagod/mincer/util/MincerUtils;", "", "()V", "processFolder", "", "panel", "Lru/justagod/mincer/control/MincerControlPane;", "folder", "Ljava/io/File;", "readZip", "Ljava/util/HashMap;", "", "Lru/justagod/mincer/util/recursiveness/ByteArraySource;", "Lkotlin/collections/HashMap;", "file", "cutter"})
public final class MincerUtils {
    public static final MincerUtils INSTANCE;

    public final void processFolder(@NotNull MincerControlPane panel, @NotNull File folder) {
        Intrinsics.checkParameterIsNotNull((Object)panel, (String)"panel");
        Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
        do {
            for (File f : SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)folder)), (Function1)processFolder.1.INSTANCE)) {
                File file = f.getAbsoluteFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"f.absoluteFile");
                File file2 = folder.getAbsoluteFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"folder.absoluteFile");
                File name = FilesKt.relativeTo((File)file, (File)file2);
                long lastModified = f.lastModified();
                byte[] content = FilesKt.readBytes((File)f);
                String string = name.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name.path");
                MincerResult result = panel.advance(content, string, lastModified);
                if (result.getType() == MincerResultType.MODIFIED) {
                    FilesKt.writeBytes((File)f, (byte[])result.getResultedBytecode());
                    continue;
                }
                if (result.getType() != MincerResultType.DELETED) continue;
                f.delete();
            }
        } while (panel.endIteration());
    }

    @NotNull
    public final HashMap<String, ByteArraySource> readZip(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        HashMap<String, ByteArraySource> result = new HashMap<String, ByteArraySource>();
        ZipUtil.iterate((File)file, (ZipEntryCallback)new ZipEntryCallback(result){
            final /* synthetic */ HashMap $result;

            public final void process(InputStream input, ZipEntry entry) {
                ZipEntry zipEntry = entry;
                Intrinsics.checkExpressionValueIsNotNull((Object)zipEntry, (String)"entry");
                if (!zipEntry.isDirectory()) {
                    Map map = this.$result;
                    String string = entry.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.name");
                    String string2 = string;
                    String string3 = entry.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"entry.name");
                    InputStream inputStream = input;
                    if (inputStream == null) {
                        Intrinsics.throwNpe();
                    }
                    ByteArraySource byteArraySource = new ByteArraySource(string3, ByteStreamsKt.readBytes((InputStream)inputStream, (int)256));
                    map.put(string2, byteArraySource);
                }
            }
            {
                this.$result = hashMap;
            }
        });
        return result;
    }

    private MincerUtils() {
    }

    static {
        MincerUtils mincerUtils;
        INSTANCE = mincerUtils = new MincerUtils();
    }
}

