/*
 * Decompiled with CFR 0.152.
 */
package ru.justagod.mincer.util;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.justagod.mincer.control.MincerArchive;
import ru.justagod.mincer.control.MincerFS;
import ru.justagod.model.ClassTypeReference;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\nH\u0016J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lru/justagod/mincer/util/MincerDecentFS;", "Lru/justagod/mincer/control/MincerFS;", "root", "Ljava/io/File;", "(Ljava/io/File;)V", "getRoot", "()Ljava/io/File;", "pullArchive", "Lru/justagod/mincer/control/MincerArchive;", "id", "", "pullClass", "", "path", "pushArchive", "", "processedClasses", "", "pushGeneratedClass", "bytecode", "cutter"})
public final class MincerDecentFS
implements MincerFS {
    @NotNull
    private final File root;

    @Override
    public void pushGeneratedClass(@NotNull String path2, @NotNull byte[] bytecode) {
        Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)bytecode, (String)"bytecode");
        File file = FilesKt.resolve((File)this.root, (File)new File(path2)).getAbsoluteFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"root.resolve(File(path)).absoluteFile");
        FilesKt.writeBytes((File)file, (byte[])bytecode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushArchive(@NotNull String id, @NotNull Set<String> processedClasses) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull(processedClasses, (String)"processedClasses");
        File file = FilesKt.resolve((File)this.root, (String)(id + ".archive"));
        Object object2 = file;
        Object object3 = Charsets.UTF_8;
        int n = 8192;
        Object object4 = object = object2;
        object4 = new FileOutputStream((File)object4);
        object = new OutputStreamWriter((OutputStream)object4, (Charset)object3);
        BufferedWriter writer = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
        object2 = writer;
        object3 = null;
        try {
            BufferedWriter it = (BufferedWriter)object2;
            for (String entry : processedClasses) {
                writer.write(entry);
                writer.newLine();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public MincerArchive pullArchive(@NotNull String id) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        File file = FilesKt.resolve((File)this.root, (String)(id + ".archive"));
        if (!file.exists()) {
            return null;
        }
        long lastModified = file.lastModified();
        Iterable iterable = $receiver$iv = (Iterable)FilesKt.readLines$default((File)file, null, (int)1, null);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            ClassTypeReference classTypeReference = new ClassTypeReference((String)it);
            collection.add(classTypeReference);
        }
        List members = (List)destination$iv$iv;
        return new MincerArchive(members, lastModified);
    }

    @Override
    @Nullable
    public byte[] pullClass(@NotNull String path2) {
        Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
        File file = FilesKt.resolve((File)this.root, (String)path2);
        if (!file.exists()) {
            return null;
        }
        return FilesKt.readBytes((File)file);
    }

    @NotNull
    public final File getRoot() {
        return this.root;
    }

    public MincerDecentFS(@NotNull File root) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        this.root = root;
    }
}

