/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import pw.prok.imagine.reflect.IFilter;
import pw.prok.imagine.reflect.IScanner;

public class GetSetMethodFilter
implements IFilter {
    private final boolean mGet;
    private final boolean mSet;

    public GetSetMethodFilter(boolean get, boolean set) {
        this.mGet = get;
        this.mSet = set;
    }

    @Override
    public <S> IFilter.FilterResult filterClass(IScanner scanner, Class<S> mainClass) {
        return IFilter.FilterResult.Default;
    }

    @Override
    public <S> IFilter.FilterResult filterField(IScanner scanner, Class<S> mainClass, Class<? super S> childClass, Field field) {
        return IFilter.FilterResult.Default;
    }

    @Override
    public <S> IFilter.FilterResult filterMethod(IScanner scanner, Class<S> mainClass, Class<? super S> childClass, Method method) {
        String name = method.getName();
        if (name.length() > 4) {
            if (this.mGet && name.startsWith("get")) {
                return IFilter.FilterResult.Default;
            }
            if (this.mSet && name.startsWith("set")) {
                return IFilter.FilterResult.Default;
            }
            return IFilter.FilterResult.Reject;
        }
        return IFilter.FilterResult.Reject;
    }

    public static boolean isGetMethod(Method method) {
        return method.getName().startsWith("get");
    }

    public static boolean isSetMethod(Method method) {
        return method.getName().startsWith("set");
    }

    public static String getVarName(Method method) {
        char[] chars = method.getName().substring(3).toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }
}

