/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.pool;

import pw.prok.imagine.pool.DynamicPool;
import pw.prok.imagine.pool.FixedPool;
import pw.prok.imagine.pool.Pool;
import pw.prok.imagine.pool.PoolFactory;
import pw.prok.imagine.pool.ReflectionFactory;

public class Pools {
    public static <T> Pool<T> create(int initialCount, int maxCount, PoolFactory<T> factory) {
        return new FixedPool<T>(factory, initialCount, maxCount);
    }

    public static <T> Pool<T> create(int initialCount, int maxCount, Class<T> clazz, Object ... args) {
        return new FixedPool<T>(new ReflectionFactory<T>(clazz, args), initialCount, maxCount);
    }

    public static <T> Pool<T> create(int count, PoolFactory<T> factory) {
        return new FixedPool<T>(factory, count);
    }

    public static <T> Pool<T> create(int count, Class<T> clazz, Object ... args) {
        return new FixedPool<T>(new ReflectionFactory<T>(clazz, args), count);
    }

    public static <T> Pool<T> create(PoolFactory<T> factory) {
        return new DynamicPool<T>(factory);
    }

    public static <T> Pool<T> create(Class<T> clazz, Object ... args) {
        return new DynamicPool<T>(new ReflectionFactory<T>(clazz, args));
    }
}

