/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.object;

import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import pw.prok.imagine.api.Member;
import pw.prok.imagine.api.Pair;
import pw.prok.imagine.inject.Creator;
import pw.prok.imagine.object.FieldHandler;
import pw.prok.imagine.object.IHandler;
import pw.prok.imagine.object.MethodHandler;
import pw.prok.imagine.object.nbt.INBTHandler;
import pw.prok.imagine.reflect.GetSetMethodFilter;
import pw.prok.imagine.reflect.IMemberScanCallback;
import pw.prok.imagine.reflect.ImagineReflect;
import pw.prok.imagine.writer.WritableBuf;

public class ImagineObject {
    private static final ObjectState EMPTY_STATE = new ObjectState(null, 0, null, null, null);
    private static Map<Class<?>, ObjectState> sStates = new HashMap();
    private static Map<Class<?>, INBTHandler<?, ?>> sNBTHandlers = new HashMap();
    private static final MethodHandler METHOD_HANDLER;
    private static final FieldHandler FIELD_HANDLER;

    private static <T> ObjectState getState(Class<T> clazz) {
        ObjectState state = sStates.get(clazz);
        if (state == null) {
            state = ImagineObject.parseState(clazz);
            sStates.put(clazz, state);
        }
        if (state == EMPTY_STATE) {
            return null;
        }
        return state;
    }

    public static <T> T copy(T object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        ObjectState state = ImagineObject.getState(clazz);
        Object newObject = Creator.creator(clazz).build();
        if (state == null) {
            return (T)newObject;
        }
        try {
            for (int i = 0; i < state.mSize; ++i) {
                Object value = state.get(i, object);
                state.set(i, newObject, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to copy object", e);
        }
        return (T)newObject;
    }

    public static <T> NBTBase nbt(T object) {
        if (object == null) {
            return null;
        }
        if (object instanceof NBTBase) {
            return (NBTBase)object;
        }
        Class<?> clazz = object.getClass();
        ObjectState state = ImagineObject.getState(clazz);
        if (state == null) {
            return null;
        }
        NBTTagCompound nbt = state.newNBT();
        try {
            for (int i = 0; i < state.mSize; ++i) {
                Object object2 = state.get(i, object);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create nbt", e);
        }
        return nbt;
    }

    public static <T> void write(T object, WritableBuf buf) {
        buf.writeClass(object.getClass());
        buf.writeNBT(ImagineObject.nbt(object));
    }

    private static <T> ObjectState parseState(Class<T> clazz) {
        final HashMap members = new HashMap();
        ImagineReflect.create().addGetSetFilter(true, true).addAnnotationFilter(Member.class, false, true, true).scanMembers(clazz, new IMemberScanCallback<T>(){

            @Override
            public void scanMethod(Class<T> mainClass, Class<? super T> childClass, Method method) {
                Member member = method.getAnnotation(Member.class);
                String name = member.name();
                if (name.length() == 0) {
                    name = GetSetMethodFilter.getVarName(method);
                }
                boolean get = GetSetMethodFilter.isGetMethod(method);
                Pair<Pair<MethodHandler, Method>, Pair<MethodHandler, Method>> memberPair = (Pair<Pair<MethodHandler, Method>, Pair<MethodHandler, Method>>)members.get(name);
                if (memberPair == null) {
                    memberPair = new Pair<Pair<MethodHandler, Method>, Pair<MethodHandler, Method>>();
                    members.put(name, memberPair);
                }
                Pair<MethodHandler, Method> handlerPair = new Pair<MethodHandler, Method>(METHOD_HANDLER, method);
                if (get) {
                    memberPair.first(handlerPair);
                } else {
                    memberPair.second(handlerPair);
                }
            }

            @Override
            public void scanField(Class<T> mainClass, Class<? super T> childClass, Field field) {
                Pair<Pair<FieldHandler, Field>, Pair<FieldHandler, Field>> memberPair;
                Member member = field.getAnnotation(Member.class);
                String name = member.name();
                if (name.length() == 0) {
                    name = field.getName();
                }
                if ((memberPair = (Pair<Pair<FieldHandler, Field>, Pair<FieldHandler, Field>>)members.get(name)) == null) {
                    memberPair = new Pair<Pair<FieldHandler, Field>, Pair<FieldHandler, Field>>();
                    members.put(name, memberPair);
                }
                Pair<FieldHandler, Field> handlerPair = new Pair<FieldHandler, Field>(FIELD_HANDLER, field);
                if (member.load()) {
                    memberPair.first(handlerPair);
                }
                if (member.save()) {
                    memberPair.second(handlerPair);
                }
            }
        });
        int size = members.size();
        if (size == 0) {
            return EMPTY_STATE;
        }
        String[] names = new String[size];
        Pair[] getHandlers = new Pair[size];
        Pair[] setHandlers = new Pair[size];
        int i = 0;
        TreeSet set = Sets.newTreeSet((Comparator)new Comparator<Map.Entry<String, Pair<Pair<IHandler<?>, Object>, Pair<IHandler<?>, Object>>>>(){

            @Override
            public int compare(Map.Entry<String, Pair<Pair<IHandler<?>, Object>, Pair<IHandler<?>, Object>>> o1, Map.Entry<String, Pair<Pair<IHandler<?>, Object>, Pair<IHandler<?>, Object>>> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        set.addAll(members.entrySet());
        for (Map.Entry p : set) {
            names[i] = (String)p.getKey();
            getHandlers[i] = (Pair)((Pair)p.getValue()).first();
            setHandlers[i] = (Pair)((Pair)p.getValue()).second();
            ++i;
        }
        return new ObjectState(clazz, size, names, getHandlers, setHandlers);
    }

    static {
        System.out.println("Loaded!");
        METHOD_HANDLER = new MethodHandler();
        FIELD_HANDLER = new FieldHandler();
    }

    private static final class ObjectState {
        private final Class<?> mClass;
        private final int mSize;
        private final String[] mNames;
        private final Pair<IHandler<?>, Object>[] mGetHandlers;
        private final Pair<IHandler<?>, Object>[] mSetHandlers;

        public ObjectState(Class<?> clazz, int size, String[] names, Pair<IHandler<?>, Object>[] getHandlers, Pair<IHandler<?>, Object>[] setHandlers) {
            this.mClass = clazz;
            this.mSize = size;
            this.mNames = names;
            this.mGetHandlers = getHandlers;
            this.mSetHandlers = getHandlers;
        }

        public Object get(int i, Object o) throws Exception {
            Pair<IHandler<?>, Object> p = this.mGetHandlers[i];
            IHandler<?> handler = p.first();
            return handler.getData(o, p.second());
        }

        public void set(int i, Object o, Object value) throws Exception {
            Pair<IHandler<?>, Object> p = this.mSetHandlers[i];
            IHandler<?> handler = p.first();
            handler.putData(o, p.second(), value);
        }

        public NBTTagCompound newNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("imagine:class", this.mClass.getName());
            return nbt;
        }
    }
}

