/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.network;

import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.ChannelHandler;
import io.netty.util.AttributeKey;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import pw.prok.imagine.network.ImaginePacket;
import pw.prok.imagine.network.ImaginePacketCodec;
import pw.prok.imagine.network.ImaginePacketHandler;
import pw.prok.imagine.pool.Pool;
import pw.prok.imagine.pool.Pools;

public class ImagineNetwork {
    private static final Map<Class<?>, Pool<? extends ImaginePacket>> sPacketPool = new HashMap();
    public static final AttributeKey<ImagineNetwork> PACKET_NETWORK = new AttributeKey("imagine:network");
    private final FMLEmbeddedChannel mServerChannel;
    private final FMLEmbeddedChannel mClientChannel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ImaginePacket> T obtainPacket(Class<T> packetClass) {
        Pool<ImaginePacket> pool = sPacketPool.get(packetClass);
        if (pool == null) {
            Map<Class<?>, Pool<? extends ImaginePacket>> map = sPacketPool;
            synchronized (map) {
                pool = sPacketPool.get(packetClass);
                if (pool == null) {
                    pool = Pools.create(packetClass, new Object[0]);
                    sPacketPool.put(packetClass, pool);
                }
            }
        }
        return (T)pool.obtain();
    }

    public static <T extends ImaginePacket> void releasePacket(T packet) {
        Pool<? extends ImaginePacket> pool = sPacketPool.get(packet.getClass());
        pool.release(packet);
    }

    public ImagineNetwork(String channelName) {
        EnumMap channels = NetworkRegistry.INSTANCE.newChannel(channelName, new ChannelHandler[]{new ImaginePacketCodec(this), new ImaginePacketHandler()});
        this.mServerChannel = (FMLEmbeddedChannel)channels.get(Side.SERVER);
        this.mClientChannel = (FMLEmbeddedChannel)channels.get(Side.CLIENT);
    }

    public void sendAllAround(ImaginePacket packet, TileEntity tileEntity, double range) {
        this.sendAllAround(packet, new NetworkRegistry.TargetPoint(tileEntity.func_145831_w().field_73011_w.field_76574_g, (double)tileEntity.field_145851_c, (double)tileEntity.field_145848_d, (double)tileEntity.field_145849_e, range));
    }

    public void sendAllAround(ImaginePacket packet, World world, double x, double y, double z, double range) {
        this.sendAllAround(packet, new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, x, y, z, range));
    }

    public void sendAllAround(ImaginePacket packet, NetworkRegistry.TargetPoint point) {
        this.mServerChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.mServerChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.mServerChannel.writeOutbound(new Object[]{packet});
    }

    public void sendToPlayer(ImaginePacket packet, EntityPlayer player) {
        this.mServerChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.mServerChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.mServerChannel.writeOutbound(new Object[]{packet});
    }

    public void sendToWorld(ImaginePacket packet, World world) {
        this.mServerChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.mServerChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)world.field_73011_w.field_76574_g);
        this.mServerChannel.writeOutbound(new Object[]{packet});
    }

    public void sendToAll(ImaginePacket packet) {
        this.mServerChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.mServerChannel.writeOutbound(new Object[]{packet});
    }

    public void send(ImaginePacket packet) {
        this.mClientChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.mClientChannel.writeOutbound(new Object[]{packet});
    }
}

