/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.collections;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class LazyIterable<T>
implements Iterable<T> {
    private final LazyAction<T> mAction;
    private final boolean mOneTime;
    private Iterator<T> mIterator;
    private List<T> mCacheList;

    public LazyIterable(LazyAction<T> action) {
        this(action, true);
    }

    public LazyIterable(LazyAction<T> action, boolean oneTime) {
        this.mAction = action;
        this.mOneTime = oneTime;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.mOneTime) {
            if (this.mIterator == null) {
                this.mIterator = new OneTimeIterator<T>(this.mAction);
            }
            return this.mIterator;
        }
        if (this.mIterator == null) {
            this.mCacheList = new LinkedList<T>();
            this.mIterator = new CacheIterator<T>(this.mAction, this.mCacheList);
            return this.mIterator;
        }
        return this.mCacheList.iterator();
    }

    private static class CacheIterator<T>
    extends OneTimeIterator<T> {
        private final List<T> mCache;
        private T mPrev;

        public CacheIterator(LazyAction<T> action, List<T> cache) {
            super(action);
            this.mCache = cache;
        }

        @Override
        public T next() {
            this.mPrev = super.next();
            Object object = this.mPrev;
            if (object != null) {
                this.mCache.add(object);
            }
            return object;
        }

        @Override
        public void remove() {
            if (this.mPrev == null) {
                throw new IllegalStateException();
            }
            if (this.mCache.remove(this.mCache.size() - 1) != this.mPrev) {
                throw new IllegalStateException();
            }
            this.mPrev = null;
        }
    }

    private static class OneTimeIterator<T>
    implements Iterator<T> {
        private final LazyAction<T> mAction;
        private T mNext;
        private boolean mEnd = false;

        public OneTimeIterator(LazyAction<T> action) {
            this.mAction = action;
        }

        @Override
        public boolean hasNext() {
            if (this.mEnd) {
                return false;
            }
            if (this.mNext != null) {
                return true;
            }
            this.mNext = this.mAction.acquire();
            if (this.mNext == null) {
                this.mEnd = true;
                return false;
            }
            return true;
        }

        @Override
        public T next() {
            T object = this.hasNext() ? (T)this.mNext : null;
            this.mNext = null;
            return object;
        }

        @Override
        public void remove() {
        }
    }

    public static interface LazyAction<T> {
        public T acquire();
    }
}

