/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.text.csv;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.Transaction;
import com.avaje.ebean.text.csv.CsvCallback;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCsvCallback<T>
implements CsvCallback<T> {
    private static final Logger logger = Logger.getLogger(DefaultCsvCallback.class.getName());
    protected Transaction transaction;
    protected boolean createdTransaction;
    protected EbeanServer server;
    protected int logInfoFrequency;
    protected int persistBatchSize;
    protected long startTime;
    protected long exeTime;

    public DefaultCsvCallback() {
        this(30, 1000);
    }

    public DefaultCsvCallback(int persistBatchSize, int logInfoFrequency) {
        this.persistBatchSize = persistBatchSize;
        this.logInfoFrequency = logInfoFrequency;
    }

    @Override
    public void begin(EbeanServer server) {
        this.server = server;
        this.startTime = System.currentTimeMillis();
        this.initTransactionIfRequired();
    }

    @Override
    public void readHeader(String[] line) {
    }

    @Override
    public boolean processLine(int row, String[] line) {
        return true;
    }

    @Override
    public void processBean(int row, String[] line, T bean) {
        this.server.save(bean, this.transaction);
        if (this.logInfoFrequency > 0 && row % this.logInfoFrequency == 0) {
            logger.info("processed " + row + " rows");
        }
    }

    @Override
    public void end(int row) {
        this.commitTransactionIfCreated();
        this.exeTime = System.currentTimeMillis() - this.startTime;
        logger.info("Csv finished, rows[" + row + "] exeMillis[" + this.exeTime + "]");
    }

    @Override
    public void endWithError(int row, Exception e) {
        this.rollbackTransactionIfCreated(e);
    }

    protected void initTransactionIfRequired() {
        this.transaction = this.server.currentTransaction();
        if (this.transaction == null || !this.transaction.isActive()) {
            this.transaction = this.server.beginTransaction();
            this.createdTransaction = true;
            if (this.persistBatchSize > 1) {
                logger.info("Creating transaction, batchSize[" + this.persistBatchSize + "]");
                this.transaction.setBatchMode(true);
                this.transaction.setBatchSize(this.persistBatchSize);
            } else {
                this.transaction.setBatchMode(false);
                logger.info("Creating transaction with no JDBC batching");
            }
        }
    }

    protected void commitTransactionIfCreated() {
        if (this.createdTransaction) {
            this.transaction.commit();
            logger.info("Committed transaction");
        }
    }

    protected void rollbackTransactionIfCreated(Throwable e) {
        if (this.createdTransaction) {
            this.transaction.rollback(e);
            logger.info("Rolled back transaction");
        }
    }
}

