/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.impl.InternalObjByteMapOps;
import com.koloboke.collect.impl.hash.MutableQHashSeparateKVObjKeyMap;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.impl.hash.SeparateKVObjByteQHash;
import com.koloboke.collect.map.hash.HashObjByteMap;
import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;

public abstract class MutableQHashSeparateKVObjByteMapSO<K>
extends MutableQHashSeparateKVObjKeyMap<K>
implements HashObjByteMap<K>,
InternalObjByteMapOps<K>,
SeparateKVObjByteQHash {
    byte[] values;

    void copy(SeparateKVObjByteQHash hash) {
        super.copy(hash);
        this.values = (byte[])hash.valueArray().clone();
    }

    void move(SeparateKVObjByteQHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public byte[] valueArray() {
        return this.values;
    }

    int valueIndex(byte value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        Object[] keys = this.set;
        byte[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == FREE || value != vals[i]) continue;
                index = i;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED || value != vals[i]) continue;
                index = i;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(byte value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(byte value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        return this.containsValue((Byte)value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int insert(K key, byte value) {
        block27: {
            if (key == null) return this.insertNullKey(value);
            Object[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(key)) % capacity;
            Object cur = keys[index];
            if (cur != FREE) {
                int firstRemoved;
                if (cur == key) {
                    return index;
                }
                if (cur != REMOVED) {
                    if (this.keyEquals(key, cur)) return index;
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == FREE) {
                                index = bIndex;
                                break block27;
                            }
                            if (cur == key || this.keyEquals(key, cur)) {
                                return bIndex;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == FREE) {
                                index = fIndex;
                                break block27;
                            }
                            if (cur == key || this.keyEquals(key, cur)) {
                                return fIndex;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == FREE) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block27;
                    }
                    if (cur == key) {
                        return bIndex;
                    }
                    if (cur != REMOVED) {
                        if (this.keyEquals(key, cur)) {
                            return bIndex;
                        }
                    } else if (firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == FREE) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block27;
                    }
                    if (cur == key) {
                        return fIndex;
                    }
                    if (cur != REMOVED) {
                        if (this.keyEquals(key, cur)) {
                            return fIndex;
                        }
                    } else if (firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                this.incrementModCount();
                keys[firstRemoved] = key;
                this.values[firstRemoved] = value;
                this.postRemovedSlotInsertHook();
                return -1;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postFreeSlotInsertHook();
        return -1;
    }

    int insertNullKey(byte value) {
        block21: {
            Object[] keys = this.set;
            int capacity = keys.length;
            int index = 0;
            Object cur = keys[0];
            if (cur != FREE) {
                int firstRemoved;
                if (cur == null) {
                    return index;
                }
                if (cur != REMOVED) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == FREE) {
                                index = bIndex;
                                break block21;
                            }
                            if (cur == null) {
                                return bIndex;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == FREE) {
                                index = fIndex;
                                break block21;
                            }
                            if (cur == null) {
                                return fIndex;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == FREE) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block21;
                    }
                    if (cur == null) {
                        return bIndex;
                    }
                    if (cur == REMOVED && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == FREE) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block21;
                    }
                    if (cur == null) {
                        return fIndex;
                    }
                    if (cur == REMOVED && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                this.incrementModCount();
                keys[firstRemoved] = null;
                this.values[firstRemoved] = value;
                this.postRemovedSlotInsertHook();
                return -1;
            }
        }
        this.incrementModCount();
        keys[index] = null;
        this.values[index] = value;
        this.postFreeSlotInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new byte[capacity];
    }
}

