/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.CharCollection;
import com.koloboke.collect.CharCursor;
import com.koloboke.collect.CharIterator;
import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractCharValueView;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonCharCharMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalCharCharMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.MutableQHashParallelKVCharCharMapSO;
import com.koloboke.collect.impl.hash.ParallelKVCharCharQHash;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.map.CharCharCursor;
import com.koloboke.collect.set.CharSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.CharBinaryOperator;
import com.koloboke.function.CharCharConsumer;
import com.koloboke.function.CharCharPredicate;
import com.koloboke.function.CharCharToCharFunction;
import com.koloboke.function.CharConsumer;
import com.koloboke.function.CharPredicate;
import com.koloboke.function.CharUnaryOperator;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class MutableQHashParallelKVCharCharMapGO
extends MutableQHashParallelKVCharCharMapSO {
    final void copy(ParallelKVCharCharQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVCharCharQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public char defaultValue() {
        return '\u0000';
    }

    public boolean containsEntry(char key, char value) {
        char free = this.freeValue;
        if (key != free && key != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == key) {
                return (char)(entry >>> 16) == value;
            }
            if (cur == free) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (char)(entry = tab[bIndex])) == key) {
                    return (char)(entry >>> 16) == value;
                }
                if (cur == free) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (char)(entry = tab[fIndex])) == key) {
                    return (char)(entry >>> 16) == value;
                }
                if (cur == free) {
                    return false;
                }
                step += 2;
            }
        }
        return false;
    }

    public Character get(Object key) {
        char free;
        char k = ((Character)key).charValue();
        if (k != (free = this.freeValue) && k != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)k) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == k) {
                return Character.valueOf((char)(entry >>> 16));
            }
            if (cur == free) {
                return null;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (char)(entry = tab[bIndex])) == k) {
                    return Character.valueOf((char)(entry >>> 16));
                }
                if (cur == free) {
                    return null;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (char)(entry = tab[fIndex])) == k) {
                    return Character.valueOf((char)(entry >>> 16));
                }
                if (cur == free) {
                    return null;
                }
                step += 2;
            }
        }
        return null;
    }

    public char get(char key) {
        char free = this.freeValue;
        if (key != free && key != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == key) {
                return (char)(entry >>> 16);
            }
            if (cur == free) {
                return this.defaultValue();
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (char)(entry = tab[bIndex])) == key) {
                    return (char)(entry >>> 16);
                }
                if (cur == free) {
                    return this.defaultValue();
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (char)(entry = tab[fIndex])) == key) {
                    return (char)(entry >>> 16);
                }
                if (cur == free) {
                    return this.defaultValue();
                }
                step += 2;
            }
        }
        return this.defaultValue();
    }

    public Character getOrDefault(Object key, Character defaultValue) {
        char free;
        char k = ((Character)key).charValue();
        if (k != (free = this.freeValue) && k != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)k) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == k) {
                return Character.valueOf((char)(entry >>> 16));
            }
            if (cur == free) {
                return defaultValue;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (char)(entry = tab[bIndex])) == k) {
                    return Character.valueOf((char)(entry >>> 16));
                }
                if (cur == free) {
                    return defaultValue;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (char)(entry = tab[fIndex])) == k) {
                    return Character.valueOf((char)(entry >>> 16));
                }
                if (cur == free) {
                    return defaultValue;
                }
                step += 2;
            }
        }
        return defaultValue;
    }

    public char getOrDefault(char key, char defaultValue) {
        char free = this.freeValue;
        if (key != free && key != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == key) {
                return (char)(entry >>> 16);
            }
            if (cur == free) {
                return defaultValue;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (char)(entry = tab[bIndex])) == key) {
                    return (char)(entry >>> 16);
                }
                if (cur == free) {
                    return defaultValue;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (char)(entry = tab[fIndex])) == key) {
                    return (char)(entry >>> 16);
                }
                if (cur == free) {
                    return defaultValue;
                }
                step += 2;
            }
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Character, ? super Character> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(Character.valueOf(key), Character.valueOf((char)(entry >>> 16)));
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                action.accept(Character.valueOf(key), Character.valueOf((char)(entry >>> 16)));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(CharCharConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(key, (char)(entry >>> 16));
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                action.accept(key, (char)(entry >>> 16));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(CharCharPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || predicate.test(key, (char)(entry >>> 16))) continue;
                terminated = true;
                break;
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed || predicate.test(key, (char)(entry >>> 16))) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public CharCharCursor cursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedMapCursor(mc);
        }
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonCharCharMapOps.containsAllEntries((InternalCharCharMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalCharCharMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || m.containsEntry(key, (char)(entry >>> 16))) continue;
                containsAll = false;
                break;
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed || m.containsEntry(key, (char)(entry >>> 16))) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalCharCharMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                m.justPut(key, (char)(entry >>> 16));
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                m.justPut(key, (char)(entry >>> 16));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Character, Character>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public CharCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                hashCode += key ^ (char)(entry >>> 16);
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                hashCode += key ^ (char)(entry >>> 16);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append((char)(entry >>> 16));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append((char)(entry >>> 16));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        int[] newTab = this.table;
        int capacity = newTab.length;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                int index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
                if (U.getChar(newTab, INT_BASE + CHAR_KEY_OFFSET + ((long)index << 2)) != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (U.getChar(newTab, INT_BASE + CHAR_KEY_OFFSET + ((long)bIndex << 2)) == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (U.getChar(newTab, INT_BASE + CHAR_KEY_OFFSET + ((long)fIndex << 2)) == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newTab[index] = entry;
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                int index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
                if (U.getChar(newTab, INT_BASE + CHAR_KEY_OFFSET + ((long)index << 2)) != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (U.getChar(newTab, INT_BASE + CHAR_KEY_OFFSET + ((long)bIndex << 2)) == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (U.getChar(newTab, INT_BASE + CHAR_KEY_OFFSET + ((long)fIndex << 2)) == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newTab[index] = entry;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Character put(Character key, Character value) {
        int entry;
        int index;
        int[] tab;
        block26: {
            char k = key.charValue();
            char removed = this.removedValue;
            char free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVCharKeyMixing.mix((char)k) % capacity;
            entry = tab[index];
            char cur = (char)entry;
            if (cur == free) {
                this.incrementModCount();
                tab[index] = k | value.charValue() << 16;
                this.postFreeSlotInsertHook();
                return null;
            }
            if (cur != k) {
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (char)(entry = tab[bIndex])) == free) {
                                this.incrementModCount();
                                tab[bIndex] = k | value.charValue() << 16;
                                this.postFreeSlotInsertHook();
                                return null;
                            }
                            if (cur == k) {
                                index = bIndex;
                                break block26;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (char)(entry = tab[fIndex])) == free) {
                                this.incrementModCount();
                                tab[fIndex] = k | value.charValue() << 16;
                                this.postFreeSlotInsertHook();
                                return null;
                            }
                            if (cur == k) {
                                index = fIndex;
                                break block26;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[bIndex] = k | value.charValue() << 16;
                            this.postFreeSlotInsertHook();
                            return null;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = k | value.charValue() << 16;
                        this.postRemovedSlotInsertHook();
                        return null;
                    }
                    if (cur == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[fIndex] = k | value.charValue() << 16;
                            this.postFreeSlotInsertHook();
                            return null;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = k | value.charValue() << 16;
                        this.postRemovedSlotInsertHook();
                        return null;
                    }
                    if (cur == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
            }
        }
        char prevValue = (char)(entry >>> 16);
        U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), value.charValue());
        return Character.valueOf(prevValue);
    }

    public char put(char key, char value) {
        int entry;
        int index;
        int[] tab;
        block26: {
            char removed = this.removedValue;
            char free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            entry = tab[index];
            char cur = (char)entry;
            if (cur == free) {
                this.incrementModCount();
                tab[index] = key | value << 16;
                this.postFreeSlotInsertHook();
                return this.defaultValue();
            }
            if (cur != key) {
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (char)(entry = tab[bIndex])) == free) {
                                this.incrementModCount();
                                tab[bIndex] = key | value << 16;
                                this.postFreeSlotInsertHook();
                                return this.defaultValue();
                            }
                            if (cur == key) {
                                index = bIndex;
                                break block26;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (char)(entry = tab[fIndex])) == free) {
                                this.incrementModCount();
                                tab[fIndex] = key | value << 16;
                                this.postFreeSlotInsertHook();
                                return this.defaultValue();
                            }
                            if (cur == key) {
                                index = fIndex;
                                break block26;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[bIndex] = key | value << 16;
                            this.postFreeSlotInsertHook();
                            return this.defaultValue();
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = key | value << 16;
                        this.postRemovedSlotInsertHook();
                        return this.defaultValue();
                    }
                    if (cur == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[fIndex] = key | value << 16;
                            this.postFreeSlotInsertHook();
                            return this.defaultValue();
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = key | value << 16;
                        this.postRemovedSlotInsertHook();
                        return this.defaultValue();
                    }
                    if (cur == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
            }
        }
        char prevValue = (char)(entry >>> 16);
        U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), value);
        return prevValue;
    }

    public Character putIfAbsent(Character key, Character value) {
        int firstRemoved;
        char k = key.charValue();
        char removed = this.removedValue;
        char free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        } else if (k == removed) {
            removed = this.changeRemoved();
        }
        int[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVCharKeyMixing.mix((char)k) % capacity;
        int entry = tab[index];
        char cur = (char)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = k | value.charValue() << 16;
            this.postFreeSlotInsertHook();
            return null;
        }
        if (cur == k) {
            return Character.valueOf((char)(entry >>> 16));
        }
        if (cur != removed) {
            if (this.noRemoved()) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == free) {
                        this.incrementModCount();
                        tab[bIndex] = k | value.charValue() << 16;
                        this.postFreeSlotInsertHook();
                        return null;
                    }
                    if (cur == k) {
                        return Character.valueOf((char)(entry >>> 16));
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == free) {
                        this.incrementModCount();
                        tab[fIndex] = k | value.charValue() << 16;
                        this.postFreeSlotInsertHook();
                        return null;
                    }
                    if (cur == k) {
                        return Character.valueOf((char)(entry >>> 16));
                    }
                    step += 2;
                }
            }
            firstRemoved = -1;
        } else {
            firstRemoved = index;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            int t;
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (char)(entry = tab[bIndex])) == free) {
                if (firstRemoved < 0) {
                    this.incrementModCount();
                    tab[bIndex] = k | value.charValue() << 16;
                    this.postFreeSlotInsertHook();
                    return null;
                }
                this.incrementModCount();
                tab[firstRemoved] = k | value.charValue() << 16;
                this.postRemovedSlotInsertHook();
                return null;
            }
            if (cur == k) {
                return Character.valueOf((char)(entry >>> 16));
            }
            if (cur == removed && firstRemoved < 0) {
                firstRemoved = bIndex;
            }
            if ((t = (fIndex += step) - capacity) >= 0) {
                fIndex = t;
            }
            if ((cur = (char)(entry = tab[fIndex])) == free) {
                if (firstRemoved < 0) {
                    this.incrementModCount();
                    tab[fIndex] = k | value.charValue() << 16;
                    this.postFreeSlotInsertHook();
                    return null;
                }
                this.incrementModCount();
                tab[firstRemoved] = k | value.charValue() << 16;
                this.postRemovedSlotInsertHook();
                return null;
            }
            if (cur == k) {
                return Character.valueOf((char)(entry >>> 16));
            }
            if (cur == removed && firstRemoved < 0) {
                firstRemoved = fIndex;
            }
            step += 2;
        }
    }

    public char putIfAbsent(char key, char value) {
        int firstRemoved;
        char removed = this.removedValue;
        char free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        } else if (key == removed) {
            removed = this.changeRemoved();
        }
        int[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
        int entry = tab[index];
        char cur = (char)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = key | value << 16;
            this.postFreeSlotInsertHook();
            return this.defaultValue();
        }
        if (cur == key) {
            return (char)(entry >>> 16);
        }
        if (cur != removed) {
            if (this.noRemoved()) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == free) {
                        this.incrementModCount();
                        tab[bIndex] = key | value << 16;
                        this.postFreeSlotInsertHook();
                        return this.defaultValue();
                    }
                    if (cur == key) {
                        return (char)(entry >>> 16);
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == free) {
                        this.incrementModCount();
                        tab[fIndex] = key | value << 16;
                        this.postFreeSlotInsertHook();
                        return this.defaultValue();
                    }
                    if (cur == key) {
                        return (char)(entry >>> 16);
                    }
                    step += 2;
                }
            }
            firstRemoved = -1;
        } else {
            firstRemoved = index;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            int t;
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (char)(entry = tab[bIndex])) == free) {
                if (firstRemoved < 0) {
                    this.incrementModCount();
                    tab[bIndex] = key | value << 16;
                    this.postFreeSlotInsertHook();
                    return this.defaultValue();
                }
                this.incrementModCount();
                tab[firstRemoved] = key | value << 16;
                this.postRemovedSlotInsertHook();
                return this.defaultValue();
            }
            if (cur == key) {
                return (char)(entry >>> 16);
            }
            if (cur == removed && firstRemoved < 0) {
                firstRemoved = bIndex;
            }
            if ((t = (fIndex += step) - capacity) >= 0) {
                fIndex = t;
            }
            if ((cur = (char)(entry = tab[fIndex])) == free) {
                if (firstRemoved < 0) {
                    this.incrementModCount();
                    tab[fIndex] = key | value << 16;
                    this.postFreeSlotInsertHook();
                    return this.defaultValue();
                }
                this.incrementModCount();
                tab[firstRemoved] = key | value << 16;
                this.postRemovedSlotInsertHook();
                return this.defaultValue();
            }
            if (cur == key) {
                return (char)(entry >>> 16);
            }
            if (cur == removed && firstRemoved < 0) {
                firstRemoved = fIndex;
            }
            step += 2;
        }
    }

    public void justPut(char key, char value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        U.putChar(this.table, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), value);
    }

    public Character compute(Character key, BiFunction<? super Character, ? super Character, ? extends Character> remappingFunction) {
        Character newValue;
        int entry;
        int index;
        int[] tab;
        char removed;
        char k;
        block28: {
            k = key.charValue();
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            char free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVCharKeyMixing.mix((char)k) % capacity;
            entry = tab[index];
            char cur = (char)entry;
            if (cur != k) {
                Character newValue2;
                block29: {
                    if (cur != free) {
                        Character newValue3;
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (char)(entry = tab[bIndex])) == k) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (char)(entry = tab[fIndex])) == k) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (char)(entry = tab[bIndex])) == k) {
                                index = bIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (char)(entry = tab[fIndex])) == k) {
                                index = fIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((newValue3 = remappingFunction.apply(Character.valueOf(k), null)) != null) {
                            this.incrementModCount();
                            tab[firstRemoved] = k | newValue3.charValue() << 16;
                            this.postRemovedSlotInsertHook();
                            return newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = remappingFunction.apply(Character.valueOf(k), null)) != null) {
                    this.incrementModCount();
                    tab[index] = k | newValue2.charValue() << 16;
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(Character.valueOf(k), Character.valueOf((char)(entry >>> 16)))) != null) {
            U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), newValue.charValue());
            return newValue;
        }
        this.incrementModCount();
        U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)index << 2), removed);
        this.postRemoveHook();
        return null;
    }

    public char compute(char key, CharCharToCharFunction remappingFunction) {
        char newValue;
        int entry;
        int index;
        int[] tab;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            char removed = this.removedValue;
            char free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                block26: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (char)(entry = tab[bIndex])) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (char)(entry = tab[fIndex])) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (char)(entry = tab[bIndex])) == key) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (char)(entry = tab[fIndex])) == key) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        char newValue2 = remappingFunction.applyAsChar(key, this.defaultValue());
                        this.incrementModCount();
                        tab[firstRemoved] = key | newValue2 << 16;
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = remappingFunction.applyAsChar(key, this.defaultValue());
                this.incrementModCount();
                tab[index] = key | newValue << 16;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        newValue = remappingFunction.applyAsChar(key, (char)(entry >>> 16));
        U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    public Character computeIfAbsent(Character key, Function<? super Character, ? extends Character> mappingFunction) {
        Character value;
        char k;
        block27: {
            k = key.charValue();
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            char removed = this.removedValue;
            char free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)k) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == k) {
                return Character.valueOf((char)(entry >>> 16));
            }
            if (cur != free) {
                Character value2;
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (char)(entry = tab[bIndex])) == k) {
                                return Character.valueOf((char)(entry >>> 16));
                            }
                            if (cur == free) {
                                index = bIndex;
                                break block27;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (char)(entry = tab[fIndex])) == k) {
                                return Character.valueOf((char)(entry >>> 16));
                            }
                            if (cur == free) {
                                index = fIndex;
                                break block27;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == k) {
                        return Character.valueOf((char)(entry >>> 16));
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block27;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == k) {
                        return Character.valueOf((char)(entry >>> 16));
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block27;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                if ((value2 = mappingFunction.apply(Character.valueOf(k))) != null) {
                    this.incrementModCount();
                    tab[firstRemoved] = k | value2.charValue() << 16;
                    this.postRemovedSlotInsertHook();
                    return value2;
                }
                return null;
            }
        }
        if ((value = mappingFunction.apply(Character.valueOf(k))) != null) {
            this.incrementModCount();
            tab[index] = k | value.charValue() << 16;
            this.postFreeSlotInsertHook();
            return value;
        }
        return null;
    }

    public char computeIfAbsent(char key, CharUnaryOperator mappingFunction) {
        block25: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            char removed = this.removedValue;
            char free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == key) {
                return (char)(entry >>> 16);
            }
            if (cur != free) {
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (char)(entry = tab[bIndex])) == key) {
                                return (char)(entry >>> 16);
                            }
                            if (cur == free) {
                                index = bIndex;
                                break block25;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (char)(entry = tab[fIndex])) == key) {
                                return (char)(entry >>> 16);
                            }
                            if (cur == free) {
                                index = fIndex;
                                break block25;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == key) {
                        return (char)(entry >>> 16);
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block25;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == key) {
                        return (char)(entry >>> 16);
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block25;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                char value = mappingFunction.applyAsChar(key);
                this.incrementModCount();
                tab[firstRemoved] = key | value << 16;
                this.postRemovedSlotInsertHook();
                return value;
            }
        }
        char value = mappingFunction.applyAsChar(key);
        this.incrementModCount();
        tab[index] = key | value << 16;
        this.postFreeSlotInsertHook();
        return value;
    }

    public Character computeIfPresent(Character key, BiFunction<? super Character, ? super Character, ? extends Character> remappingFunction) {
        char removed;
        char k = key.charValue();
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        char free = this.freeValue;
        if (k != free && k != (removed = this.removedValue)) {
            Character newValue;
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)k) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            if ((newValue = remappingFunction.apply(Character.valueOf(k), Character.valueOf((char)(entry >>> 16)))) != null) {
                U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), newValue.charValue());
                return newValue;
            }
            this.incrementModCount();
            U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)index << 2), removed);
            this.postRemoveHook();
            return null;
        }
        return null;
    }

    public char computeIfPresent(char key, CharCharToCharFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        char free = this.freeValue;
        if (key != free && key != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            char newValue = remappingFunction.applyAsChar(key, (char)(entry >>> 16));
            U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    public Character merge(Character key, Character value, BiFunction<? super Character, ? super Character, ? extends Character> remappingFunction) {
        Character newValue;
        int entry;
        int index;
        int[] tab;
        char removed;
        block27: {
            char k = key.charValue();
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            char free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVCharKeyMixing.mix((char)k) % capacity;
            entry = tab[index];
            char cur = (char)entry;
            if (cur != k) {
                block28: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (char)(entry = tab[bIndex])) == k) {
                                        index = bIndex;
                                        break block27;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (char)(entry = tab[fIndex])) == k) {
                                        index = fIndex;
                                        break block27;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (char)(entry = tab[bIndex])) == k) {
                                index = bIndex;
                                break block27;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block28;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (char)(entry = tab[fIndex])) == k) {
                                index = fIndex;
                                break block27;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block28;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = k | value.charValue() << 16;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                tab[index] = k | value.charValue() << 16;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply(Character.valueOf((char)(entry >>> 16)), value)) != null) {
            U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), newValue.charValue());
            return newValue;
        }
        this.incrementModCount();
        U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)index << 2), removed);
        this.postRemoveHook();
        return null;
    }

    public char merge(char key, char value, CharBinaryOperator remappingFunction) {
        int entry;
        int index;
        int[] tab;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            char removed = this.removedValue;
            char free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                block26: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (char)(entry = tab[bIndex])) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (char)(entry = tab[fIndex])) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (char)(entry = tab[bIndex])) == key) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (char)(entry = tab[fIndex])) == key) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = key | value << 16;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                tab[index] = key | value << 16;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        char newValue = remappingFunction.applyAsChar((char)(entry >>> 16), value);
        U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    public char addValue(char key, char value) {
        char newValue;
        int entry;
        int index;
        int[] tab;
        block24: {
            char removed = this.removedValue;
            char free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                block25: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (char)(entry = tab[bIndex])) == key) {
                                        index = bIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (char)(entry = tab[fIndex])) == key) {
                                        index = fIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (char)(entry = tab[bIndex])) == key) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (char)(entry = tab[fIndex])) == key) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        char newValue2 = (char)(this.defaultValue() + value);
                        this.incrementModCount();
                        tab[firstRemoved] = key | newValue2 << 16;
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = (char)(this.defaultValue() + value);
                this.incrementModCount();
                tab[index] = key | newValue << 16;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        newValue = (char)((char)(entry >>> 16) + value);
        U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    public char addValue(char key, char addition, char initialValue) {
        char newValue;
        int entry;
        int index;
        int[] tab;
        block24: {
            char removed = this.removedValue;
            char free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                block25: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (char)(entry = tab[bIndex])) == key) {
                                        index = bIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (char)(entry = tab[fIndex])) == key) {
                                        index = fIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (char)(entry = tab[bIndex])) == key) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (char)(entry = tab[fIndex])) == key) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        char newValue2 = (char)(initialValue + addition);
                        this.incrementModCount();
                        tab[firstRemoved] = key | newValue2 << 16;
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = (char)(initialValue + addition);
                this.incrementModCount();
                tab[index] = key | newValue << 16;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        newValue = (char)((char)(entry >>> 16) + addition);
        U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    public void putAll(@Nonnull Map<? extends Character, ? extends Character> m) {
        CommonCharCharMapOps.putAll((InternalCharCharMapOps)this, m);
    }

    public Character replace(Character key, Character value) {
        char free;
        char k = key.charValue();
        if (k != (free = this.freeValue) && k != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)k) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            char oldValue = (char)(entry >>> 16);
            U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), value.charValue());
            return Character.valueOf(oldValue);
        }
        return null;
    }

    public char replace(char key, char value) {
        char free = this.freeValue;
        if (key != free && key != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            char oldValue = (char)(entry >>> 16);
            U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), value);
            return oldValue;
        }
        return this.defaultValue();
    }

    public boolean replace(Character key, Character oldValue, Character newValue) {
        return this.replace(key.charValue(), oldValue.charValue(), newValue.charValue());
    }

    public boolean replace(char key, char oldValue, char newValue) {
        char free = this.freeValue;
        if (key != free && key != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            if ((char)(entry >>> 16) == oldValue) {
                U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super Character, ? super Character, ? extends Character> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)i << 2), function.apply(Character.valueOf(key), Character.valueOf((char)(entry >>> 16))).charValue());
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)i << 2), function.apply(Character.valueOf(key), Character.valueOf((char)(entry >>> 16))).charValue());
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(CharCharToCharFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)i << 2), function.applyAsChar(key, (char)(entry >>> 16)));
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)i << 2), function.applyAsChar(key, (char)(entry >>> 16)));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        this.incrementModCount();
        super.removeAt(index);
        this.postRemoveHook();
    }

    public Character remove(Object key) {
        char removed;
        char free;
        char k = ((Character)key).charValue();
        if (k != (free = this.freeValue) && k != (removed = this.removedValue)) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)k) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            char val = (char)(entry >>> 16);
            this.incrementModCount();
            U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)index << 2), removed);
            this.postRemoveHook();
            return Character.valueOf(val);
        }
        return null;
    }

    @Override
    public boolean justRemove(char key) {
        char removed;
        char free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            this.incrementModCount();
            U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)index << 2), removed);
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public char remove(char key) {
        char removed;
        char free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            char val = (char)(entry >>> 16);
            this.incrementModCount();
            U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)index << 2), removed);
            this.postRemoveHook();
            return val;
        }
        return this.defaultValue();
    }

    public boolean remove(Object key, Object value) {
        return this.remove(((Character)key).charValue(), ((Character)value).charValue());
    }

    public boolean remove(char key, char value) {
        char removed;
        char free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            if ((char)(entry >>> 16) == value) {
                this.incrementModCount();
                U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)index << 2), removed);
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeIf(CharCharPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || !filter.test(key, (char)(entry >>> 16))) continue;
                this.incrementModCount();
                ++mc;
                U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)i << 2), removed);
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed || !filter.test(key, (char)(entry >>> 16))) continue;
                this.incrementModCount();
                ++mc;
                U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)i << 2), removed);
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedMapCursor
    implements CharCharCursor {
        final int[] tab;
        final char free;
        final char removed;
        int expectedModCount;
        int index;
        char curKey;
        char curValue;

        SomeRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVCharCharMapGO.this.table;
            this.index = this.tab.length;
            char free = this.free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(CharCharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            char removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                action.accept(key, (char)(entry >>> 16));
            }
            if (index != this.index || mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char key() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public char value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(char value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_VALUE_OFFSET + ((long)this.index << 2), value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                int[] tab = this.tab;
                char free = this.free;
                char removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (char)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            char free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)this.index << 2), this.removed);
            MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedMapCursor
    implements CharCharCursor {
        final int[] tab;
        final char free;
        final char removed;
        int expectedModCount;
        int index;
        char curKey;
        char curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVCharCharMapGO.this.table;
            this.index = this.tab.length;
            char free = this.free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(CharCharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(key, (char)(entry >>> 16));
            }
            if (index != this.index || mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char key() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public char value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(char value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_VALUE_OFFSET + ((long)this.index << 2), value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                int[] tab = this.tab;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (char)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            char free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)this.index << 2), this.removed);
            MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueCursor
    implements CharCursor {
        final int[] tab;
        final char free;
        final char removed;
        int expectedModCount;
        int index;
        char curKey;
        char curValue;

        SomeRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVCharCharMapGO.this.table;
            this.index = this.tab.length;
            char free = this.free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            char removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                action.accept((char)(entry >>> 16));
            }
            if (index != this.index || mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                int[] tab = this.tab;
                char free = this.free;
                char removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (char)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            char free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)this.index << 2), this.removed);
            MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueIterator
    implements CharIterator {
        final int[] tab;
        final char free;
        final char removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        char next;

        SomeRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVCharCharMapGO.this.table;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            char free = this.free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = this.removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                this.next = (char)(entry >>> 16);
                break;
            }
            this.nextIndex = nextI;
        }

        public char nextChar() {
            if (this.expectedModCount == MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    int[] tab = this.tab;
                    char free = this.free;
                    char removed = this.removed;
                    char prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        char key = (char)entry;
                        if (key == free || key == removed) continue;
                        this.next = (char)(entry >>> 16);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Character> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            char removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                action.accept(Character.valueOf((char)(entry >>> 16)));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(CharConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            char removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                action.accept((char)(entry >>> 16));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Character next() {
            return Character.valueOf(this.nextChar());
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)index << 2), this.removed);
            MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueCursor
    implements CharCursor {
        final int[] tab;
        final char free;
        final char removed;
        int expectedModCount;
        int index;
        char curKey;
        char curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVCharCharMapGO.this.table;
            this.index = this.tab.length;
            char free = this.free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept((char)(entry >>> 16));
            }
            if (index != this.index || mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                int[] tab = this.tab;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (char)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            char free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)this.index << 2), this.removed);
            MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueIterator
    implements CharIterator {
        final int[] tab;
        final char free;
        final char removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        char next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVCharCharMapGO.this.table;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            char free = this.free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                if ((char)entry == free) continue;
                this.next = (char)(entry >>> 16);
                break;
            }
            this.nextIndex = nextI;
        }

        public char nextChar() {
            if (this.expectedModCount == MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    int[] tab = this.tab;
                    char free = this.free;
                    char prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        if ((char)entry == free) continue;
                        this.next = (char)(entry >>> 16);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Character> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept(Character.valueOf((char)(entry >>> 16)));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(CharConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept((char)(entry >>> 16));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Character next() {
            return Character.valueOf(this.nextChar());
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)index << 2), this.removed);
            MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryCursor
    implements ObjCursor<Map.Entry<Character, Character>> {
        final int[] tab;
        final char free;
        final char removed;
        int expectedModCount;
        int index;
        char curKey;
        char curValue;

        SomeRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVCharCharMapGO.this.table;
            this.index = this.tab.length;
            char free = this.free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Character, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            char removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                action.accept((Map.Entry<Character, Character>)((Object)new MutableEntry(mc, i, key, (char)(entry >>> 16))));
            }
            if (index != this.index || mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Character, Character> elem() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                int[] tab = this.tab;
                char free = this.free;
                char removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (char)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            char free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)this.index << 2), this.removed);
            MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryIterator
    implements ObjIterator<Map.Entry<Character, Character>> {
        final int[] tab;
        final char free;
        final char removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        SomeRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVCharCharMapGO.this.table;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            char free = this.free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = this.removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                this.next = new MutableEntry(mc, nextI, key, (char)(entry >>> 16));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Character, Character>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            char removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                action.accept((Map.Entry<Character, Character>)((Object)new MutableEntry(mc, i, key, (char)(entry >>> 16))));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Character, Character> next() {
            int mc = this.expectedModCount;
            if (mc == MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    int[] tab = this.tab;
                    char free = this.free;
                    char removed = this.removed;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        char key = (char)entry;
                        if (key == free || key == removed) continue;
                        this.next = new MutableEntry(mc, nextI, key, (char)(entry >>> 16));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)index << 2), this.removed);
            MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Character, Character>> {
        final int[] tab;
        final char free;
        final char removed;
        int expectedModCount;
        int index;
        char curKey;
        char curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVCharCharMapGO.this.table;
            this.index = this.tab.length;
            char free = this.free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Character, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Character, Character>)((Object)new MutableEntry(mc, i, key, (char)(entry >>> 16))));
            }
            if (index != this.index || mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Character, Character> elem() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                int[] tab = this.tab;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (char)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            char free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)this.index << 2), this.removed);
            MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Character, Character>> {
        final int[] tab;
        final char free;
        final char removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVCharCharMapGO.this.table;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            char free = this.free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                char key = (char)entry;
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, (char)(entry >>> 16));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Character, Character>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Character, Character>)((Object)new MutableEntry(mc, i, key, (char)(entry >>> 16))));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Character, Character> next() {
            int mc = this.expectedModCount;
            if (mc == MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    int[] tab = this.tab;
                    char free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        char key = (char)entry;
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, (char)(entry >>> 16));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)index << 2), this.removed);
            MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
        }
    }

    class ValueView
    extends AbstractCharValueView {
        ValueView() {
        }

        public int size() {
            return MutableQHashParallelKVCharCharMapGO.this.size();
        }

        public boolean shrink() {
            return MutableQHashParallelKVCharCharMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return MutableQHashParallelKVCharCharMapGO.this.containsValue(o);
        }

        public boolean contains(char v) {
            return MutableQHashParallelKVCharCharMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Character> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free) continue;
                    action.accept(Character.valueOf((char)(entry >>> 16)));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    action.accept(Character.valueOf((char)(entry >>> 16)));
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free) continue;
                    action.accept((char)(entry >>> 16));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    action.accept((char)(entry >>> 16));
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(CharPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free || predicate.test((char)(entry >>> 16))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed || predicate.test((char)(entry >>> 16))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(CharCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free || c.contains((char)(entry >>> 16))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed || c.contains((char)(entry >>> 16))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(CharCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free) continue;
                    changed |= c.add((char)(entry >>> 16));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    changed |= c.add((char)(entry >>> 16));
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(CharSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free) continue;
                    changed |= s.removeChar((char)(entry >>> 16));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    changed |= s.removeChar((char)(entry >>> 16));
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public CharIterator iterator() {
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            if (!MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                return new SomeRemovedValueIterator(mc);
            }
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public CharCursor cursor() {
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            if (!MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                return new SomeRemovedValueCursor(mc);
            }
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free) continue;
                    result[resultIndex++] = Character.valueOf((char)(entry >>> 16));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = Character.valueOf((char)(entry >>> 16));
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free) continue;
                    a[resultIndex++] = Character.valueOf((char)(entry >>> 16));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = Character.valueOf((char)(entry >>> 16));
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public char[] toCharArray() {
            int size = this.size();
            char[] result = new char[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free) continue;
                    result[resultIndex++] = (char)(entry >>> 16);
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = (char)(entry >>> 16);
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public char[] toArray(char[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new char[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = '\u0000';
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free) continue;
                    a[resultIndex++] = (char)(entry >>> 16);
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = (char)(entry >>> 16);
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = '\u0000';
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free) continue;
                    sb.append(' ').append((char)(entry >>> 16)).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    sb.append(' ').append((char)(entry >>> 16)).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeChar(((Character)o).charValue());
        }

        public boolean removeChar(char v) {
            return MutableQHashParallelKVCharCharMapGO.this.removeValue(v);
        }

        public void clear() {
            MutableQHashParallelKVCharCharMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Character> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free || !filter.test(Character.valueOf((char)(entry >>> 16)))) continue;
                    MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed || !filter.test(Character.valueOf((char)(entry >>> 16)))) continue;
                    MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(CharPredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free || !filter.test((char)(entry >>> 16))) continue;
                    MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed || !filter.test((char)(entry >>> 16))) continue;
                    MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof CharCollection) {
                return this.removeAll((CharCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free || !c.contains(Character.valueOf((char)(entry >>> 16)))) continue;
                    MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed || !c.contains(Character.valueOf((char)(entry >>> 16)))) continue;
                    MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(CharCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free || !c.contains((char)(entry >>> 16))) continue;
                    MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed || !c.contains((char)(entry >>> 16))) continue;
                    MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof CharCollection) {
                return this.retainAll((CharCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free || c.contains(Character.valueOf((char)(entry >>> 16)))) continue;
                    MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed || c.contains(Character.valueOf((char)(entry >>> 16)))) continue;
                    MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(CharCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free || c.contains((char)(entry >>> 16))) continue;
                    MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed || c.contains((char)(entry >>> 16))) continue;
                    MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends CharCharEntry {
        private char key;
        private char value;

        ReusableEntry() {
        }

        ReusableEntry with(char key, char value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }
    }

    class MutableEntry
    extends CharCharEntry {
        final int modCount;
        private final int index;
        final char key;
        private char value;

        MutableEntry(int modCount, int index, char key, char value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }

        public Character setValue(Character newValue) {
            char unwrappedNewValue;
            if (this.modCount != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            char oldValue = this.value;
            this.value = unwrappedNewValue = newValue.charValue();
            this.updateValueInTable(unwrappedNewValue);
            return Character.valueOf(oldValue);
        }

        void updateValueInTable(char newValue) {
            UnsafeConstants.U.putChar(MutableQHashParallelKVCharCharMapGO.this.table, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_VALUE_OFFSET + ((long)this.index << 2), newValue);
        }
    }

    abstract class CharCharEntry
    extends AbstractEntry<Character, Character> {
        CharCharEntry() {
        }

        abstract char key();

        public final Character getKey() {
            return Character.valueOf(this.key());
        }

        abstract char value();

        public final Character getValue() {
            return Character.valueOf(this.value());
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                char k2 = ((Character)e2.getKey()).charValue();
                char v2 = ((Character)e2.getValue()).charValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((char)this.key()) ^ Primitives.hashCode((char)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Character, Character>>
    implements HashObjSet<Map.Entry<Character, Character>>,
    InternalObjCollectionOps<Map.Entry<Character, Character>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Character, Character>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableQHashParallelKVCharCharMapGO.this.hashConfig();
        }

        public int size() {
            return MutableQHashParallelKVCharCharMapGO.this.size;
        }

        public double currentLoad() {
            return MutableQHashParallelKVCharCharMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableQHashParallelKVCharCharMapGO.this.containsEntry(((Character)e.getKey()).charValue(), ((Character)e.getValue()).charValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, (char)(entry >>> 16));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, (char)(entry >>> 16));
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, (char)(entry >>> 16));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, (char)(entry >>> 16));
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Character, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    action.accept((Map.Entry<Character, Character>)((Object)new MutableEntry(mc, i, key, (char)(entry >>> 16))));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    action.accept((Map.Entry<Character, Character>)((Object)new MutableEntry(mc, i, key, (char)(entry >>> 16))));
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Character, Character>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || predicate.test((Map.Entry<Character, Character>)((Object)new MutableEntry(mc, i, key, (char)(entry >>> 16))))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed || predicate.test((Map.Entry<Character, Character>)((Object)new MutableEntry(mc, i, key, (char)(entry >>> 16))))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Character, Character>> iterator() {
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            if (!MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                return new SomeRemovedEntryIterator(mc);
            }
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Character, Character>> cursor() {
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            if (!MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                return new SomeRemovedEntryCursor(mc);
            }
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || c.contains((Object)e.with(key, (char)(entry >>> 16)))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed || c.contains((Object)e.with(key, (char)(entry >>> 16)))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    changed |= s.remove((Object)e.with(key, (char)(entry >>> 16)));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    changed |= s.remove((Object)e.with(key, (char)(entry >>> 16)));
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Character, Character>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, (char)(entry >>> 16)));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, (char)(entry >>> 16)));
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return MutableQHashParallelKVCharCharMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    sb.append((char)(entry >>> 16));
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    sb.append((char)(entry >>> 16));
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableQHashParallelKVCharCharMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                char key = ((Character)e.getKey()).charValue();
                char value = ((Character)e.getValue()).charValue();
                return MutableQHashParallelKVCharCharMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Character, Character>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || !filter.test((Map.Entry<Character, Character>)((Object)new MutableEntry(mc, i, key, (char)(entry >>> 16))))) continue;
                    MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed || !filter.test((Map.Entry<Character, Character>)((Object)new MutableEntry(mc, i, key, (char)(entry >>> 16))))) continue;
                    MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || !c.contains((Object)e.with(key, (char)(entry >>> 16)))) continue;
                    MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed || !c.contains((Object)e.with(key, (char)(entry >>> 16)))) continue;
                    MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableQHashParallelKVCharCharMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharCharMapGO.this.table;
            if (MutableQHashParallelKVCharCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || c.contains((Object)e.with(key, (char)(entry >>> 16)))) continue;
                    MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed || c.contains((Object)e.with(key, (char)(entry >>> 16)))) continue;
                    MutableQHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public void clear() {
            MutableQHashParallelKVCharCharMapGO.this.doClear();
        }
    }
}

