/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.hash.IntHashFactory;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.AbstractHashFactory;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

abstract class IntHashFactorySO
extends AbstractHashFactory {
    final int lower;
    final int upper;
    final boolean randomFree;
    final boolean randomRemoved;
    final int freeValue;
    final int removedValue;

    IntHashFactorySO(HashConfig hashConf, int defaultExpectedSize, int lower, int upper) {
        super(hashConf, defaultExpectedSize);
        this.lower = lower;
        this.upper = upper;
        if (lower - 1 == upper) {
            this.randomFree = false;
            this.randomRemoved = true;
            this.removedValue = 0;
            this.freeValue = 0;
        } else {
            this.randomFree = false;
            this.freeValue = lower < upper && (lower > 0 || upper < 0) || upper < lower && lower > 0 && upper < 0 ? 0 : lower - 1;
            if (lower - 2 == upper) {
                this.randomRemoved = true;
                this.removedValue = 0;
            } else {
                this.randomRemoved = false;
                this.removedValue = upper + 1 != 0 ? upper + 1 : upper + 2;
            }
        }
    }

    public final int getLowerKeyDomainBound() {
        return this.lower;
    }

    public final int getUpperKeyDomainBound() {
        return this.upper;
    }

    int getFree() {
        if (this.randomFree) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            return ((Random)random).nextInt();
        }
        return this.freeValue;
    }

    String keySpecialString() {
        return ",lowerKeyDomainBound=" + IntHashFactorySO.boundAsString(this.getLowerKeyDomainBound()) + ",upperKeyDomainBound=" + IntHashFactorySO.boundAsString(this.getUpperKeyDomainBound());
    }

    private static String boundAsString(int bound) {
        return "" + bound;
    }

    int keySpecialHashCode(int hashCode) {
        hashCode = hashCode * 31 + Primitives.hashCode((int)this.getLowerKeyDomainBound());
        return hashCode * 31 + Primitives.hashCode((int)this.getUpperKeyDomainBound());
    }

    boolean keySpecialEquals(IntHashFactory other) {
        return this.getLowerKeyDomainBound() == other.getLowerKeyDomainBound() && this.getUpperKeyDomainBound() == other.getUpperKeyDomainBound();
    }
}

