/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.Equivalence;
import com.koloboke.collect.IntCollection;
import com.koloboke.collect.IntCursor;
import com.koloboke.collect.IntIterator;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractIntValueView;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonDoubleIntMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalDoubleIntMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.ImmutableQHashSeparateKVDoubleIntMapSO;
import com.koloboke.collect.impl.hash.SeparateKVDoubleIntQHash;
import com.koloboke.collect.map.DoubleIntCursor;
import com.koloboke.collect.set.IntSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.DoubleIntConsumer;
import com.koloboke.function.DoubleIntPredicate;
import com.koloboke.function.DoubleIntToIntFunction;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleToIntFunction;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class ImmutableQHashSeparateKVDoubleIntMapGO
extends ImmutableQHashSeparateKVDoubleIntMapSO {
    @Override
    final void copy(SeparateKVDoubleIntQHash hash) {
        int hashMC = hash.modCount();
        super.copy(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVDoubleIntQHash hash) {
        int hashMC = hash.modCount();
        super.move(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public int defaultValue() {
        return 0;
    }

    public boolean containsEntry(double key, int value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public boolean containsEntry(long key, int value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public Integer get(Object key) {
        long k = Double.doubleToLongBits((Double)key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public int get(double key) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    public Integer getOrDefault(Object key, Integer defaultValue) {
        long k = Double.doubleToLongBits((Double)key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public int getOrDefault(double key, int defaultValue) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Double, ? super Integer> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept((Double)Double.longBitsToDouble(key), (Integer)vals[i]);
        }
    }

    public void forEach(DoubleIntConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept(Double.longBitsToDouble(key), vals[i]);
        }
    }

    public boolean forEachWhile(DoubleIntPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || predicate.test(Double.longBitsToDouble(key), vals[i])) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public DoubleIntCursor cursor() {
        return new NoRemovedMapCursor();
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonDoubleIntMapOps.containsAllEntries((InternalDoubleIntMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalDoubleIntMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalDoubleIntMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            m.justPut(key, vals[i]);
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Double, Integer>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public IntCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            hashCode += (int)(key ^ key >>> 32) ^ vals[i];
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            sb.append(' ');
            sb.append(Double.longBitsToDouble(key));
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    public Integer put(Double key, Integer value) {
        throw new UnsupportedOperationException();
    }

    public int put(double key, int value) {
        throw new UnsupportedOperationException();
    }

    public Integer putIfAbsent(Double key, Integer value) {
        throw new UnsupportedOperationException();
    }

    public int putIfAbsent(double key, int value) {
        throw new UnsupportedOperationException();
    }

    public void justPut(double key, int value) {
        throw new UnsupportedOperationException();
    }

    public void justPut(long key, int value) {
        throw new UnsupportedOperationException();
    }

    public Integer compute(Double key, BiFunction<? super Double, ? super Integer, ? extends Integer> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int compute(double key, DoubleIntToIntFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Integer computeIfAbsent(Double key, Function<? super Double, ? extends Integer> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int computeIfAbsent(double key, DoubleToIntFunction mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Integer computeIfPresent(Double key, BiFunction<? super Double, ? super Integer, ? extends Integer> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int computeIfPresent(double key, DoubleIntToIntFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Integer merge(Double key, Integer value, BiFunction<? super Integer, ? super Integer, ? extends Integer> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int merge(double key, int value, IntBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int addValue(double key, int value) {
        throw new UnsupportedOperationException();
    }

    public int addValue(double key, int addition, int initialValue) {
        throw new UnsupportedOperationException();
    }

    public void putAll(@Nonnull Map<? extends Double, ? extends Integer> m) {
        CommonDoubleIntMapOps.putAll((InternalDoubleIntMapOps)this, m);
    }

    public Integer replace(Double key, Integer value) {
        throw new UnsupportedOperationException();
    }

    public int replace(double key, int value) {
        throw new UnsupportedOperationException();
    }

    public boolean replace(Double key, Integer oldValue, Integer newValue) {
        return this.replace((double)key, (int)oldValue, (int)newValue);
    }

    public boolean replace(double key, int oldValue, int newValue) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(BiFunction<? super Double, ? super Integer, ? extends Integer> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(DoubleIntToIntFunction function) {
        throw new UnsupportedOperationException();
    }

    public Integer remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(double key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(long key) {
        throw new UnsupportedOperationException();
    }

    public int remove(double key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Double)key, (Integer)value);
    }

    public boolean remove(double key, int value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(DoubleIntPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements DoubleIntCursor {
        final long[] keys;
        final int[] vals;
        int index;
        long curKey;
        int curValue;

        NoRemovedMapCursor() {
            this.keys = ImmutableQHashSeparateKVDoubleIntMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVDoubleIntMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(DoubleIntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            int[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Double.longBitsToDouble(key), vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public double key() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return Double.longBitsToDouble(curKey);
            }
            throw new IllegalStateException();
        }

        public int value() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(int value) {
            if (this.curKey == 0x7FFFFFFFFFFFFFFEL) {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            long[] keys = this.keys;
            for (int i = this.index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements IntCursor {
        final long[] keys;
        final int[] vals;
        int index;
        long curKey;
        int curValue;

        NoRemovedValueCursor() {
            this.keys = ImmutableQHashSeparateKVDoubleIntMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVDoubleIntMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            int[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public int elem() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            long[] keys = this.keys;
            for (int i = this.index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements IntIterator {
        final long[] keys;
        final int[] vals;
        int nextIndex;
        int next;

        NoRemovedValueIterator() {
            this.keys = ImmutableQHashSeparateKVDoubleIntMapGO.this.set;
            long[] keys = ImmutableQHashSeparateKVDoubleIntMapGO.this.set;
            this.vals = ImmutableQHashSeparateKVDoubleIntMapGO.this.values;
            int[] vals = ImmutableQHashSeparateKVDoubleIntMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public int nextInt() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                long[] keys = this.keys;
                int prev = this.next;
                while (--nextI >= 0) {
                    if (keys[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.next = this.vals[nextI];
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Integer> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            int[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Integer)vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(IntConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            int[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Integer next() {
            return this.nextInt();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Double, Integer>> {
        final long[] keys;
        final int[] vals;
        int index;
        long curKey;
        int curValue;

        NoRemovedEntryCursor() {
            this.keys = ImmutableQHashSeparateKVDoubleIntMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVDoubleIntMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(Consumer<? super Map.Entry<Double, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            int[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Map.Entry<Double, Integer>)((Object)new ImmutableEntry(key, vals[i])));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public Map.Entry<Double, Integer> elem() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            long[] keys = this.keys;
            for (int i = this.index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Double, Integer>> {
        final long[] keys;
        final int[] vals;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.keys = ImmutableQHashSeparateKVDoubleIntMapGO.this.set;
            long[] keys = ImmutableQHashSeparateKVDoubleIntMapGO.this.set;
            this.vals = ImmutableQHashSeparateKVDoubleIntMapGO.this.values;
            int[] vals = ImmutableQHashSeparateKVDoubleIntMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                long key = keys[nextI];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = new ImmutableEntry(key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Double, Integer>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            int[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Map.Entry<Double, Integer>)((Object)new ImmutableEntry(key, vals[i])));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Double, Integer> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                long[] keys = this.keys;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    long key = keys[nextI];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.next = new ImmutableEntry(key, this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractIntValueView {
        ValueView() {
        }

        public int size() {
            return ImmutableQHashSeparateKVDoubleIntMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableQHashSeparateKVDoubleIntMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return ImmutableQHashSeparateKVDoubleIntMapGO.this.containsValue(o);
        }

        public boolean contains(int v) {
            return ImmutableQHashSeparateKVDoubleIntMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Integer> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long[] keys = ImmutableQHashSeparateKVDoubleIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVDoubleIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Integer)vals[i]);
            }
        }

        public void forEach(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long[] keys = ImmutableQHashSeparateKVDoubleIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVDoubleIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(vals[i]);
            }
        }

        public boolean forEachWhile(IntPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            long[] keys = ImmutableQHashSeparateKVDoubleIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVDoubleIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        public boolean allContainingIn(IntCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            long[] keys = ImmutableQHashSeparateKVDoubleIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVDoubleIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(IntCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long[] keys = ImmutableQHashSeparateKVDoubleIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVDoubleIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add(vals[i]);
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(IntSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long[] keys = ImmutableQHashSeparateKVDoubleIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVDoubleIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.removeInt(vals[i]);
            }
            return changed;
        }

        @Nonnull
        public IntIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public IntCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long[] keys = ImmutableQHashSeparateKVDoubleIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVDoubleIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            long[] keys = ImmutableQHashSeparateKVDoubleIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVDoubleIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public int[] toIntArray() {
            int size = this.size();
            int[] result = new int[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long[] keys = ImmutableQHashSeparateKVDoubleIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVDoubleIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        public int[] toArray(int[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new int[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            long[] keys = ImmutableQHashSeparateKVDoubleIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVDoubleIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            long[] keys = ImmutableQHashSeparateKVDoubleIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVDoubleIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeInt((Integer)o);
        }

        public boolean removeInt(int v) {
            return ImmutableQHashSeparateKVDoubleIntMapGO.this.removeValue(v);
        }

        public void clear() {
            ImmutableQHashSeparateKVDoubleIntMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Integer> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(IntPredicate filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends DoubleIntEntry {
        private long key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(long key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends DoubleIntEntry {
        private final long key;
        private final int value;

        ImmutableEntry(long key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    abstract class DoubleIntEntry
    extends AbstractEntry<Double, Integer> {
        DoubleIntEntry() {
        }

        abstract long key();

        public final Double getKey() {
            return Double.longBitsToDouble(this.key());
        }

        abstract int value();

        public final Integer getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                long k2 = Double.doubleToLongBits((Double)e2.getKey());
                int v2 = (Integer)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((long)this.key()) ^ Primitives.hashCode((int)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Double, Integer>>
    implements HashObjSet<Map.Entry<Double, Integer>>,
    InternalObjCollectionOps<Map.Entry<Double, Integer>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Double, Integer>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableQHashSeparateKVDoubleIntMapGO.this.hashConfig();
        }

        public int size() {
            return ImmutableQHashSeparateKVDoubleIntMapGO.this.size;
        }

        public double currentLoad() {
            return ImmutableQHashSeparateKVDoubleIntMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableQHashSeparateKVDoubleIntMapGO.this.containsEntry((Double)e.getKey(), (int)((Integer)e.getValue()));
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long[] keys = ImmutableQHashSeparateKVDoubleIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVDoubleIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            long[] keys = ImmutableQHashSeparateKVDoubleIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVDoubleIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Double, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long[] keys = ImmutableQHashSeparateKVDoubleIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVDoubleIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Map.Entry<Double, Integer>)((Object)new ImmutableEntry(key, vals[i])));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Double, Integer>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            long[] keys = ImmutableQHashSeparateKVDoubleIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVDoubleIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || predicate.test((Map.Entry<Double, Integer>)((Object)new ImmutableEntry(key, vals[i])))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Double, Integer>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Double, Integer>> cursor() {
            return new NoRemovedEntryCursor();
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            long[] keys = ImmutableQHashSeparateKVDoubleIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVDoubleIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            long[] keys = ImmutableQHashSeparateKVDoubleIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVDoubleIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Double, Integer>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long[] keys = ImmutableQHashSeparateKVDoubleIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVDoubleIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add((Object)new ImmutableEntry(key, vals[i]));
            }
            return changed;
        }

        public int hashCode() {
            return ImmutableQHashSeparateKVDoubleIntMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            long[] keys = ImmutableQHashSeparateKVDoubleIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVDoubleIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                sb.append(' ');
                sb.append(Double.longBitsToDouble(key));
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableQHashSeparateKVDoubleIntMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                double key = (Double)e.getKey();
                int value = (Integer)e.getValue();
                return ImmutableQHashSeparateKVDoubleIntMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Double, Integer>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

