/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.Equivalence;
import com.koloboke.collect.IntCollection;
import com.koloboke.collect.IntCursor;
import com.koloboke.collect.IntIterator;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractIntValueView;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonLongIntMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalLongIntMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.ImmutableLHashSeparateKVLongIntMapSO;
import com.koloboke.collect.impl.hash.SeparateKVLongIntLHash;
import com.koloboke.collect.map.LongIntCursor;
import com.koloboke.collect.set.IntSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.LongIntConsumer;
import com.koloboke.function.LongIntPredicate;
import com.koloboke.function.LongIntToIntFunction;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.LongToIntFunction;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class ImmutableLHashSeparateKVLongIntMapGO
extends ImmutableLHashSeparateKVLongIntMapSO {
    @Override
    final void copy(SeparateKVLongIntLHash hash) {
        int hashMC = hash.modCount();
        super.copy(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVLongIntLHash hash) {
        int hashMC = hash.modCount();
        super.move(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public int defaultValue() {
        return 0;
    }

    public boolean containsEntry(long key, int value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public Integer get(Object key) {
        int index = this.index((Long)key);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public int get(long key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    public Integer getOrDefault(Object key, Integer defaultValue) {
        int index = this.index((Long)key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public int getOrDefault(long key, int defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Long, ? super Integer> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        long free = this.freeValue;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            action.accept((Long)key, (Integer)vals[i]);
        }
    }

    public void forEach(LongIntConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        long free = this.freeValue;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            action.accept(key, vals[i]);
        }
    }

    public boolean forEachWhile(LongIntPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        long free = this.freeValue;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free || predicate.test(key, vals[i])) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public LongIntCursor cursor() {
        return new NoRemovedMapCursor();
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonLongIntMapOps.containsAllEntries((InternalLongIntMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalLongIntMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        long free = this.freeValue;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalLongIntMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        long free = this.freeValue;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Long, Integer>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public IntCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        long free = this.freeValue;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            hashCode += (int)(key ^ key >>> 32) ^ vals[i];
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        long free = this.freeValue;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    public Integer put(Long key, Integer value) {
        throw new UnsupportedOperationException();
    }

    public int put(long key, int value) {
        throw new UnsupportedOperationException();
    }

    public Integer putIfAbsent(Long key, Integer value) {
        throw new UnsupportedOperationException();
    }

    public int putIfAbsent(long key, int value) {
        throw new UnsupportedOperationException();
    }

    public void justPut(long key, int value) {
        throw new UnsupportedOperationException();
    }

    public Integer compute(Long key, BiFunction<? super Long, ? super Integer, ? extends Integer> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int compute(long key, LongIntToIntFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Integer computeIfAbsent(Long key, Function<? super Long, ? extends Integer> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int computeIfAbsent(long key, LongToIntFunction mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Integer computeIfPresent(Long key, BiFunction<? super Long, ? super Integer, ? extends Integer> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int computeIfPresent(long key, LongIntToIntFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Integer merge(Long key, Integer value, BiFunction<? super Integer, ? super Integer, ? extends Integer> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int merge(long key, int value, IntBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int addValue(long key, int value) {
        throw new UnsupportedOperationException();
    }

    public int addValue(long key, int addition, int initialValue) {
        throw new UnsupportedOperationException();
    }

    public void putAll(@Nonnull Map<? extends Long, ? extends Integer> m) {
        CommonLongIntMapOps.putAll((InternalLongIntMapOps)this, m);
    }

    public Integer replace(Long key, Integer value) {
        throw new UnsupportedOperationException();
    }

    public int replace(long key, int value) {
        throw new UnsupportedOperationException();
    }

    public boolean replace(Long key, Integer oldValue, Integer newValue) {
        return this.replace((long)key, (int)oldValue, (int)newValue);
    }

    public boolean replace(long key, int oldValue, int newValue) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(BiFunction<? super Long, ? super Integer, ? extends Integer> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(LongIntToIntFunction function) {
        throw new UnsupportedOperationException();
    }

    public Integer remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(long key) {
        throw new UnsupportedOperationException();
    }

    public int remove(long key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Long)key, (Integer)value);
    }

    public boolean remove(long key, int value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(LongIntPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements LongIntCursor {
        final long[] keys;
        final int[] vals;
        final long free;
        int index;
        long curKey;
        int curValue;

        NoRemovedMapCursor() {
            long free;
            this.keys = ImmutableLHashSeparateKVLongIntMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVLongIntMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVLongIntMapGO.this.freeValue);
        }

        public void forEachForward(LongIntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            int[] vals = this.vals;
            long free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long key() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public int value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(int value) {
            if (this.curKey == this.free) {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            long[] keys = this.keys;
            long free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements IntCursor {
        final long[] keys;
        final int[] vals;
        final long free;
        int index;
        long curKey;
        int curValue;

        NoRemovedValueCursor() {
            long free;
            this.keys = ImmutableLHashSeparateKVLongIntMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVLongIntMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVLongIntMapGO.this.freeValue);
        }

        public void forEachForward(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            int[] vals = this.vals;
            long free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            long[] keys = this.keys;
            long free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements IntIterator {
        final long[] keys;
        final int[] vals;
        final long free;
        int nextIndex;
        int next;

        NoRemovedValueIterator() {
            this.keys = ImmutableLHashSeparateKVLongIntMapGO.this.set;
            long[] keys = ImmutableLHashSeparateKVLongIntMapGO.this.set;
            this.vals = ImmutableLHashSeparateKVLongIntMapGO.this.values;
            int[] vals = ImmutableLHashSeparateKVLongIntMapGO.this.values;
            long free = this.free = ImmutableLHashSeparateKVLongIntMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public int nextInt() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                long[] keys = this.keys;
                long free = this.free;
                int prev = this.next;
                while (--nextI >= 0) {
                    if (keys[nextI] == free) continue;
                    this.next = this.vals[nextI];
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Integer> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            int[] vals = this.vals;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Integer)vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(IntConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            int[] vals = this.vals;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Integer next() {
            return this.nextInt();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Long, Integer>> {
        final long[] keys;
        final int[] vals;
        final long free;
        int index;
        long curKey;
        int curValue;

        NoRemovedEntryCursor() {
            long free;
            this.keys = ImmutableLHashSeparateKVLongIntMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVLongIntMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVLongIntMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Long, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            int[] vals = this.vals;
            long free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Long, Integer>)((Object)new ImmutableEntry(key, vals[i])));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Long, Integer> elem() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            long[] keys = this.keys;
            long free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Long, Integer>> {
        final long[] keys;
        final int[] vals;
        final long free;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.keys = ImmutableLHashSeparateKVLongIntMapGO.this.set;
            long[] keys = ImmutableLHashSeparateKVLongIntMapGO.this.set;
            this.vals = ImmutableLHashSeparateKVLongIntMapGO.this.values;
            int[] vals = ImmutableLHashSeparateKVLongIntMapGO.this.values;
            long free = this.free = ImmutableLHashSeparateKVLongIntMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                long key = keys[nextI];
                if (key == free) continue;
                this.next = new ImmutableEntry(key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Long, Integer>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            int[] vals = this.vals;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Long, Integer>)((Object)new ImmutableEntry(key, vals[i])));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Long, Integer> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                long[] keys = this.keys;
                long free = this.free;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    long key = keys[nextI];
                    if (key == free) continue;
                    this.next = new ImmutableEntry(key, this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractIntValueView {
        ValueView() {
        }

        public int size() {
            return ImmutableLHashSeparateKVLongIntMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableLHashSeparateKVLongIntMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return ImmutableLHashSeparateKVLongIntMapGO.this.containsValue(o);
        }

        public boolean contains(int v) {
            return ImmutableLHashSeparateKVLongIntMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Integer> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long free = ImmutableLHashSeparateKVLongIntMapGO.this.freeValue;
            long[] keys = ImmutableLHashSeparateKVLongIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVLongIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Integer)vals[i]);
            }
        }

        public void forEach(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long free = ImmutableLHashSeparateKVLongIntMapGO.this.freeValue;
            long[] keys = ImmutableLHashSeparateKVLongIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVLongIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
        }

        public boolean forEachWhile(IntPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            long free = ImmutableLHashSeparateKVLongIntMapGO.this.freeValue;
            long[] keys = ImmutableLHashSeparateKVLongIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVLongIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        public boolean allContainingIn(IntCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            long free = ImmutableLHashSeparateKVLongIntMapGO.this.freeValue;
            long[] keys = ImmutableLHashSeparateKVLongIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVLongIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(IntCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long free = ImmutableLHashSeparateKVLongIntMapGO.this.freeValue;
            long[] keys = ImmutableLHashSeparateKVLongIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVLongIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(IntSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long free = ImmutableLHashSeparateKVLongIntMapGO.this.freeValue;
            long[] keys = ImmutableLHashSeparateKVLongIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVLongIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeInt(vals[i]);
            }
            return changed;
        }

        @Nonnull
        public IntIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public IntCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long free = ImmutableLHashSeparateKVLongIntMapGO.this.freeValue;
            long[] keys = ImmutableLHashSeparateKVLongIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVLongIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            long free = ImmutableLHashSeparateKVLongIntMapGO.this.freeValue;
            long[] keys = ImmutableLHashSeparateKVLongIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVLongIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public int[] toIntArray() {
            int size = this.size();
            int[] result = new int[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long free = ImmutableLHashSeparateKVLongIntMapGO.this.freeValue;
            long[] keys = ImmutableLHashSeparateKVLongIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVLongIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        public int[] toArray(int[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new int[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            long free = ImmutableLHashSeparateKVLongIntMapGO.this.freeValue;
            long[] keys = ImmutableLHashSeparateKVLongIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVLongIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            long free = ImmutableLHashSeparateKVLongIntMapGO.this.freeValue;
            long[] keys = ImmutableLHashSeparateKVLongIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVLongIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeInt((Integer)o);
        }

        public boolean removeInt(int v) {
            return ImmutableLHashSeparateKVLongIntMapGO.this.removeValue(v);
        }

        public void clear() {
            ImmutableLHashSeparateKVLongIntMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Integer> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(IntPredicate filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends LongIntEntry {
        private long key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(long key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends LongIntEntry {
        private final long key;
        private final int value;

        ImmutableEntry(long key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    abstract class LongIntEntry
    extends AbstractEntry<Long, Integer> {
        LongIntEntry() {
        }

        abstract long key();

        public final Long getKey() {
            return this.key();
        }

        abstract int value();

        public final Integer getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                long k2 = (Long)e2.getKey();
                int v2 = (Integer)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((long)this.key()) ^ Primitives.hashCode((int)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Long, Integer>>
    implements HashObjSet<Map.Entry<Long, Integer>>,
    InternalObjCollectionOps<Map.Entry<Long, Integer>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Long, Integer>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableLHashSeparateKVLongIntMapGO.this.hashConfig();
        }

        public int size() {
            return ImmutableLHashSeparateKVLongIntMapGO.this.size;
        }

        public double currentLoad() {
            return ImmutableLHashSeparateKVLongIntMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableLHashSeparateKVLongIntMapGO.this.containsEntry((Long)e.getKey(), (Integer)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long free = ImmutableLHashSeparateKVLongIntMapGO.this.freeValue;
            long[] keys = ImmutableLHashSeparateKVLongIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVLongIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            long free = ImmutableLHashSeparateKVLongIntMapGO.this.freeValue;
            long[] keys = ImmutableLHashSeparateKVLongIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVLongIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Long, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long free = ImmutableLHashSeparateKVLongIntMapGO.this.freeValue;
            long[] keys = ImmutableLHashSeparateKVLongIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVLongIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Long, Integer>)((Object)new ImmutableEntry(key, vals[i])));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Long, Integer>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            long free = ImmutableLHashSeparateKVLongIntMapGO.this.freeValue;
            long[] keys = ImmutableLHashSeparateKVLongIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVLongIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || predicate.test((Map.Entry<Long, Integer>)((Object)new ImmutableEntry(key, vals[i])))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Long, Integer>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Long, Integer>> cursor() {
            return new NoRemovedEntryCursor();
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            long free = ImmutableLHashSeparateKVLongIntMapGO.this.freeValue;
            long[] keys = ImmutableLHashSeparateKVLongIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVLongIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            long free = ImmutableLHashSeparateKVLongIntMapGO.this.freeValue;
            long[] keys = ImmutableLHashSeparateKVLongIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVLongIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Long, Integer>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long free = ImmutableLHashSeparateKVLongIntMapGO.this.freeValue;
            long[] keys = ImmutableLHashSeparateKVLongIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVLongIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new ImmutableEntry(key, vals[i]));
            }
            return changed;
        }

        public int hashCode() {
            return ImmutableLHashSeparateKVLongIntMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            long free = ImmutableLHashSeparateKVLongIntMapGO.this.freeValue;
            long[] keys = ImmutableLHashSeparateKVLongIntMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVLongIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableLHashSeparateKVLongIntMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                long key = (Long)e.getKey();
                int value = (Integer)e.getValue();
                return ImmutableLHashSeparateKVLongIntMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Long, Integer>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

