/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalShortByteMapOps;
import com.koloboke.collect.map.ShortByteMap;
import com.koloboke.function.ShortByteConsumer;
import com.koloboke.function.ShortBytePredicate;
import java.util.Map;

public final class CommonShortByteMapOps {
    public static boolean containsAllEntries(final InternalShortByteMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ShortByteMap) {
            ShortByteMap m2 = (ShortByteMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalShortByteMapOps) {
                return ((InternalShortByteMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new ShortBytePredicate(){

                public boolean test(short a, byte b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Short)e.getKey(), (Byte)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalShortByteMapOps map, Map<? extends Short, ? extends Byte> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ShortByteMap) {
            if (another instanceof InternalShortByteMapOps) {
                ((InternalShortByteMapOps)another).reversePutAllTo(map);
            } else {
                ((ShortByteMap)another).forEach(new ShortByteConsumer(){

                    public void accept(short key, byte value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Short, ? extends Byte> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonShortByteMapOps() {
    }
}

