/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalLongCharMapOps;
import com.koloboke.collect.map.LongCharMap;
import com.koloboke.function.LongCharConsumer;
import com.koloboke.function.LongCharPredicate;
import java.util.Map;

public final class CommonLongCharMapOps {
    public static boolean containsAllEntries(final InternalLongCharMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof LongCharMap) {
            LongCharMap m2 = (LongCharMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalLongCharMapOps) {
                return ((InternalLongCharMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new LongCharPredicate(){

                public boolean test(long a, char b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Long)e.getKey(), ((Character)e.getValue()).charValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalLongCharMapOps map, Map<? extends Long, ? extends Character> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof LongCharMap) {
            if (another instanceof InternalLongCharMapOps) {
                ((InternalLongCharMapOps)another).reversePutAllTo(map);
            } else {
                ((LongCharMap)another).forEach(new LongCharConsumer(){

                    public void accept(long key, char value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Long, ? extends Character> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue().charValue());
            }
        }
    }

    private CommonLongCharMapOps() {
    }
}

