/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalFloatFloatMapOps;
import com.koloboke.collect.map.FloatFloatMap;
import com.koloboke.function.FloatFloatConsumer;
import com.koloboke.function.FloatFloatPredicate;
import java.util.Map;

public final class CommonFloatFloatMapOps {
    public static boolean containsAllEntries(final InternalFloatFloatMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof FloatFloatMap) {
            FloatFloatMap m2 = (FloatFloatMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalFloatFloatMapOps) {
                return ((InternalFloatFloatMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new FloatFloatPredicate(){

                public boolean test(float a, float b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(((Float)e.getKey()).floatValue(), ((Float)e.getValue()).floatValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalFloatFloatMapOps map, Map<? extends Float, ? extends Float> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof FloatFloatMap) {
            if (another instanceof InternalFloatFloatMapOps) {
                ((InternalFloatFloatMapOps)another).reversePutAllTo(map);
            } else {
                ((FloatFloatMap)another).forEach(new FloatFloatConsumer(){

                    public void accept(float key, float value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Float, ? extends Float> e : another.entrySet()) {
                map.justPut(e.getKey().floatValue(), e.getValue().floatValue());
            }
        }
    }

    private CommonFloatFloatMapOps() {
    }
}

