/*
 * Decompiled with CFR 0.152.
 */
package thermos.updater;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import thermos.Thermos;
import thermos.updater.DefaultUpdateCallback;
import thermos.updater.TVersionRetriever;

public class CommandSenderUpdateCallback
implements TVersionRetriever.IVersionCheckCallback {
    private Reference<CommandSender> mSender;

    public CommandSenderUpdateCallback(CommandSender sender) {
        this.mSender = new WeakReference<CommandSender>(sender);
    }

    protected CommandSender getSender() {
        return this.mSender.get();
    }

    @Override
    public void upToDate() {
        CommandSender sender = this.mSender.get();
        if (sender != null) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "[Thermos] " + (Object)((Object)ChatColor.GRAY) + "Thermos is up-to-date: " + Thermos.getCurrentVersion());
        }
        DefaultUpdateCallback.INSTANCE.upToDate();
    }

    @Override
    public void newVersion(String newVersion) {
        CommandSender sender = this.mSender.get();
        if (sender != null) {
            CommandSenderUpdateCallback.newVersion(sender, Thermos.getCurrentVersion(), newVersion);
        }
        DefaultUpdateCallback.INSTANCE.newVersion(newVersion);
    }

    public static void newVersion(CommandSender sender, String currentVersion, String newVersion) {
        sender.sendMessage(new String[]{(Object)((Object)ChatColor.RED) + "[Thermos] " + (Object)((Object)ChatColor.GRAY) + "Found new version of Thermos: " + newVersion, (Object)((Object)ChatColor.RED) + "[Thermos] " + (Object)((Object)ChatColor.GRAY) + "Current version is: " + currentVersion, (Object)((Object)ChatColor.RED) + "[Thermos] " + (Object)((Object)ChatColor.GREEN) + "Download at: https://github.com/CyberdyneCC/Thermos/releases"});
    }

    @Override
    public void error(Throwable t) {
        CommandSender sender = this.mSender.get();
        if (sender != null) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "[Thermos] " + (Object)((Object)ChatColor.DARK_RED) + "Error ocurred durring version check, see details in server log.");
        }
    }
}

