/*
 * Decompiled with CFR 0.152.
 */
package thermos;

import net.minecraft.server.MinecraftServer;
import net.minecraftforge.cauldron.configuration.BoolSetting;
import net.minecraftforge.cauldron.configuration.ConfigBase;
import net.minecraftforge.cauldron.configuration.Setting;
import org.bukkit.configuration.file.YamlConfiguration;
import thermos.ThermosCommand;

public class ThermosConfig
extends ConfigBase {
    public BoolSetting commandEnable = new BoolSetting(this, "command.enable", true, "Enable Thermos command");
    public BoolSetting opConsoleOnly = new BoolSetting(this, "op.consoleonly", false, "Set the OP command to only be allowed to run in console");
    public BoolSetting updatecheckerEnable = new BoolSetting(this, "updatechecker.enable", true, "Enable Thermos update checker");
    public BoolSetting updatecheckerQuiet = new BoolSetting(this, "updatechecker.quiet", false, "Print less info during update");
    public BoolSetting loggingMaterialInjection = new BoolSetting(this, "logging.materialInjection", false, "Log material injection event");
    public BoolSetting loggingClientModList = new BoolSetting(this, "logging.clientModList", true, "Print client's mod list during attempt to join");
    public BoolSetting commonAllowNetherPortal = new BoolSetting(this, "common.allowNetherPortalBesidesOverworld", false, "Allow nether portals in dimensions besides overworld");

    public ThermosConfig() {
        super("thermos.yml", "thermos");
        this.register(this.commandEnable);
        this.register(this.updatecheckerEnable);
        this.register(this.updatecheckerQuiet);
        this.register(this.loggingMaterialInjection);
        this.register(this.loggingClientModList);
        this.register(this.commonAllowNetherPortal);
        this.register(this.opConsoleOnly);
        this.load();
    }

    private void register(Setting<?> setting) {
        this.settings.put(setting.path, setting);
    }

    @Override
    public void registerCommands() {
        if (this.commandEnable.getValue().booleanValue()) {
            super.registerCommands();
        }
    }

    @Override
    protected void addCommands() {
        this.commands.put(this.commandName, new ThermosCommand());
    }

    @Override
    protected void load() {
        try {
            this.config = YamlConfiguration.loadConfiguration(this.configFile);
            String header = "";
            for (Setting toggle : this.settings.values()) {
                if (!toggle.description.equals("")) {
                    header = header + "Setting: " + toggle.path + " Default: " + toggle.def + " # " + toggle.description + "\n";
                }
                this.config.addDefault(toggle.path, toggle.def);
                ((Setting)this.settings.get(toggle.path)).setValue(this.config.getString(toggle.path));
            }
            this.config.options().header(header);
            this.config.options().copyDefaults(true);
            this.save();
        }
        catch (Exception ex) {
            MinecraftServer.I().h("Could not load " + this.configFile);
            ex.printStackTrace();
        }
    }
}

