/*
 * Decompiled with CFR 0.152.
 */
package thermos;

import cpw.mods.fml.common.FMLCommonHandler;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Properties;
import org.spigotmc.RestartCommand;
import thermos.TLog;

public class Thermos {
    public static final ThreadGroup sThermosThreadGroup = new ThreadGroup("Thermos");
    private static boolean sManifestParsed = false;
    private static String sCurrentVersion;
    private static File sServerLocation;
    private static File sServerHome;
    private static String sGroup;
    private static String sBranch;
    private static String sChannel;
    private static boolean sLegacy;
    private static boolean sOfficial;
    public static File sNewServerLocation;
    public static String sNewServerVersion;
    public static boolean sUpdateInProgress;
    private static int sForgeRevision;

    private static void parseManifest() {
        if (sManifestParsed) {
            return;
        }
        sManifestParsed = true;
        try {
            Enumeration<URL> resources = Thermos.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            Properties manifest = new Properties();
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                manifest.load(url.openStream());
                String version = manifest.getProperty("Thermos-Version");
                if (version != null) {
                    String path = url.getPath();
                    String jarFilePath = path.substring(path.indexOf(":") + 1, path.indexOf("!"));
                    jarFilePath = URLDecoder.decode(jarFilePath, "UTF-8");
                    sServerLocation = new File(jarFilePath);
                    sCurrentVersion = version;
                    sGroup = manifest.getProperty("Thermos-Group");
                    sBranch = manifest.getProperty("Thermos-Branch");
                    sChannel = manifest.getProperty("Thermos-Channel");
                    sLegacy = Boolean.parseBoolean(manifest.getProperty("Thermos-Legacy"));
                    sOfficial = Boolean.parseBoolean(manifest.getProperty("Thermos-Official"));
                    break;
                }
                manifest.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getCurrentVersion() {
        Thermos.parseManifest();
        return sCurrentVersion;
    }

    public static File getServerLocation() {
        Thermos.parseManifest();
        return sServerLocation;
    }

    public static File getServerHome() {
        if (sServerHome == null) {
            String home = System.getenv("THERMOS_HOME");
            if (home != null) {
                sServerHome = new File(home);
            } else {
                Thermos.parseManifest();
                sServerHome = sServerLocation.getParentFile();
            }
        }
        return sServerHome;
    }

    public static String getGroup() {
        Thermos.parseManifest();
        return sGroup;
    }

    public static String getBranch() {
        Thermos.parseManifest();
        return sBranch;
    }

    public static String getChannel() {
        Thermos.parseManifest();
        return sChannel;
    }

    public static boolean isLegacy() {
        Thermos.parseManifest();
        return sLegacy;
    }

    public static boolean isOfficial() {
        Thermos.parseManifest();
        return sOfficial;
    }

    public static void restart() {
        RestartCommand.restart(true);
    }

    public static int lookupForgeRevision() {
        if (sForgeRevision != 0) {
            return sForgeRevision;
        }
        int revision = Integer.parseInt(System.getProperty("thermos.forgeRevision", "0"));
        if (revision != 0) {
            sForgeRevision = revision;
            return sForgeRevision;
        }
        try {
            Properties p2 = new Properties();
            p2.load(Thermos.class.getResourceAsStream("/fmlversion.properties"));
            revision = Integer.parseInt(String.valueOf(p2.getProperty("fmlbuild.build.number", "0")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (revision == 0) {
            TLog.get().warning("Thermos: could not parse forge revision, critical error", new Object[0]);
            FMLCommonHandler.instance().exitJava(1, false);
        }
        sForgeRevision = revision;
        return sForgeRevision;
    }

    static {
        sForgeRevision = 0;
    }
}

