/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R4.event;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.util.FakePlayer;
import org.bukkit.Bukkit;
import org.bukkit.Instrument;
import org.bukkit.Material;
import org.bukkit.Note;
import org.bukkit.Server;
import org.bukkit.Statistic;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_7_R4.CraftServer;
import org.bukkit.craftbukkit.v1_7_R4.CraftStatistic;
import org.bukkit.craftbukkit.v1_7_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_7_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_7_R4.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftInventoryCrafting;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_7_R4.util.CraftDamageSource;
import org.bukkit.craftbukkit.v1_7_R4.util.CraftMagicNumbers;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.NotePlayEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.ExpBottleEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.HorseJumpEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.PigZapEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerAchievementAwardedEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.bukkit.event.player.PlayerStatisticIncrementEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;

public class CraftEventFactory {
    public static final ro MELTING = CraftDamageSource.copyOf(ro.b);
    public static final ro POISON = CraftDamageSource.copyOf(ro.k);
    public static Block blockDamage;
    public static sa entityDamage;
    private static final Function<? super Double, Double> ZERO;

    private static boolean canBuild(CraftWorld world, Player player, int x, int z2) {
        mt worldServer = world.getHandle();
        int spawnSize = Bukkit.getServer().getSpawnRadius();
        if (world.getHandle().t.i != 0) {
            return true;
        }
        if (spawnSize <= 0) {
            return true;
        }
        if (((CraftServer)Bukkit.getServer()).getHandle().m().d()) {
            return true;
        }
        if (player.isOp()) {
            return true;
        }
        r chunkcoordinates = worldServer.K();
        int distanceFromSpawn = Math.max(Math.abs(x - chunkcoordinates.a), Math.abs(z2 - chunkcoordinates.c));
        return distanceFromSpawn > spawnSize;
    }

    public static <T extends Event> T callEvent(T event) {
        Bukkit.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static BlockMultiPlaceEvent callBlockMultiPlaceEvent(ahb world, yz who, List<BlockState> blockStates, int clickedX, int clickedY, int clickedZ) {
        CraftWorld craftWorld = world.getWorld();
        CraftServer craftServer = world.getServer();
        Player player = who == null ? null : (Player)((Object)who.getBukkitEntity());
        Block blockClicked = craftWorld.getBlockAt(clickedX, clickedY, clickedZ);
        boolean canBuild = true;
        for (int i = 0; i < blockStates.size(); ++i) {
            if (CraftEventFactory.canBuild(craftWorld, player, blockStates.get(i).getX(), blockStates.get(i).getZ())) continue;
            canBuild = false;
            break;
        }
        BlockMultiPlaceEvent event = new BlockMultiPlaceEvent(blockStates, blockClicked, player.getItemInHand(), player, canBuild);
        craftServer.getPluginManager().callEvent(event);
        return event;
    }

    public static BlockPlaceEvent callBlockPlaceEvent(ahb world, yz who, BlockState replacedBlockState, int clickedX, int clickedY, int clickedZ) {
        CraftWorld craftWorld = world.getWorld();
        CraftServer craftServer = world.getServer();
        Player player = who == null ? null : (Player)((Object)who.getBukkitEntity());
        Block blockClicked = craftWorld.getBlockAt(clickedX, clickedY, clickedZ);
        Block placedBlock = replacedBlockState.getBlock();
        boolean canBuild = CraftEventFactory.canBuild(craftWorld, player, placedBlock.getX(), placedBlock.getZ());
        BlockPlaceEvent event = new BlockPlaceEvent(placedBlock, replacedBlockState, blockClicked, player.getItemInHand(), player, canBuild);
        craftServer.getPluginManager().callEvent(event);
        return event;
    }

    public static PlayerBucketEmptyEvent callPlayerBucketEmptyEvent(yz who, int clickedX, int clickedY, int clickedZ, int clickedFace, add itemInHand) {
        return (PlayerBucketEmptyEvent)CraftEventFactory.getPlayerBucketEvent(false, who, clickedX, clickedY, clickedZ, clickedFace, itemInHand, ade.ar);
    }

    public static PlayerBucketFillEvent callPlayerBucketFillEvent(yz who, int clickedX, int clickedY, int clickedZ, int clickedFace, add itemInHand, adb bucket) {
        return (PlayerBucketFillEvent)CraftEventFactory.getPlayerBucketEvent(true, who, clickedX, clickedY, clickedZ, clickedFace, itemInHand, bucket);
    }

    private static PlayerEvent getPlayerBucketEvent(boolean isFilling, yz who, int clickedX, int clickedY, int clickedZ, int clickedFace, add itemstack, adb item) {
        Player player = who == null ? null : (Player)((Object)who.getBukkitEntity());
        CraftItemStack itemInHand = CraftItemStack.asNewCraftStack(item);
        Material bucket = CraftMagicNumbers.getMaterial(itemstack.b());
        CraftWorld craftWorld = (CraftWorld)player.getWorld();
        CraftServer craftServer = (CraftServer)player.getServer();
        Block blockClicked = craftWorld.getBlockAt(clickedX, clickedY, clickedZ);
        BlockFace blockFace = CraftBlock.notchToBlockFace(clickedFace);
        PlayerBucketEvent event = null;
        if (isFilling) {
            event = new PlayerBucketFillEvent(player, blockClicked, blockFace, bucket, itemInHand);
            event.setCancelled(!CraftEventFactory.canBuild(craftWorld, player, clickedX, clickedZ));
        } else {
            event = new PlayerBucketEmptyEvent(player, blockClicked, blockFace, bucket, itemInHand);
            ((PlayerBucketEmptyEvent)event).setCancelled(!CraftEventFactory.canBuild(craftWorld, player, clickedX, clickedZ));
        }
        craftServer.getPluginManager().callEvent(event);
        return event;
    }

    public static PlayerInteractEvent callPlayerInteractEvent(yz who, Action action, add itemstack) {
        if (action != Action.LEFT_CLICK_AIR && action != Action.RIGHT_CLICK_AIR) {
            throw new IllegalArgumentException();
        }
        return CraftEventFactory.callPlayerInteractEvent(who, action, 0, 256, 0, 0, itemstack);
    }

    public static PlayerInteractEvent callPlayerInteractEvent(yz who, Action action, int clickedX, int clickedY, int clickedZ, int clickedFace, add itemstack) {
        Player player = who == null ? null : (Player)((Object)who.getBukkitEntity());
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(itemstack);
        CraftWorld craftWorld = (CraftWorld)player.getWorld();
        CraftServer craftServer = (CraftServer)player.getServer();
        Block blockClicked = craftWorld.getBlockAt(clickedX, clickedY, clickedZ);
        BlockFace blockFace = CraftBlock.notchToBlockFace(clickedFace);
        if (clickedY > 255) {
            blockClicked = null;
            switch (action) {
                case LEFT_CLICK_BLOCK: {
                    action = Action.LEFT_CLICK_AIR;
                    break;
                }
                case RIGHT_CLICK_BLOCK: {
                    action = Action.RIGHT_CLICK_AIR;
                }
            }
        }
        if (itemInHand.getType() == Material.AIR || itemInHand.getAmount() == 0) {
            itemInHand = null;
        }
        PlayerInteractEvent event = new PlayerInteractEvent(player, action, itemInHand, blockClicked, blockFace);
        craftServer.getPluginManager().callEvent(event);
        return event;
    }

    public static EntityShootBowEvent callEntityShootBowEvent(sv who, add itemstack, zc entityArrow, float force) {
        LivingEntity shooter = (LivingEntity)((Object)who.getBukkitEntity());
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(itemstack);
        Arrow arrow = (Arrow)((Object)entityArrow.getBukkitEntity());
        if (itemInHand != null && (itemInHand.getType() == Material.AIR || itemInHand.getAmount() == 0)) {
            itemInHand = null;
        }
        EntityShootBowEvent event = new EntityShootBowEvent(shooter, itemInHand, arrow, force);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static BlockDamageEvent callBlockDamageEvent(yz who, int x, int y2, int z2, add itemstack, boolean instaBreak) {
        Player player = who == null ? null : (Player)((Object)who.getBukkitEntity());
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(itemstack);
        CraftWorld craftWorld = (CraftWorld)player.getWorld();
        CraftServer craftServer = (CraftServer)player.getServer();
        Block blockClicked = craftWorld.getBlockAt(x, y2, z2);
        BlockDamageEvent event = new BlockDamageEvent(player, blockClicked, itemInHand, instaBreak);
        craftServer.getPluginManager().callEvent(event);
        return event;
    }

    public static CreatureSpawnEvent callCreatureSpawnEvent(sv entityliving, CreatureSpawnEvent.SpawnReason spawnReason) {
        LivingEntity entity = (LivingEntity)((Object)entityliving.getBukkitEntity());
        CraftServer craftServer = (CraftServer)entity.getServer();
        CreatureSpawnEvent event = new CreatureSpawnEvent(entity, spawnReason);
        craftServer.getPluginManager().callEvent(event);
        return event;
    }

    public static EntityTameEvent callEntityTameEvent(sw entity, yz tamer) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        CraftHumanEntity bukkitTamer = tamer != null ? tamer.getBukkitEntity() : null;
        CraftServer craftServer = (CraftServer)bukkitEntity.getServer();
        entity.bt = true;
        EntityTameEvent event = new EntityTameEvent((LivingEntity)((Object)bukkitEntity), bukkitTamer);
        craftServer.getPluginManager().callEvent(event);
        return event;
    }

    public static ItemSpawnEvent callItemSpawnEvent(xk entityitem) {
        Item entity = (Item)((Object)entityitem.getBukkitEntity());
        CraftServer craftServer = (CraftServer)entity.getServer();
        ItemSpawnEvent event = new ItemSpawnEvent(entity, entity.getLocation());
        craftServer.getPluginManager().callEvent(event);
        return event;
    }

    public static ItemDespawnEvent callItemDespawnEvent(xk entityitem) {
        Item entity = (Item)((Object)entityitem.getBukkitEntity());
        ItemDespawnEvent event = new ItemDespawnEvent(entity, entity.getLocation());
        entity.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static PotionSplashEvent callPotionSplashEvent(zo potion, Map<LivingEntity, Double> affectedEntities) {
        ThrownPotion thrownPotion = (ThrownPotion)((Object)potion.getBukkitEntity());
        PotionSplashEvent event = new PotionSplashEvent(thrownPotion, affectedEntities);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static BlockFadeEvent callBlockFadeEvent(Block block, aji type) {
        BlockState state = block.getState();
        state.setTypeId(aji.b((aji)type));
        BlockFadeEvent event = new BlockFadeEvent(block, state);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static void handleBlockSpreadEvent(Block block, Block source, aji type, int data) {
        BlockState state = block.getState();
        state.setTypeId(aji.b((aji)type));
        state.setRawData((byte)data);
        BlockSpreadEvent event = new BlockSpreadEvent(block, source, state);
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            state.update(true);
        }
    }

    public static EntityDeathEvent callEntityDeathEvent(sv victim) {
        return CraftEventFactory.callEntityDeathEvent(victim, new ArrayList<ItemStack>(0));
    }

    public static EntityDeathEvent callEntityDeathEvent(sv victim, List<ItemStack> drops) {
        CraftLivingEntity entity = (CraftLivingEntity)victim.getBukkitEntity();
        EntityDeathEvent event = new EntityDeathEvent(entity, drops, victim.getExpReward());
        Bukkit.getServer().getPluginManager().callEvent(event);
        victim.expToDrop = event.getDroppedExp();
        victim.capturedDrops.clear();
        for (ItemStack stack : event.getDrops()) {
            xk entityitem = new xk(victim.o, entity.getLocation().getX(), entity.getLocation().getY(), entity.getLocation().getZ(), CraftItemStack.asNMSCopy(stack));
            if (entityitem == null) continue;
            victim.capturedDrops.add(entityitem);
        }
        return event;
    }

    public static PlayerDeathEvent callPlayerDeathEvent(mw victim, List<ItemStack> drops, String deathMessage, boolean keepInventory) {
        CraftPlayer entity = victim.getBukkitEntity();
        PlayerDeathEvent event = new PlayerDeathEvent(entity, drops, victim.getExpReward(), 0, deathMessage);
        event.setKeepInventory(keepInventory);
        Bukkit.getServer().getPluginManager().callEvent(event);
        victim.keepLevel = event.getKeepLevel();
        victim.newLevel = event.getNewLevel();
        victim.newTotalExp = event.getNewTotalExp();
        victim.expToDrop = event.getDroppedExp();
        victim.newExp = event.getNewExp();
        if (event.getKeepInventory()) {
            return event;
        }
        victim.capturedDrops.clear();
        for (ItemStack stack : event.getDrops()) {
            xk entityitem;
            if (stack == null || stack.getType() == Material.AIR || !victim.captureDrops || (entityitem = new xk(victim.o, entity.getLocation().getX(), entity.getLocation().getY(), entity.getLocation().getZ(), CraftItemStack.asNMSCopy(stack))) == null) continue;
            victim.capturedDrops.add(entityitem);
        }
        return event;
    }

    public static ServerListPingEvent callServerListPingEvent(Server craftServer, InetAddress address, String motd, int numPlayers, int maxPlayers) {
        ServerListPingEvent event = new ServerListPingEvent(address, motd, numPlayers, maxPlayers);
        craftServer.getPluginManager().callEvent(event);
        return event;
    }

    private static EntityDamageEvent handleEntityDamageEvent(sa entity, ro source, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, Function<? super Double, Double>> modifierFunctions) {
        if (source.c()) {
            EntityDamageEvent event;
            sa damager = entityDamage;
            entityDamage = null;
            if (damager == null) {
                event = new EntityDamageByBlockEvent(null, entity.getBukkitEntity(), EntityDamageEvent.DamageCause.BLOCK_EXPLOSION, modifiers, modifierFunctions);
            } else if (entity instanceof xa && ((xa)entity).bC == damager) {
                event = new EntityDamageEvent(entity.getBukkitEntity(), EntityDamageEvent.DamageCause.ENTITY_EXPLOSION, modifiers, modifierFunctions);
            } else {
                EntityDamageEvent.DamageCause damageCause = damager instanceof TNTPrimed ? EntityDamageEvent.DamageCause.BLOCK_EXPLOSION : EntityDamageEvent.DamageCause.ENTITY_EXPLOSION;
                event = new EntityDamageByEntityEvent(damager.getBukkitEntity(), entity.getBukkitEntity(), damageCause, modifiers, modifierFunctions);
            }
            CraftEventFactory.callEvent(event);
            if (!event.isCancelled()) {
                event.getEntity().setLastDamageCause(event);
            }
            return event;
        }
        if (source instanceof rp) {
            sa damager = source.j();
            EntityDamageEvent.DamageCause cause = EntityDamageEvent.DamageCause.ENTITY_ATTACK;
            sa indirect = null;
            if (source instanceof rq) {
                indirect = ((rq)source).i();
                damager = ((rq)source).getProximateDamageSource();
                if (damager != null) {
                    if (damager.getBukkitEntity() instanceof ThrownPotion) {
                        cause = EntityDamageEvent.DamageCause.MAGIC;
                    } else if (damager.getBukkitEntity() instanceof Projectile) {
                        cause = EntityDamageEvent.DamageCause.PROJECTILE;
                    }
                }
                if (indirect != null && indirect instanceof yz && cause == null) {
                    cause = EntityDamageEvent.DamageCause.ENTITY_ATTACK;
                    damager = indirect;
                }
            } else if ("thorns".equals(source.o)) {
                cause = EntityDamageEvent.DamageCause.THORNS;
            }
            return CraftEventFactory.callEntityDamageEvent(damager, entity, cause, modifiers, modifierFunctions);
        }
        if (source == ro.i) {
            EntityDamageEvent event = CraftEventFactory.callEvent(new EntityDamageByBlockEvent(null, entity.getBukkitEntity(), EntityDamageEvent.DamageCause.VOID, modifiers, modifierFunctions));
            if (!event.isCancelled()) {
                event.getEntity().setLastDamageCause(event);
            }
            return event;
        }
        if (source == ro.c) {
            EntityDamageEvent event = CraftEventFactory.callEvent(new EntityDamageByBlockEvent(null, entity.getBukkitEntity(), EntityDamageEvent.DamageCause.LAVA, modifiers, modifierFunctions));
            if (!event.isCancelled()) {
                event.getEntity().setLastDamageCause(event);
            }
            return event;
        }
        if (blockDamage != null) {
            EntityDamageEvent.DamageCause cause = null;
            Block damager = blockDamage;
            blockDamage = null;
            cause = source == ro.g ? EntityDamageEvent.DamageCause.CONTACT : (source == ro.h ? EntityDamageEvent.DamageCause.FALL : (source == ro.m || source == ro.n ? EntityDamageEvent.DamageCause.FALLING_BLOCK : (source == ro.a ? EntityDamageEvent.DamageCause.FIRE : (source == ro.b ? EntityDamageEvent.DamageCause.FIRE_TICK : (source == ro.c ? EntityDamageEvent.DamageCause.LAVA : (damager instanceof LightningStrike ? EntityDamageEvent.DamageCause.LIGHTNING : (source == ro.k ? EntityDamageEvent.DamageCause.MAGIC : (source == MELTING ? EntityDamageEvent.DamageCause.MELTING : (source == POISON ? EntityDamageEvent.DamageCause.POISON : (source == ro.j ? EntityDamageEvent.DamageCause.CUSTOM : EntityDamageEvent.DamageCause.CUSTOM))))))))));
            EntityDamageEvent event = CraftEventFactory.callEvent(new EntityDamageByBlockEvent(damager, entity.getBukkitEntity(), cause, modifiers, modifierFunctions));
            if (!event.isCancelled()) {
                event.getEntity().setLastDamageCause(event);
            }
            return event;
        }
        if (entityDamage != null) {
            EntityDamageEvent.DamageCause cause = null;
            CraftEntity damager = entityDamage.getBukkitEntity();
            entityDamage = null;
            cause = source == ro.m || source == ro.n ? EntityDamageEvent.DamageCause.FALLING_BLOCK : (damager instanceof LightningStrike ? EntityDamageEvent.DamageCause.LIGHTNING : (source == ro.h ? EntityDamageEvent.DamageCause.FALL : (source == ro.g ? EntityDamageEvent.DamageCause.CONTACT : (source == ro.a ? EntityDamageEvent.DamageCause.FIRE : (source == ro.b ? EntityDamageEvent.DamageCause.FIRE_TICK : (source == ro.c ? EntityDamageEvent.DamageCause.LAVA : (source == ro.k ? EntityDamageEvent.DamageCause.MAGIC : (source == MELTING ? EntityDamageEvent.DamageCause.MELTING : (source == POISON ? EntityDamageEvent.DamageCause.POISON : (source == ro.j ? EntityDamageEvent.DamageCause.CUSTOM : EntityDamageEvent.DamageCause.CUSTOM))))))))));
            EntityDamageEvent event = CraftEventFactory.callEvent(new EntityDamageByEntityEvent(damager, entity.getBukkitEntity(), cause, modifiers, modifierFunctions));
            if (!event.isCancelled()) {
                event.getEntity().setLastDamageCause(event);
            }
            return event;
        }
        EntityDamageEvent.DamageCause cause = null;
        if (source == ro.a) {
            cause = EntityDamageEvent.DamageCause.FIRE;
        } else if (source == ro.f) {
            cause = EntityDamageEvent.DamageCause.STARVATION;
        } else if (source == ro.l) {
            cause = EntityDamageEvent.DamageCause.WITHER;
        } else if (source == ro.d) {
            cause = EntityDamageEvent.DamageCause.SUFFOCATION;
        } else if (source == ro.e) {
            cause = EntityDamageEvent.DamageCause.DROWNING;
        } else if (source == ro.b) {
            cause = EntityDamageEvent.DamageCause.FIRE_TICK;
        } else if (source == MELTING) {
            cause = EntityDamageEvent.DamageCause.MELTING;
        } else if (source == POISON) {
            cause = EntityDamageEvent.DamageCause.POISON;
        } else if (source == ro.k) {
            cause = EntityDamageEvent.DamageCause.MAGIC;
        } else if (source == ro.h) {
            cause = EntityDamageEvent.DamageCause.FALL;
        } else if (source == ro.g) {
            cause = EntityDamageEvent.DamageCause.CONTACT;
        } else if (source == ro.c) {
            cause = EntityDamageEvent.DamageCause.LAVA;
        } else if (source == ro.j || cause == null) {
            return new EntityDamageEvent(entity.getBukkitEntity(), EntityDamageEvent.DamageCause.CUSTOM, modifiers, modifierFunctions);
        }
        return CraftEventFactory.callEntityDamageEvent(null, entity, cause, modifiers, modifierFunctions);
    }

    private static EntityDamageEvent callEntityDamageEvent(sa damager, sa damagee, EntityDamageEvent.DamageCause cause, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, Function<? super Double, Double>> modifierFunctions) {
        EntityDamageEvent event = damager != null ? new EntityDamageByEntityEvent(damager.getBukkitEntity(), damagee.getBukkitEntity(), cause, modifiers, modifierFunctions) : new EntityDamageEvent(damagee.getBukkitEntity(), cause, modifiers, modifierFunctions);
        CraftEventFactory.callEvent(event);
        if (!event.isCancelled()) {
            event.getEntity().setLastDamageCause(event);
        }
        return event;
    }

    public static EntityDamageEvent handleLivingEntityDamageEvent(sa damagee, ro source, double rawDamage, double hardHatModifier, double blockingModifier, double armorModifier, double resistanceModifier, double magicModifier, double absorptionModifier, Function<Double, Double> hardHat, Function<Double, Double> blocking, Function<Double, Double> armor, Function<Double, Double> resistance, Function<Double, Double> magic, Function<Double, Double> absorption) {
        EnumMap<EntityDamageEvent.DamageModifier, Double> modifiers = new EnumMap<EntityDamageEvent.DamageModifier, Double>(EntityDamageEvent.DamageModifier.class);
        EnumMap<EntityDamageEvent.DamageModifier, Function<? super Double, Double>> modifierFunctions = new EnumMap<EntityDamageEvent.DamageModifier, Function<? super Double, Double>>(EntityDamageEvent.DamageModifier.class);
        modifiers.put(EntityDamageEvent.DamageModifier.BASE, rawDamage);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.BASE, ZERO);
        if (source == ro.n || source == ro.m) {
            modifiers.put(EntityDamageEvent.DamageModifier.HARD_HAT, hardHatModifier);
            modifierFunctions.put(EntityDamageEvent.DamageModifier.HARD_HAT, hardHat);
        }
        if (damagee instanceof yz) {
            modifiers.put(EntityDamageEvent.DamageModifier.BLOCKING, blockingModifier);
            modifierFunctions.put(EntityDamageEvent.DamageModifier.BLOCKING, blocking);
        }
        modifiers.put(EntityDamageEvent.DamageModifier.ARMOR, armorModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.ARMOR, armor);
        modifiers.put(EntityDamageEvent.DamageModifier.RESISTANCE, resistanceModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.RESISTANCE, resistance);
        modifiers.put(EntityDamageEvent.DamageModifier.MAGIC, magicModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.MAGIC, magic);
        modifiers.put(EntityDamageEvent.DamageModifier.ABSORPTION, absorptionModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.ABSORPTION, absorption);
        return CraftEventFactory.handleEntityDamageEvent(damagee, source, modifiers, modifierFunctions);
    }

    public static boolean handleNonLivingEntityDamageEvent(sa entity, ro source, double damage) {
        if (entity instanceof wz && !(source instanceof rp)) {
            return false;
        }
        EnumMap<EntityDamageEvent.DamageModifier, Double> modifiers = new EnumMap<EntityDamageEvent.DamageModifier, Double>(EntityDamageEvent.DamageModifier.class);
        EnumMap<EntityDamageEvent.DamageModifier, Function<? super Double, Double>> functions = new EnumMap<EntityDamageEvent.DamageModifier, Function<? super Double, Double>>(EntityDamageEvent.DamageModifier.class);
        modifiers.put(EntityDamageEvent.DamageModifier.BASE, damage);
        functions.put(EntityDamageEvent.DamageModifier.BASE, ZERO);
        EntityDamageEvent event = CraftEventFactory.handleEntityDamageEvent(entity, source, modifiers, functions);
        if (event == null) {
            return false;
        }
        return event.isCancelled() || event.getDamage() == 0.0 && !(entity instanceof st);
    }

    public static PlayerLevelChangeEvent callPlayerLevelChangeEvent(Player player, int oldLevel, int newLevel) {
        PlayerLevelChangeEvent event = new PlayerLevelChangeEvent(player, oldLevel, newLevel);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static PlayerExpChangeEvent callPlayerExpChangeEvent(yz entity, int expAmount) {
        Player player = (Player)((Object)entity.getBukkitEntity());
        PlayerExpChangeEvent event = new PlayerExpChangeEvent(player, expAmount);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static void handleBlockGrowEvent(ahb world, int x, int y2, int z2, aji type, int data) {
        Block block = world.getWorld().getBlockAt(x, y2, z2);
        CraftBlockState state = (CraftBlockState)block.getState();
        state.setTypeId(aji.b((aji)type));
        state.setRawData((byte)data);
        BlockGrowEvent event = new BlockGrowEvent(block, state);
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            state.update(true);
        }
    }

    public static FoodLevelChangeEvent callFoodLevelChangeEvent(yz entity, int level) {
        FoodLevelChangeEvent event = new FoodLevelChangeEvent(entity.getBukkitEntity(), level);
        entity.getBukkitEntity().getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static PigZapEvent callPigZapEvent(sa pig, sa lightning, sa pigzombie) {
        PigZapEvent event = new PigZapEvent((Pig)((Object)pig.getBukkitEntity()), (LightningStrike)((Object)lightning.getBukkitEntity()), (PigZombie)((Object)pigzombie.getBukkitEntity()));
        pig.getBukkitEntity().getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static HorseJumpEvent callHorseJumpEvent(sa horse, float power) {
        HorseJumpEvent event = new HorseJumpEvent((Horse)((Object)horse.getBukkitEntity()), power);
        horse.getBukkitEntity().getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static EntityChangeBlockEvent callEntityChangeBlockEvent(Entity entity, Block block, Material material) {
        return CraftEventFactory.callEntityChangeBlockEvent(entity, block, material, 0);
    }

    public static EntityChangeBlockEvent callEntityChangeBlockEvent(sa entity, Block block, Material material) {
        return CraftEventFactory.callEntityChangeBlockEvent(entity.getBukkitEntity(), block, material, 0);
    }

    public static EntityChangeBlockEvent callEntityChangeBlockEvent(sa entity, Block block, Material material, boolean cancelled) {
        return CraftEventFactory.callEntityChangeBlockEvent(entity.getBukkitEntity(), block, material, 0, cancelled);
    }

    public static EntityChangeBlockEvent callEntityChangeBlockEvent(sa entity, int x, int y2, int z2, aji type, int data) {
        Block block = entity.o.getWorld().getBlockAt(x, y2, z2);
        Material material = CraftMagicNumbers.getMaterial(type);
        return CraftEventFactory.callEntityChangeBlockEvent(entity.getBukkitEntity(), block, material, data);
    }

    public static EntityChangeBlockEvent callEntityChangeBlockEvent(Entity entity, Block block, Material material, int data) {
        return CraftEventFactory.callEntityChangeBlockEvent(entity, block, material, data, false);
    }

    public static EntityChangeBlockEvent callEntityChangeBlockEvent(Entity entity, Block block, Material material, int data, boolean cancelled) {
        EntityChangeBlockEvent event = new EntityChangeBlockEvent(entity, block, material, (byte)data);
        event.setCancelled(cancelled);
        entity.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static CreeperPowerEvent callCreeperPowerEvent(sa creeper, sa lightning, CreeperPowerEvent.PowerCause cause) {
        CreeperPowerEvent event = new CreeperPowerEvent((Creeper)((Object)creeper.getBukkitEntity()), (LightningStrike)((Object)lightning.getBukkitEntity()), cause);
        creeper.getBukkitEntity().getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static EntityTargetEvent callEntityTargetEvent(sa entity, sa target, EntityTargetEvent.TargetReason reason) {
        EntityTargetEvent event = new EntityTargetEvent(entity.getBukkitEntity(), target == null ? null : target.getBukkitEntity(), reason);
        entity.getBukkitEntity().getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static EntityTargetLivingEntityEvent callEntityTargetLivingEvent(sa entity, sv target, EntityTargetEvent.TargetReason reason) {
        EntityTargetLivingEntityEvent event = new EntityTargetLivingEntityEvent((Entity)entity.getBukkitEntity(), (LivingEntity)((Object)target.getBukkitEntity()), reason);
        entity.getBukkitEntity().getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static EntityBreakDoorEvent callEntityBreakDoorEvent(sa entity, int x, int y2, int z2) {
        CraftEntity entity1 = entity.getBukkitEntity();
        Block block = entity1.getWorld().getBlockAt(x, y2, z2);
        EntityBreakDoorEvent event = new EntityBreakDoorEvent((LivingEntity)((Object)entity1), block);
        entity1.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static zs callInventoryOpenEvent(mw player, zs container) {
        return CraftEventFactory.callInventoryOpenEvent(player, container, true);
    }

    public static zs callInventoryOpenEvent(mw player, zs container, boolean closeInv) {
        if (player.bo != player.bn && closeInv) {
            player.a.a(new iy(player.bo.d));
        }
        CraftServer server = player.o.getServer();
        CraftPlayer craftPlayer = player.getBukkitEntity();
        try {
            player.bo.transferTo(container, (CraftHumanEntity)craftPlayer);
        }
        catch (AbstractMethodError e) {
            // empty catch block
        }
        InventoryOpenEvent event = new InventoryOpenEvent(container.getBukkitView());
        if (container.getBukkitView() != null) {
            server.getPluginManager().callEvent(event);
        }
        if (event.isCancelled()) {
            container.transferTo(player.bo, (CraftHumanEntity)craftPlayer);
            if (!closeInv) {
                player.bo = container;
                player.k();
                player.bo = player.bn;
            }
            return null;
        }
        return container;
    }

    public static add callPreCraftEvent(aae matrix, add result, InventoryView lastCraftView, boolean isRepair) {
        CraftInventoryCrafting inventory = new CraftInventoryCrafting(matrix, matrix.resultInventory);
        inventory.setResult(CraftItemStack.asCraftMirror(result));
        PrepareItemCraftEvent event = new PrepareItemCraftEvent(inventory, lastCraftView, isRepair);
        Bukkit.getPluginManager().callEvent(event);
        ItemStack bitem = event.getInventory().getResult();
        return CraftItemStack.asNMSCopy(bitem);
    }

    public static ProjectileLaunchEvent callProjectileLaunchEvent(sa entity) {
        Projectile bukkitEntity = (Projectile)((Object)entity.getBukkitEntity());
        ProjectileLaunchEvent event = new ProjectileLaunchEvent(bukkitEntity);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static ProjectileHitEvent callProjectileHitEvent(sa entity) {
        ProjectileHitEvent event = new ProjectileHitEvent((Projectile)((Object)entity.getBukkitEntity()));
        entity.o.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static ExpBottleEvent callExpBottleEvent(sa entity, int exp) {
        ThrownExpBottle bottle = (ThrownExpBottle)((Object)entity.getBukkitEntity());
        ExpBottleEvent event = new ExpBottleEvent(bottle, exp);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static BlockRedstoneEvent callRedstoneChange(ahb world, int x, int y2, int z2, int oldCurrent, int newCurrent) {
        BlockRedstoneEvent event = new BlockRedstoneEvent(world.getWorld().getBlockAt(x, y2, z2), oldCurrent, newCurrent);
        world.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static NotePlayEvent callNotePlayEvent(ahb world, int x, int y2, int z2, byte instrument, byte note) {
        NotePlayEvent event = new NotePlayEvent(world.getWorld().getBlockAt(x, y2, z2), Instrument.getByType(instrument), new Note(note));
        world.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static void callPlayerItemBreakEvent(yz human, add brokenItem) {
        CraftItemStack item = CraftItemStack.asCraftMirror(brokenItem);
        PlayerItemBreakEvent event = new PlayerItemBreakEvent((Player)((Object)human.getBukkitEntity()), item);
        Bukkit.getPluginManager().callEvent(event);
    }

    public static BlockIgniteEvent callBlockIgniteEvent(ahb world, int x, int y2, int z2, int igniterX, int igniterY, int igniterZ) {
        BlockIgniteEvent.IgniteCause cause;
        CraftWorld bukkitWorld = world.getWorld();
        Block igniter = bukkitWorld.getBlockAt(igniterX, igniterY, igniterZ);
        switch (igniter.getType()) {
            case LAVA: 
            case STATIONARY_LAVA: {
                cause = BlockIgniteEvent.IgniteCause.LAVA;
                break;
            }
            case DISPENSER: {
                cause = BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL;
                break;
            }
            default: {
                cause = BlockIgniteEvent.IgniteCause.SPREAD;
            }
        }
        BlockIgniteEvent event = new BlockIgniteEvent(bukkitWorld.getBlockAt(x, y2, z2), cause, igniter);
        world.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static BlockIgniteEvent callBlockIgniteEvent(ahb world, int x, int y2, int z2, sa igniter) {
        BlockIgniteEvent.IgniteCause cause;
        CraftWorld bukkitWorld = world.getWorld();
        CraftEntity bukkitIgniter = igniter.getBukkitEntity();
        switch (bukkitIgniter.getType()) {
            case ENDER_CRYSTAL: {
                cause = BlockIgniteEvent.IgniteCause.ENDER_CRYSTAL;
                break;
            }
            case LIGHTNING: {
                cause = BlockIgniteEvent.IgniteCause.LIGHTNING;
                break;
            }
            case SMALL_FIREBALL: 
            case FIREBALL: {
                cause = BlockIgniteEvent.IgniteCause.FIREBALL;
                break;
            }
            default: {
                cause = BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL;
            }
        }
        BlockIgniteEvent event = new BlockIgniteEvent(bukkitWorld.getBlockAt(x, y2, z2), cause, bukkitIgniter);
        world.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static BlockIgniteEvent callBlockIgniteEvent(ahb world, int x, int y2, int z2, agw explosion) {
        CraftWorld bukkitWorld = world.getWorld();
        CraftEntity igniter = explosion.f == null ? null : explosion.f.getBukkitEntity();
        BlockIgniteEvent event = new BlockIgniteEvent(bukkitWorld.getBlockAt(x, y2, z2), BlockIgniteEvent.IgniteCause.EXPLOSION, igniter);
        world.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static BlockIgniteEvent callBlockIgniteEvent(ahb world, int x, int y2, int z2, BlockIgniteEvent.IgniteCause cause, sa igniter) {
        BlockIgniteEvent event = new BlockIgniteEvent(world.getWorld().getBlockAt(x, y2, z2), cause, igniter.getBukkitEntity());
        world.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static void handleInventoryCloseEvent(yz human) {
        InventoryCloseEvent event = new InventoryCloseEvent(human.bo.getBukkitView());
        if (human.bo.getBukkitView() != null) {
            human.o.getServer().getPluginManager().callEvent(event);
        }
        human.bo.transferTo(human.bn, human.getBukkitEntity());
    }

    public static void handleEditBookEvent(mw player, add newBookItem) {
        int itemInHandIndex = player.bm.c;
        PlayerEditBookEvent editBookEvent = new PlayerEditBookEvent(player.getBukkitEntity(), player.bm.c, (BookMeta)CraftItemStack.getItemMeta(player.bm.h()), (BookMeta)CraftItemStack.getItemMeta(newBookItem), newBookItem.b() == ade.bB);
        player.o.getServer().getPluginManager().callEvent(editBookEvent);
        add itemInHand = player.bm.a(itemInHandIndex);
        if (itemInHand != null && itemInHand.b() == ade.bA) {
            if (!editBookEvent.isCancelled()) {
                CraftItemStack.setItemMeta(itemInHand, editBookEvent.getNewBookMeta());
                if (editBookEvent.isSigning()) {
                    itemInHand.a(ade.bB);
                }
            }
            aay slot = player.bo.a((rb)player.bm, itemInHandIndex);
            player.a.a((ft)new gq(player.bo.d, slot.g, itemInHand));
        }
    }

    public static PlayerUnleashEntityEvent callPlayerUnleashEntityEvent(sw entity, yz player) {
        PlayerUnleashEntityEvent event = new PlayerUnleashEntityEvent((Entity)entity.getBukkitEntity(), (Player)((Object)player.getBukkitEntity()));
        entity.o.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static PlayerLeashEntityEvent callPlayerLeashEntityEvent(sw entity, sa leashHolder, yz player) {
        PlayerLeashEntityEvent event = new PlayerLeashEntityEvent(entity.getBukkitEntity(), leashHolder.getBukkitEntity(), (Player)((Object)player.getBukkitEntity()));
        entity.o.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static Cancellable handleStatisticsIncrease(yz entityHuman, ph statistic, int current, int incrementation) {
        PlayerEvent event;
        CraftPlayer player = ((mw)entityHuman).getBukkitEntity();
        if (statistic instanceof pb) {
            if (current != 0) {
                return null;
            }
            event = new PlayerAchievementAwardedEvent((Player)player, CraftStatistic.getBukkitAchievement((pb)statistic));
        } else {
            Statistic stat = CraftStatistic.getBukkitStatistic(statistic);
            if (stat == null) {
                return null;
            }
            switch (stat) {
                case FALL_ONE_CM: 
                case BOAT_ONE_CM: 
                case CLIMB_ONE_CM: 
                case DIVE_ONE_CM: 
                case FLY_ONE_CM: 
                case HORSE_ONE_CM: 
                case MINECART_ONE_CM: 
                case PIG_ONE_CM: 
                case PLAY_ONE_TICK: 
                case SWIM_ONE_CM: 
                case WALK_ONE_CM: {
                    return null;
                }
            }
            if (stat.getType() == Statistic.Type.UNTYPED) {
                event = new PlayerStatisticIncrementEvent(player, stat, current, current + incrementation);
            } else if (stat.getType() == Statistic.Type.ENTITY) {
                EntityType entityType = CraftStatistic.getEntityTypeFromStatistic(statistic);
                event = new PlayerStatisticIncrementEvent((Player)player, stat, current, current + incrementation, entityType);
            } else {
                Material material = CraftStatistic.getMaterialFromStatistic(statistic);
                event = new PlayerStatisticIncrementEvent((Player)player, stat, current, current + incrementation, material);
            }
        }
        entityHuman.o.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static BlockBreakEvent callBlockBreakEvent(ahb world, int x, int y2, int z2, aji block, int blockMetadata, mw player) {
        Block bukkitBlock = world.getWorld().getBlockAt(x, y2, z2);
        BlockBreakEvent blockBreakEvent = new BlockBreakEvent(bukkitBlock, player.getBukkitEntity());
        mw playermp = player;
        if (!(playermp instanceof FakePlayer)) {
            if (!(playermp.c.b().c() && !playermp.d(x, y2, z2) || playermp.c.b().d() && playermp.be() != null && playermp.be().b() instanceof aeh)) {
                int exp = 0;
                if (!(block == null || !player.a(block) || block.canSilkHarvest(world, (yz)player, x, y2, z2, blockMetadata) && afv.e((sv)player))) {
                    int meta = block.k(world, x, y2, z2);
                    int bonusLevel = afv.f((sv)player);
                    exp = block.getExpDrop((ahl)world, meta, bonusLevel);
                }
                blockBreakEvent.setExpToDrop(exp);
            } else {
                blockBreakEvent.setCancelled(true);
            }
        }
        world.getServer().getPluginManager().callEvent(blockBreakEvent);
        return blockBreakEvent;
    }

    static {
        ZERO = Functions.constant((Object)-0.0);
    }
}

