/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R4.entity;

import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.bukkit.craftbukkit.v1_7_R4.CraftServer;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftInventoryHorse;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.HorseInventory;

public class CraftHorse
extends CraftAnimals
implements Horse {
    public CraftHorse(CraftServer server, wi entity) {
        super(server, (wf)entity);
    }

    public wi getHandle() {
        return (wi)this.entity;
    }

    @Override
    public Horse.Variant getVariant() {
        return Horse.Variant.values()[this.getHandle().bZ()];
    }

    @Override
    public void setVariant(Horse.Variant variant) {
        Validate.notNull((Object)((Object)variant), (String)"Variant cannot be null");
        this.getHandle().s(variant.ordinal());
    }

    @Override
    public Horse.Color getColor() {
        return Horse.Color.values()[this.getHandle().ca() & 0xFF];
    }

    @Override
    public void setColor(Horse.Color color) {
        Validate.notNull((Object)((Object)color), (String)"Color cannot be null");
        this.getHandle().t(color.ordinal() & 0xFF | this.getStyle().ordinal() << 8);
    }

    @Override
    public Horse.Style getStyle() {
        return Horse.Style.values()[this.getHandle().ca() >>> 8];
    }

    @Override
    public void setStyle(Horse.Style style) {
        Validate.notNull((Object)((Object)style), (String)"Style cannot be null");
        this.getHandle().t(this.getColor().ordinal() & 0xFF | style.ordinal() << 8);
    }

    @Override
    public boolean isCarryingChest() {
        return this.getHandle().ck();
    }

    @Override
    public void setCarryingChest(boolean chest) {
        if (chest == this.isCarryingChest()) {
            return;
        }
        this.getHandle().l(chest);
        this.getHandle().cN();
    }

    @Override
    public int getDomestication() {
        return this.getHandle().cq();
    }

    @Override
    public void setDomestication(int value) {
        Validate.isTrue((value >= 0 ? 1 : 0) != 0, (String)"Domestication cannot be less than zero");
        Validate.isTrue((value <= this.getMaxDomestication() ? 1 : 0) != 0, (String)"Domestication cannot be greater than the max domestication");
        this.getHandle().u(value);
    }

    @Override
    public int getMaxDomestication() {
        return this.getHandle().cw();
    }

    @Override
    public void setMaxDomestication(int value) {
        Validate.isTrue((value > 0 ? 1 : 0) != 0, (String)"Max domestication cannot be zero or less");
        this.getHandle().maxDomestication = value;
    }

    @Override
    public double getJumpStrength() {
        return this.getHandle().ct();
    }

    @Override
    public void setJumpStrength(double strength) {
        Validate.isTrue((strength >= 0.0 ? 1 : 0) != 0, (String)"Jump strength cannot be less than zero");
        this.getHandle().a(wi.bv).a(strength);
    }

    @Override
    public boolean isTamed() {
        return this.getHandle().cc();
    }

    @Override
    public void setTamed(boolean tamed) {
        this.getHandle().i(tamed);
    }

    @Override
    public AnimalTamer getOwner() {
        if (this.getOwnerUUID() == null) {
            return null;
        }
        return this.getServer().getOfflinePlayer(this.getOwnerUUID());
    }

    @Override
    public void setOwner(AnimalTamer owner) {
        if (owner != null) {
            this.setTamed(true);
            this.getHandle().a(null);
            this.setOwnerUUID(owner.getUniqueId());
        } else {
            this.setTamed(false);
            this.setOwnerUUID(null);
        }
    }

    public UUID getOwnerUUID() {
        try {
            return UUID.fromString(this.getHandle().ch());
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public void setOwnerUUID(UUID uuid) {
        if (uuid == null) {
            this.getHandle().b("");
        } else {
            this.getHandle().b(uuid.toString());
        }
    }

    @Override
    public HorseInventory getInventory() {
        return new CraftInventoryHorse((rb)this.getHandle().bG);
    }

    @Override
    public String toString() {
        return "CraftHorse{variant=" + (Object)((Object)this.getVariant()) + ", owner=" + this.getOwner() + '}';
    }

    @Override
    public EntityType getType() {
        return EntityType.HORSE;
    }
}

