/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.eventhandler.Event;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.cauldron.command.CauldronCommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.FuelBurnTimeEvent;
import net.minecraftforge.event.brewing.PotionBrewEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingPackSizeEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.bukkit.craftbukkit.v1_7_R4.event.CraftEventFactory;
import org.bukkit.event.block.Action;

public class ForgeEventFactory {
    public static BlockEvent.MultiPlaceEvent onPlayerMultiBlockPlace(yz player, List<BlockSnapshot> blockSnapshots, ForgeDirection direction) {
        aji placedAgainst = blockSnapshots.get((int)0).world.a(blockSnapshots.get((int)0).x + direction.getOpposite().offsetX, blockSnapshots.get((int)0).y + direction.getOpposite().offsetY, blockSnapshots.get((int)0).z + direction.getOpposite().offsetZ);
        BlockEvent.MultiPlaceEvent event = new BlockEvent.MultiPlaceEvent(blockSnapshots, placedAgainst, player);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static BlockEvent.PlaceEvent onPlayerBlockPlace(yz player, BlockSnapshot blockSnapshot, ForgeDirection direction) {
        aji placedAgainst = blockSnapshot.world.a(blockSnapshot.x + direction.getOpposite().offsetX, blockSnapshot.y + direction.getOpposite().offsetY, blockSnapshot.z + direction.getOpposite().offsetZ);
        BlockEvent.PlaceEvent event = new BlockEvent.PlaceEvent(blockSnapshot, placedAgainst, player);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static boolean isSpawn(yz ep) {
        MinecraftServer.I();
        return MinecraftServer.cauldronConfig.protectSP.getValue() != false && ep.o.x.k().toLowerCase().contains("spawn");
    }

    public static boolean doPlayerHarvestCheck(yz player, aji block, boolean success) {
        if (ForgeEventFactory.isSpawn(player) && ForgeEventFactory.nonVanilla(player)) {
            if (CauldronCommand.debug) {
                System.out.println("Told player no harvest");
            }
            return false;
        }
        PlayerEvent.HarvestCheck event = new PlayerEvent.HarvestCheck(player, block, success);
        MinecraftForge.EVENT_BUS.post(event);
        return event.success;
    }

    @Deprecated
    public static float getBreakSpeed(yz player, aji block, int metadata, float original) {
        if (ForgeEventFactory.isSpawn(player) && ForgeEventFactory.nonVanilla(player)) {
            if (CauldronCommand.debug) {
                System.out.println("Told user breakspeed = 0");
            }
            return 0.0f;
        }
        return ForgeEventFactory.getBreakSpeed(player, block, metadata, original, 0, -1, 0);
    }

    public static float getBreakSpeed(yz player, aji block, int metadata, float original, int x, int y2, int z2) {
        if (ForgeEventFactory.isSpawn(player) && ForgeEventFactory.nonVanilla(player)) {
            if (CauldronCommand.debug) {
                System.out.println("Told user breakspeed = 0");
            }
            return 0.0f;
        }
        PlayerEvent.BreakSpeed event = new PlayerEvent.BreakSpeed(player, block, metadata, original, x, y2, z2);
        return MinecraftForge.EVENT_BUS.post(event) ? -1.0f : event.newSpeed;
    }

    private static boolean outsideOfVanillaRange(int id) {
        if (CauldronCommand.debug) {
            System.out.println("Testing item ID " + id);
        }
        return !(id <= 197 || id >= 256 && id <= 431 || id >= 2256 && id <= 2267 || id == 628 || id == 5374 || id == 4568 || id == 4354 || id == 4355 || id == 4356 || id >= 4324 && id <= 4329 || id == 4338 || id == 4688 || id == 4916 || id <= 4987 && id >= 4980 || id == 5386 || id == 753 || id == 5497 || id == 4096 || id == 550 || id == 4791 || id == 4790 || id == 564 || id == 562 || id == 555 || id == 4787 || id == 569 || id == 572 || id == 4749 || id == 4984 || id == 4568 || id == 220 || id >= 4548 && id <= 4561 || id >= 5360 && id <= 5365);
    }

    public static boolean isOp(yz ep) {
        return MinecraftServer.I().ah().g(ep.bJ());
    }

    public static boolean nonVanilla(yz ep) {
        if (ep == null) {
            if (CauldronCommand.debug) {
                System.out.println("EntityPlayer is null");
            }
            return false;
        }
        if (ForgeEventFactory.isOp(ep)) {
            return false;
        }
        if (ep.be() == null) {
            if (CauldronCommand.debug) {
                System.out.println("Held item is null");
            }
            return false;
        }
        if (ep.be().b() == null) {
            if (CauldronCommand.debug) {
                System.out.println("Item getItem() is null");
            }
            return false;
        }
        if (ForgeEventFactory.outsideOfVanillaRange(adb.b((adb)ep.be().b()))) {
            if (ep instanceof mw) {
                mw mp2 = (mw)ep;
                mp2.b((fj)new fq("You cannot use that item here."));
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public static PlayerInteractEvent onPlayerInteract(yz player, PlayerInteractEvent.Action action, int x, int y2, int z2, int face) {
        if (player == null) {
            return ForgeEventFactory.onPlayerBukkitInteract(player, action, x, y2, z2, face, null);
        }
        Action aktor = null;
        switch (action) {
            case RIGHT_CLICK_AIR: {
                aktor = Action.RIGHT_CLICK_AIR;
                break;
            }
            case RIGHT_CLICK_BLOCK: {
                aktor = Action.RIGHT_CLICK_BLOCK;
                break;
            }
            case LEFT_CLICK_BLOCK: {
                aktor = Action.LEFT_CLICK_BLOCK;
            }
            default: {
                aktor = Action.LEFT_CLICK_AIR;
            }
        }
        return ForgeEventFactory.onPlayerBukkitInteract(player, action, x, y2, z2, face, CraftEventFactory.callPlayerInteractEvent(player, aktor, x, y2, z2, face, player.bm.h()));
    }

    @Deprecated
    public static PlayerInteractEvent onPlayerBukkitInteract(yz player, PlayerInteractEvent.Action action, int x, int y2, int z2, int face, org.bukkit.event.player.PlayerInteractEvent eve) {
        PlayerInteractEvent event = new PlayerInteractEvent(player, action, x, y2, z2, face, null);
        if (eve != null && player != null && !ForgeEventFactory.isOp(player) && !ForgeEventFactory.isCoFHFakePlayer(player, x, y2, z2, face)) {
            event.cb = eve;
            if (eve.isCancelled()) {
                event.setCanceled(true);
                return event;
            }
        }
        if (ForgeEventFactory.isSpawn(player) && ForgeEventFactory.nonVanilla(player)) {
            event.setCanceled(true);
            if (CauldronCommand.debug) {
                System.out.println("Canceled onPlayerInteract()");
            }
        } else {
            MinecraftForge.EVENT_BUS.post(event);
        }
        return event;
    }

    public static PlayerInteractEvent onPlayerInteract(yz player, PlayerInteractEvent.Action action, int x, int y2, int z2, int face, ahb world) {
        if (player == null || ForgeEventFactory.isOp(player) || ForgeEventFactory.isCoFHFakePlayer(player, x, y2, z2, face)) {
            if (CauldronCommand.debug) {
                System.out.println("[Thermos] CoFH Fake Player / Null player detected...refusing to create Bukkit event");
            }
            ForgeEventFactory.onPlayerBukkitInteract(player, action, x, y2, z2, face, world, null);
        } else if (CauldronCommand.debug) {
            System.out.println("[Thermos] Creating & calling bukkit event!");
        }
        Action aktor = null;
        switch (action) {
            case RIGHT_CLICK_AIR: {
                aktor = Action.RIGHT_CLICK_AIR;
                break;
            }
            case RIGHT_CLICK_BLOCK: {
                aktor = Action.RIGHT_CLICK_BLOCK;
                break;
            }
            case LEFT_CLICK_BLOCK: {
                aktor = Action.LEFT_CLICK_BLOCK;
            }
            default: {
                aktor = Action.LEFT_CLICK_AIR;
            }
        }
        return ForgeEventFactory.onPlayerBukkitInteract(player, action, x, y2, z2, face, world, CraftEventFactory.callPlayerInteractEvent(player, aktor, x, y2, z2, face, player.bm.h()));
    }

    private static boolean isCoFHFakePlayer(yz player, int x, int y2, int z2, int face) {
        if (CauldronCommand.debug) {
            System.out.println("[Thermos] Checking if it is a CoFH Fake Player...");
        }
        return player instanceof FakePlayer && player.bJ().getName().equals("[CoFH]");
    }

    public static PlayerInteractEvent onPlayerBukkitInteract(yz player, PlayerInteractEvent.Action action, int x, int y2, int z2, int face, ahb world, org.bukkit.event.player.PlayerInteractEvent eve) {
        PlayerInteractEvent event = new PlayerInteractEvent(player, action, x, y2, z2, face, world);
        if (eve != null && player != null && !ForgeEventFactory.isOp(player) && !ForgeEventFactory.isCoFHFakePlayer(player, x, y2, z2, face)) {
            if (CauldronCommand.debug) {
                System.out.println("[Thermos] Using Bukkit Event for this action...");
            }
            event.cb = eve;
            if (eve.isCancelled()) {
                event.setCanceled(true);
                return event;
            }
        } else if (eve == null) {
            if (CauldronCommand.debug) {
                System.out.println("[Thermos] Refusing to call Bukkit event for that interaction");
            }
        } else if (CauldronCommand.debug) {
            System.out.println("[Thermos] Bukkit event was never considered...single tear");
        }
        if (ForgeEventFactory.isSpawn(player) && ForgeEventFactory.nonVanilla(player)) {
            event.setCanceled(true);
            if (CauldronCommand.debug) {
                System.out.println("Canceled onPlayerInteract()");
            }
        } else {
            MinecraftForge.EVENT_BUS.post(event);
        }
        return event;
    }

    public static void onPlayerDestroyItem(yz player, add stack) {
        MinecraftForge.EVENT_BUS.post(new PlayerDestroyItemEvent(player, stack));
    }

    public static Event.Result canEntitySpawn(sw entity, ahb world, float x, float y2, float z2) {
        LivingSpawnEvent.CheckSpawn event = new LivingSpawnEvent.CheckSpawn(entity, world, x, y2, z2);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResult();
    }

    public static boolean doSpecialSpawn(sw entity, ahb world, float x, float y2, float z2) {
        return MinecraftForge.EVENT_BUS.post(new LivingSpawnEvent.SpecialSpawn(entity, world, x, y2, z2));
    }

    public static Event.Result canEntityDespawn(sw entity) {
        LivingSpawnEvent.AllowDespawn event = new LivingSpawnEvent.AllowDespawn(entity);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResult();
    }

    public static List<ahx> getPotentialSpawns(mt world, sx type, int x, int y2, int z2, List<ahx> oldList) {
        WorldEvent.PotentialSpawns event = new WorldEvent.PotentialSpawns((ahb)world, type, x, y2, z2, oldList);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        return event.list;
    }

    public static int getFuelBurnTime(add fuel) {
        FuelBurnTimeEvent event = new FuelBurnTimeEvent(fuel);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResult() == Event.Result.DEFAULT ? -1 : event.burnTime;
    }

    public static int getMaxSpawnPackSize(sw entity) {
        LivingPackSizeEvent maxCanSpawnEvent = new LivingPackSizeEvent(entity);
        MinecraftForge.EVENT_BUS.post(maxCanSpawnEvent);
        return maxCanSpawnEvent.getResult() == Event.Result.ALLOW ? maxCanSpawnEvent.maxPackSize : entity.bB();
    }

    public static String getPlayerDisplayName(yz player, String username) {
        PlayerEvent.NameFormat event = new PlayerEvent.NameFormat(player, username);
        MinecraftForge.EVENT_BUS.post(event);
        return event.displayname;
    }

    public static float fireBlockHarvesting(ArrayList<add> drops, ahb world, aji block, int x, int y2, int z2, int meta, int fortune, float dropChance, boolean silkTouch, yz player) {
        BlockEvent.HarvestDropsEvent event = new BlockEvent.HarvestDropsEvent(x, y2, z2, world, block, meta, fortune, dropChance, drops, player, silkTouch);
        MinecraftForge.EVENT_BUS.post(event);
        return event.dropChance;
    }

    public static ItemTooltipEvent onItemTooltip(add itemStack, yz entityPlayer, List<String> toolTip, boolean showAdvancedItemTooltips) {
        ItemTooltipEvent event = new ItemTooltipEvent(itemStack, entityPlayer, toolTip, showAdvancedItemTooltips);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static ZombieEvent.SummonAidEvent fireZombieSummonAid(yq zombie, ahb world, int x, int y2, int z2, sv attacker, double summonChance) {
        ZombieEvent.SummonAidEvent summonEvent = new ZombieEvent.SummonAidEvent(zombie, world, x, y2, z2, attacker, summonChance);
        MinecraftForge.EVENT_BUS.post(summonEvent);
        return summonEvent;
    }

    public static boolean onEntityStruckByLightning(sa entity, xh bolt) {
        return MinecraftForge.EVENT_BUS.post(new EntityStruckByLightningEvent(entity, bolt));
    }

    public static int onItemUseStart(yz player, add item, int duration) {
        PlayerUseItemEvent.Start event;
        if (ForgeEventFactory.isSpawn(player) && ForgeEventFactory.nonVanilla(player)) {
            event = new PlayerUseItemEvent.Start(player, null, duration);
            if (CauldronCommand.debug) {
                System.out.println("Canceled onItemuseStart()");
            }
        } else {
            event = new PlayerUseItemEvent.Start(player, item, duration);
        }
        return MinecraftForge.EVENT_BUS.post(event) ? -1 : event.duration;
    }

    public static int onItemUseTick(yz player, add item, int duration) {
        PlayerUseItemEvent.Tick event;
        if (ForgeEventFactory.isSpawn(player) && ForgeEventFactory.nonVanilla(player)) {
            event = new PlayerUseItemEvent.Tick(player, null, duration);
            if (CauldronCommand.debug) {
                System.out.println("Canceled onItemuseTick()");
            }
        } else {
            event = new PlayerUseItemEvent.Tick(player, item, duration);
        }
        return MinecraftForge.EVENT_BUS.post(event) ? -1 : event.duration;
    }

    public static boolean onUseItemStop(yz player, add item, int duration) {
        PlayerUseItemEvent.Start event;
        if (ForgeEventFactory.isSpawn(player) && ForgeEventFactory.nonVanilla(player)) {
            event = new PlayerUseItemEvent.Start(player, null, duration);
            if (CauldronCommand.debug) {
                System.out.println("Canceled onItemuseStop()");
            }
        } else {
            event = new PlayerUseItemEvent.Start(player, item, duration);
        }
        return MinecraftForge.EVENT_BUS.post(event);
    }

    public static add onItemUseFinish(yz player, add item, int duration, add result) {
        PlayerUseItemEvent.Finish event;
        if (ForgeEventFactory.isSpawn(player) && ForgeEventFactory.nonVanilla(player)) {
            event = new PlayerUseItemEvent.Finish(player, null, duration, null);
            if (CauldronCommand.debug) {
                System.out.println("Canceled onItemuseFinish()");
            }
        } else {
            event = new PlayerUseItemEvent.Finish(player, item, duration, result);
        }
        MinecraftForge.EVENT_BUS.post(event);
        return event.result;
    }

    public static void onStartEntityTracking(sa entity, yz player) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.StartTracking(player, entity));
    }

    public static void onStopEntityTracking(sa entity, yz player) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.StopTracking(player, entity));
    }

    public static void firePlayerLoadingEvent(yz player, File playerDirectory, String uuidString) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.LoadFromFile(player, playerDirectory, uuidString));
    }

    public static void firePlayerSavingEvent(yz player, File playerDirectory, String uuidString) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.SaveToFile(player, playerDirectory, uuidString));
    }

    public static void firePlayerLoadingEvent(yz player, azp playerFileData, String uuidString) {
        ayq sh = (ayq)playerFileData;
        File dir = (File)ObfuscationReflectionHelper.getPrivateValue(ayq.class, sh, "playersDirectory", "field_75771_c");
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.LoadFromFile(player, dir, uuidString));
    }

    public static boolean onExplosionStart(ahb world, agw explosion) {
        return MinecraftForge.EVENT_BUS.post(new ExplosionEvent.Start(world, explosion));
    }

    public static void onExplosionDetonate(ahb world, agw explosion, List<sa> list, double diameter) {
        MinecraftForge.EVENT_BUS.post(new ExplosionEvent.Detonate(world, explosion, list));
    }

    public static boolean onCreateWorldSpawn(ahb world, ahj settings) {
        return MinecraftForge.EVENT_BUS.post(new WorldEvent.CreateSpawnPosition(world, settings));
    }

    public static float onLivingHeal(sv entity, float amount) {
        LivingHealEvent event = new LivingHealEvent(entity, amount);
        return MinecraftForge.EVENT_BUS.post(event) ? 0.0f : event.amount;
    }

    public static boolean onPotionAttemptBreaw(add[] stacks) {
        add[] tmp = new add[stacks.length];
        for (int x = 0; x < tmp.length; ++x) {
            tmp[x] = add.b((add)stacks[x]);
        }
        PotionBrewEvent.Pre event = new PotionBrewEvent.Pre(tmp);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            boolean changed = false;
            for (int x = 0; x < stacks.length; ++x) {
                changed |= add.b((add)tmp[x], (add)stacks[x]);
                stacks[x] = event.getItem(x);
            }
            if (changed) {
                ForgeEventFactory.onPotionBrewed(stacks);
            }
            return true;
        }
        return false;
    }

    public static void onPotionBrewed(add[] brewingItemStacks) {
        MinecraftForge.EVENT_BUS.post(new PotionBrewEvent.Post(brewingItemStacks));
    }
}

