/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.network;

import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.channel.ChannelHandler;
import java.util.EnumMap;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.network.DimensionMessageHandler;
import net.minecraftforge.common.network.FluidIdRegistryMessageHandler;
import net.minecraftforge.common.network.ForgeRuntimeCodec;
import net.minecraftforge.common.network.ServerToClientConnectionEstablishedHandler;

public class ForgeNetworkHandler {
    private static EnumMap<Side, FMLEmbeddedChannel> channelPair;

    public static void registerChannel(ForgeModContainer forgeModContainer, Side side) {
        channelPair = NetworkRegistry.INSTANCE.newChannel(forgeModContainer, "FORGE", new ChannelHandler[]{new ForgeRuntimeCodec()});
        if (side == Side.CLIENT) {
            ForgeNetworkHandler.addClientHandlers();
        }
        FMLEmbeddedChannel serverChannel = channelPair.get((Object)Side.SERVER);
        serverChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.NOWHERE);
        String handlerName = serverChannel.findChannelHandlerNameForType(ForgeRuntimeCodec.class);
        serverChannel.pipeline().addAfter(handlerName, "ServerToClientConnection", (ChannelHandler)new ServerToClientConnectionEstablishedHandler());
    }

    @SideOnly(value=Side.CLIENT)
    private static void addClientHandlers() {
        FMLEmbeddedChannel clientChannel = channelPair.get((Object)Side.CLIENT);
        String handlerName = clientChannel.findChannelHandlerNameForType(ForgeRuntimeCodec.class);
        clientChannel.pipeline().addAfter(handlerName, "DimensionHandler", (ChannelHandler)new DimensionMessageHandler());
        clientChannel.pipeline().addAfter(handlerName, "FluidIdRegistryHandler", (ChannelHandler)new FluidIdRegistryMessageHandler());
    }

    public static FMLEmbeddedChannel getServerChannel() {
        return channelPair.get((Object)Side.SERVER);
    }
}

