/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.cauldron.apiimpl;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraftforge.cauldron.api.Fishing;
import net.minecraftforge.cauldron.api.WeightedRandomFishable;
import net.minecraftforge.common.FishingHooks;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public class FishingInterface
implements Fishing {
    private static xf toNms(WeightedRandomFishable bukkit) {
        xf ret = new xf(CraftItemStack.asNMSCopy(bukkit.getItemStack()), bukkit.getWeight()).a(bukkit.getDamageFraction());
        if (bukkit.hasRandomEnchantments()) {
            ret.a();
        }
        return ret;
    }

    private static WeightedRandomFishable toBukkit(xf nms) {
        return new WeightedRandomFishable(CraftItemStack.asBukkitCopy(nms.b), nms.a).withDamageFraction(nms.c).withRandomEnchantments(nms.d);
    }

    private static PredicateProxy toNms(Predicate<WeightedRandomFishable> predicate) {
        return new PredicateProxy(predicate);
    }

    @Override
    public void addFish(WeightedRandomFishable fish) {
        FishingHooks.addFish(FishingInterface.toNms(fish));
    }

    @Override
    public void addJunk(WeightedRandomFishable fish) {
        FishingHooks.addJunk(FishingInterface.toNms(fish));
    }

    @Override
    public void addTreasure(WeightedRandomFishable fish) {
        FishingHooks.addTreasure(FishingInterface.toNms(fish));
    }

    @Override
    public void removeMatchingFish(Predicate<WeightedRandomFishable> test) {
        FishingHooks.removeFish(FishingInterface.toNms(test));
    }

    @Override
    public void removeMatchingJunk(Predicate<WeightedRandomFishable> test) {
        FishingHooks.removeJunk(FishingInterface.toNms(test));
    }

    @Override
    public void removeMatchingTreasure(Predicate<WeightedRandomFishable> test) {
        FishingHooks.removeTreasure(FishingInterface.toNms(test));
    }

    @Override
    public ItemStack getRandomFishable(Random rand, float baseChance, int fishingLuckEnchantmentLevel, int fishingSpeedEnchantmentLevel) {
        return CraftItemStack.asCraftMirror(FishingHooks.getRandomFishable(rand, baseChance, fishingLuckEnchantmentLevel, fishingSpeedEnchantmentLevel));
    }

    private static class PredicateProxy
    implements Predicate<xf> {
        private Predicate<WeightedRandomFishable> bukkitPredicate;

        public PredicateProxy(Predicate<WeightedRandomFishable> predicate) {
            this.bukkitPredicate = predicate;
        }

        public boolean apply(xf input) {
            return this.bukkitPredicate.apply((Object)FishingInterface.toBukkit(input));
        }
    }
}

