/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.asm.transformers;

import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EventSubscriptionTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null || name.equals("cpw.mods.fml.common.eventhandler.Event") || name.startsWith("net.minecraft.") || name.indexOf(46) == -1) {
            return bytes;
        }
        ClassReader cr = new ClassReader(bytes);
        ClassNode classNode = new ClassNode();
        cr.accept((ClassVisitor)classNode, 0);
        try {
            if (this.buildEvents(classNode)) {
                ClassWriter cw2 = new ClassWriter(2);
                classNode.accept((ClassVisitor)cw2);
                return cw2.toByteArray();
            }
            return bytes;
        }
        catch (ClassNotFoundException ex) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bytes;
    }

    private boolean buildEvents(ClassNode classNode) throws Exception {
        MethodNode method2;
        Class<?> parent = this.getClass().getClassLoader().loadClass(classNode.superName.replace('/', '.'));
        if (!Event.class.isAssignableFrom(parent)) {
            return false;
        }
        Type tList = Type.getType((String)"Lcpw/mods/fml/common/eventhandler/ListenerList;");
        boolean edited = false;
        boolean hasSetup = false;
        boolean hasGetListenerList = false;
        boolean hasDefaultCtr = false;
        boolean hasCancelable = false;
        boolean hasResult = false;
        String voidDesc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]);
        String boolDesc = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0]);
        String listDesc = tList.getDescriptor();
        String listDescM = Type.getMethodDescriptor((Type)tList, (Type[])new Type[0]);
        for (MethodNode method2 : classNode.methods) {
            if (method2.name.equals("setup") && method2.desc.equals(voidDesc) && (method2.access & 4) == 4) {
                hasSetup = true;
            }
            if ((method2.access & 1) == 1) {
                if (method2.name.equals("getListenerList") && method2.desc.equals(listDescM)) {
                    hasGetListenerList = true;
                }
                if (method2.name.equals("isCancelable") && method2.desc.equals(boolDesc)) {
                    hasCancelable = true;
                }
                if (method2.name.equals("hasResult") && method2.desc.equals(boolDesc)) {
                    hasResult = true;
                }
            }
            if (!method2.name.equals("<init>") || !method2.desc.equals(voidDesc)) continue;
            hasDefaultCtr = true;
        }
        if (classNode.visibleAnnotations != null) {
            for (AnnotationNode node : classNode.visibleAnnotations) {
                MethodNode method3;
                if (!hasResult && node.desc.equals("Lcpw/mods/fml/common/eventhandler/Event$HasResult;")) {
                    method3 = new MethodNode(1, "hasResult", boolDesc, null, null);
                    method3.instructions.add((AbstractInsnNode)new InsnNode(4));
                    method3.instructions.add((AbstractInsnNode)new InsnNode(172));
                    classNode.methods.add(method3);
                    edited = true;
                    continue;
                }
                if (hasCancelable || !node.desc.equals("Lcpw/mods/fml/common/eventhandler/Cancelable;")) continue;
                method3 = new MethodNode(1, "isCancelable", boolDesc, null, null);
                method3.instructions.add((AbstractInsnNode)new InsnNode(4));
                method3.instructions.add((AbstractInsnNode)new InsnNode(172));
                classNode.methods.add(method3);
                edited = true;
            }
        }
        if (hasSetup) {
            if (!hasGetListenerList) {
                throw new RuntimeException("Event class defines setup() but does not define getListenerList! " + classNode.name);
            }
            return edited;
        }
        Type tSuper = Type.getType((String)classNode.superName);
        classNode.fields.add(new FieldNode(10, "LISTENER_LIST", listDesc, null, null));
        if (!hasDefaultCtr) {
            method2 = new MethodNode(1, "<init>", voidDesc, null, null);
            method2.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method2.instructions.add((AbstractInsnNode)new MethodInsnNode(183, tSuper.getInternalName(), "<init>", voidDesc, false));
            method2.instructions.add((AbstractInsnNode)new InsnNode(177));
            classNode.methods.add(method2);
        }
        method2 = new MethodNode(4, "setup", voidDesc, null, null);
        method2.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        method2.instructions.add((AbstractInsnNode)new MethodInsnNode(183, tSuper.getInternalName(), "setup", voidDesc, false));
        method2.instructions.add((AbstractInsnNode)new FieldInsnNode(178, classNode.name, "LISTENER_LIST", listDesc));
        LabelNode initLisitener = new LabelNode();
        method2.instructions.add((AbstractInsnNode)new JumpInsnNode(198, initLisitener));
        method2.instructions.add((AbstractInsnNode)new InsnNode(177));
        method2.instructions.add((AbstractInsnNode)initLisitener);
        method2.instructions.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        method2.instructions.add((AbstractInsnNode)new TypeInsnNode(187, tList.getInternalName()));
        method2.instructions.add((AbstractInsnNode)new InsnNode(89));
        method2.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        method2.instructions.add((AbstractInsnNode)new MethodInsnNode(183, tSuper.getInternalName(), "getListenerList", listDescM, false));
        method2.instructions.add((AbstractInsnNode)new MethodInsnNode(183, tList.getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{tList}), false));
        method2.instructions.add((AbstractInsnNode)new FieldInsnNode(179, classNode.name, "LISTENER_LIST", listDesc));
        method2.instructions.add((AbstractInsnNode)new InsnNode(177));
        classNode.methods.add(method2);
        method2 = new MethodNode(1, "getListenerList", listDescM, null, null);
        method2.instructions.add((AbstractInsnNode)new FieldInsnNode(178, classNode.name, "LISTENER_LIST", listDesc));
        method2.instructions.add((AbstractInsnNode)new InsnNode(176));
        classNode.methods.add(method2);
        return true;
    }
}

