/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.math.IntMath;
import com.google.common.math.LongMath;
import com.google.common.math.MathPreconditions;
import java.math.RoundingMode;

/*
 * Exception performing whole class analysis ignored.
 */
@GwtCompatible(emulated=true)
public final class LongMath {
    @VisibleForTesting
    static final long MAX_POWER_OF_SQRT2_UNSIGNED = -5402926248376769404L;
    @VisibleForTesting
    static final byte[] maxLog10ForLeadingZeros = new byte[]{19, 18, 18, 18, 18, 17, 17, 17, 16, 16, 16, 15, 15, 15, 15, 14, 14, 14, 13, 13, 13, 12, 12, 12, 12, 11, 11, 11, 10, 10, 10, 9, 9, 9, 9, 8, 8, 8, 7, 7, 7, 6, 6, 6, 6, 5, 5, 5, 4, 4, 4, 3, 3, 3, 3, 2, 2, 2, 1, 1, 1, 0, 0, 0};
    @GwtIncompatible(value="TODO")
    @VisibleForTesting
    static final long[] powersOf10 = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    @GwtIncompatible(value="TODO")
    @VisibleForTesting
    static final long[] halfPowersOf10 = new long[]{3L, 31L, 316L, 3162L, 31622L, 316227L, 3162277L, 31622776L, 316227766L, 3162277660L, 31622776601L, 316227766016L, 3162277660168L, 31622776601683L, 316227766016837L, 3162277660168379L, 31622776601683793L, 316227766016837933L, 3162277660168379331L};
    @VisibleForTesting
    static final long FLOOR_SQRT_MAX_LONG = 3037000499L;
    static final long[] factorials = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};
    static final int[] biggestBinomials = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 3810779, 121977, 16175, 4337, 1733, 887, 534, 361, 265, 206, 169, 143, 125, 111, 101, 94, 88, 83, 79, 76, 74, 72, 70, 69, 68, 67, 67, 66, 66, 66, 66};
    @VisibleForTesting
    static final int[] biggestSimpleBinomials = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 2642246, 86251, 11724, 3218, 1313, 684, 419, 287, 214, 169, 139, 119, 105, 95, 87, 81, 76, 73, 70, 68, 66, 64, 63, 62, 62, 61, 61, 61};

    public static boolean isPowerOfTwo(long x) {
        return x > 0L & (x & x - 1L) == 0L;
    }

    @VisibleForTesting
    static int lessThanBranchFree(long x, long y) {
        return (int)((x - y ^ 0xFFFFFFFFFFFFFFFFL ^ 0xFFFFFFFFFFFFFFFFL) >>> 63);
    }

    public static int log2(long x, RoundingMode mode) {
        MathPreconditions.checkPositive((String)"x", (long)x);
        switch (1.$SwitchMap$java$math$RoundingMode[mode.ordinal()]) {
            case 1: {
                MathPreconditions.checkRoundingUnnecessary((boolean)LongMath.isPowerOfTwo((long)x));
            }
            case 2: 
            case 3: {
                return 63 - Long.numberOfLeadingZeros(x);
            }
            case 4: 
            case 5: {
                return 64 - Long.numberOfLeadingZeros(x - 1L);
            }
            case 6: 
            case 7: 
            case 8: {
                int leadingZeros = Long.numberOfLeadingZeros(x);
                long cmp = -5402926248376769404L >>> leadingZeros;
                int logFloor = 63 - leadingZeros;
                return logFloor + LongMath.lessThanBranchFree((long)cmp, (long)x);
            }
        }
        throw new AssertionError((Object)"impossible");
    }

    @GwtIncompatible(value="TODO")
    public static int log10(long x, RoundingMode mode) {
        MathPreconditions.checkPositive((String)"x", (long)x);
        int logFloor = LongMath.log10Floor((long)x);
        long floorPow = powersOf10[logFloor];
        switch (1.$SwitchMap$java$math$RoundingMode[mode.ordinal()]) {
            case 1: {
                MathPreconditions.checkRoundingUnnecessary((x == floorPow ? 1 : 0) != 0);
            }
            case 2: 
            case 3: {
                return logFloor;
            }
            case 4: 
            case 5: {
                return logFloor + LongMath.lessThanBranchFree((long)floorPow, (long)x);
            }
            case 6: 
            case 7: 
            case 8: {
                return logFloor + LongMath.lessThanBranchFree((long)halfPowersOf10[logFloor], (long)x);
            }
        }
        throw new AssertionError();
    }

    @GwtIncompatible(value="TODO")
    static int log10Floor(long x) {
        byte y = maxLog10ForLeadingZeros[Long.numberOfLeadingZeros(x)];
        return y - LongMath.lessThanBranchFree((long)x, (long)powersOf10[y]);
    }

    @GwtIncompatible(value="TODO")
    public static long pow(long b2, int k2) {
        MathPreconditions.checkNonNegative((String)"exponent", (int)k2);
        if (-2L <= b2 && b2 <= 2L) {
            switch ((int)b2) {
                case 0: {
                    return k2 == 0 ? 1L : 0L;
                }
                case 1: {
                    return 1L;
                }
                case -1: {
                    return (k2 & 1) == 0 ? 1L : -1L;
                }
                case 2: {
                    return k2 < 64 ? 1L << k2 : 0L;
                }
                case -2: {
                    if (k2 < 64) {
                        return (k2 & 1) == 0 ? 1L << k2 : -(1L << k2);
                    }
                    return 0L;
                }
            }
            throw new AssertionError();
        }
        long accum = 1L;
        while (true) {
            switch (k2) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return accum * b2;
                }
            }
            accum *= (k2 & 1) == 0 ? 1L : b2;
            b2 *= b2;
            k2 >>= 1;
        }
    }

    @GwtIncompatible(value="TODO")
    public static long sqrt(long x, RoundingMode mode) {
        MathPreconditions.checkNonNegative((String)"x", (long)x);
        if (LongMath.fitsInInt((long)x)) {
            return IntMath.sqrt((int)((int)x), (RoundingMode)mode);
        }
        long guess = (long)Math.sqrt(x);
        long guessSquared = guess * guess;
        switch (1.$SwitchMap$java$math$RoundingMode[mode.ordinal()]) {
            case 1: {
                MathPreconditions.checkRoundingUnnecessary((guessSquared == x ? 1 : 0) != 0);
                return guess;
            }
            case 2: 
            case 3: {
                if (x < guessSquared) {
                    return guess - 1L;
                }
                return guess;
            }
            case 4: 
            case 5: {
                if (x > guessSquared) {
                    return guess + 1L;
                }
                return guess;
            }
            case 6: 
            case 7: 
            case 8: {
                long sqrtFloor = guess - (long)(x < guessSquared ? 1 : 0);
                long halfSquare = sqrtFloor * sqrtFloor + sqrtFloor;
                return sqrtFloor + (long)LongMath.lessThanBranchFree((long)halfSquare, (long)x);
            }
        }
        throw new AssertionError();
    }

    @GwtIncompatible(value="TODO")
    public static long divide(long p, long q, RoundingMode mode) {
        boolean increment;
        Preconditions.checkNotNull((Object)((Object)mode));
        long div = p / q;
        long rem = p - q * div;
        if (rem == 0L) {
            return div;
        }
        int signum = 1 | (int)((p ^ q) >> 63);
        switch (1.$SwitchMap$java$math$RoundingMode[mode.ordinal()]) {
            case 1: {
                MathPreconditions.checkRoundingUnnecessary((rem == 0L ? 1 : 0) != 0);
            }
            case 2: {
                increment = false;
                break;
            }
            case 4: {
                increment = true;
                break;
            }
            case 5: {
                increment = signum > 0;
                break;
            }
            case 3: {
                increment = signum < 0;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                long absRem = Math.abs(rem);
                long cmpRemToHalfDivisor = absRem - (Math.abs(q) - absRem);
                if (cmpRemToHalfDivisor == 0L) {
                    increment = mode == RoundingMode.HALF_UP | mode == RoundingMode.HALF_EVEN & (div & 1L) != 0L;
                    break;
                }
                increment = cmpRemToHalfDivisor > 0L;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return increment ? div + (long)signum : div;
    }

    @GwtIncompatible(value="TODO")
    public static int mod(long x, int m) {
        return (int)LongMath.mod((long)x, (long)m);
    }

    @GwtIncompatible(value="TODO")
    public static long mod(long x, long m) {
        if (m <= 0L) {
            throw new ArithmeticException("Modulus must be positive");
        }
        long result = x % m;
        return result >= 0L ? result : result + m;
    }

    public static long gcd(long a2, long b2) {
        MathPreconditions.checkNonNegative((String)"a", (long)a2);
        MathPreconditions.checkNonNegative((String)"b", (long)b2);
        if (a2 == 0L) {
            return b2;
        }
        if (b2 == 0L) {
            return a2;
        }
        int aTwos = Long.numberOfTrailingZeros(a2);
        a2 >>= aTwos;
        int bTwos = Long.numberOfTrailingZeros(b2);
        b2 >>= bTwos;
        while (a2 != b2) {
            long delta = a2 - b2;
            long minDeltaOrZero = delta & delta >> 63;
            a2 = delta - minDeltaOrZero - minDeltaOrZero;
            b2 += minDeltaOrZero;
            a2 >>= Long.numberOfTrailingZeros(a2);
        }
        return a2 << Math.min(aTwos, bTwos);
    }

    @GwtIncompatible(value="TODO")
    public static long checkedAdd(long a2, long b2) {
        long result = a2 + b2;
        MathPreconditions.checkNoOverflow((boolean)((a2 ^ b2) < 0L | (a2 ^ result) >= 0L));
        return result;
    }

    @GwtIncompatible(value="TODO")
    public static long checkedSubtract(long a2, long b2) {
        long result = a2 - b2;
        MathPreconditions.checkNoOverflow((boolean)((a2 ^ b2) >= 0L | (a2 ^ result) >= 0L));
        return result;
    }

    @GwtIncompatible(value="TODO")
    public static long checkedMultiply(long a2, long b2) {
        int leadingZeros = Long.numberOfLeadingZeros(a2) + Long.numberOfLeadingZeros(a2 ^ 0xFFFFFFFFFFFFFFFFL) + Long.numberOfLeadingZeros(b2) + Long.numberOfLeadingZeros(b2 ^ 0xFFFFFFFFFFFFFFFFL);
        if (leadingZeros > 65) {
            return a2 * b2;
        }
        MathPreconditions.checkNoOverflow((leadingZeros >= 64 ? 1 : 0) != 0);
        MathPreconditions.checkNoOverflow((boolean)(a2 >= 0L | b2 != Long.MIN_VALUE));
        long result = a2 * b2;
        MathPreconditions.checkNoOverflow((a2 == 0L || result / a2 == b2 ? 1 : 0) != 0);
        return result;
    }

    @GwtIncompatible(value="TODO")
    public static long checkedPow(long b2, int k2) {
        MathPreconditions.checkNonNegative((String)"exponent", (int)k2);
        if (b2 >= -2L & b2 <= 2L) {
            switch ((int)b2) {
                case 0: {
                    return k2 == 0 ? 1L : 0L;
                }
                case 1: {
                    return 1L;
                }
                case -1: {
                    return (k2 & 1) == 0 ? 1L : -1L;
                }
                case 2: {
                    MathPreconditions.checkNoOverflow((k2 < 63 ? 1 : 0) != 0);
                    return 1L << k2;
                }
                case -2: {
                    MathPreconditions.checkNoOverflow((k2 < 64 ? 1 : 0) != 0);
                    return (k2 & 1) == 0 ? 1L << k2 : -1L << k2;
                }
            }
            throw new AssertionError();
        }
        long accum = 1L;
        while (true) {
            switch (k2) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return LongMath.checkedMultiply((long)accum, (long)b2);
                }
            }
            if ((k2 & 1) != 0) {
                accum = LongMath.checkedMultiply((long)accum, (long)b2);
            }
            if ((k2 >>= 1) <= 0) continue;
            MathPreconditions.checkNoOverflow((b2 <= 3037000499L ? 1 : 0) != 0);
            b2 *= b2;
        }
    }

    @GwtIncompatible(value="TODO")
    public static long factorial(int n) {
        MathPreconditions.checkNonNegative((String)"n", (int)n);
        return n < factorials.length ? factorials[n] : Long.MAX_VALUE;
    }

    public static long binomial(int n, int k2) {
        MathPreconditions.checkNonNegative((String)"n", (int)n);
        MathPreconditions.checkNonNegative((String)"k", (int)k2);
        Preconditions.checkArgument((k2 <= n ? 1 : 0) != 0, (String)"k (%s) > n (%s)", (Object[])new Object[]{k2, n});
        if (k2 > n >> 1) {
            k2 = n - k2;
        }
        switch (k2) {
            case 0: {
                return 1L;
            }
            case 1: {
                return n;
            }
        }
        if (n < factorials.length) {
            return factorials[n] / (factorials[k2] * factorials[n - k2]);
        }
        if (k2 >= biggestBinomials.length || n > biggestBinomials[k2]) {
            return Long.MAX_VALUE;
        }
        if (k2 < biggestSimpleBinomials.length && n <= biggestSimpleBinomials[k2]) {
            long result = n--;
            for (int i = 2; i <= k2; ++i) {
                result *= (long)n;
                result /= (long)i;
                --n;
            }
            return result;
        }
        int nBits = LongMath.log2((long)n, (RoundingMode)RoundingMode.CEILING);
        long result = 1L;
        long numerator = n--;
        long denominator = 1L;
        int numeratorBits = nBits;
        int i = 2;
        while (i <= k2) {
            if (numeratorBits + nBits < 63) {
                numerator *= (long)n;
                denominator *= (long)i;
                numeratorBits += nBits;
            } else {
                result = LongMath.multiplyFraction((long)result, (long)numerator, (long)denominator);
                numerator = n;
                denominator = i;
                numeratorBits = nBits;
            }
            ++i;
            --n;
        }
        return LongMath.multiplyFraction((long)result, (long)numerator, (long)denominator);
    }

    static long multiplyFraction(long x, long numerator, long denominator) {
        if (x == 1L) {
            return numerator / denominator;
        }
        long commonDivisor = LongMath.gcd((long)x, (long)denominator);
        return (x /= commonDivisor) * (numerator / (denominator /= commonDivisor));
    }

    static boolean fitsInInt(long x) {
        return (long)((int)x) == x;
    }

    public static long mean(long x, long y) {
        return (x & y) + ((x ^ y) >> 1);
    }

    private LongMath() {
    }
}

