/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.GwtWorkarounds;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

@GwtCompatible(emulated=true)
final class GwtWorkarounds {
    private GwtWorkarounds() {
    }

    @GwtIncompatible(value="Reader")
    static CharInput asCharInput(Reader reader) {
        Preconditions.checkNotNull((Object)reader);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static CharInput asCharInput(CharSequence chars) {
        Preconditions.checkNotNull((Object)chars);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @GwtIncompatible(value="InputStream")
    static InputStream asInputStream(ByteInput input) {
        Preconditions.checkNotNull((Object)input);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @GwtIncompatible(value="OutputStream")
    static OutputStream asOutputStream(ByteOutput output) {
        Preconditions.checkNotNull((Object)output);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @GwtIncompatible(value="Writer")
    static CharOutput asCharOutput(Writer writer) {
        Preconditions.checkNotNull((Object)writer);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static CharOutput stringBuilderOutput(int initialSize) {
        StringBuilder builder = new StringBuilder(initialSize);
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

