/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.io.CharStreams;
import com.google.common.io.Closer;
import com.google.common.io.InputSupplier;
import com.google.common.io.LineProcessor;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class CharSource
implements InputSupplier<Reader> {
    protected CharSource() {
    }

    public abstract Reader openStream() throws IOException;

    @Deprecated
    public final Reader getInput() throws IOException {
        return this.openStream();
    }

    public BufferedReader openBufferedStream() throws IOException {
        Reader reader = this.openStream();
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public long copyTo(Appendable appendable) throws IOException {
        Preconditions.checkNotNull((Object)appendable);
        Closer closer = Closer.create();
        try {
            Reader reader = (Reader)closer.register((Closeable)this.openStream());
            long l = CharStreams.copy((Readable)reader, (Appendable)appendable);
            return l;
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    public long copyTo(CharSink sink) throws IOException {
        Preconditions.checkNotNull((Object)sink);
        Closer closer = Closer.create();
        try {
            Reader reader = (Reader)closer.register((Closeable)this.openStream());
            Writer writer = (Writer)closer.register((Closeable)sink.openStream());
            long l = CharStreams.copy((Readable)reader, (Appendable)writer);
            return l;
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    public String read() throws IOException {
        Closer closer = Closer.create();
        try {
            Reader reader = (Reader)closer.register((Closeable)this.openStream());
            String string = CharStreams.toString((Readable)reader);
            return string;
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    @Nullable
    public String readFirstLine() throws IOException {
        Closer closer = Closer.create();
        try {
            BufferedReader reader = (BufferedReader)closer.register((Closeable)this.openBufferedStream());
            String string = reader.readLine();
            return string;
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    public ImmutableList<String> readLines() throws IOException {
        Closer closer = Closer.create();
        try {
            String line;
            BufferedReader reader = (BufferedReader)closer.register((Closeable)this.openBufferedStream());
            ArrayList result = Lists.newArrayList();
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
            ImmutableList immutableList = ImmutableList.copyOf((Collection)result);
            return immutableList;
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    @Beta
    public <T> T readLines(LineProcessor<T> processor) throws IOException {
        Preconditions.checkNotNull(processor);
        Closer closer = Closer.create();
        try {
            Reader reader = (Reader)closer.register((Closeable)this.openStream());
            Object object = CharStreams.readLines((Readable)reader, processor);
            return (T)object;
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    public boolean isEmpty() throws IOException {
        Closer closer = Closer.create();
        try {
            Reader reader = (Reader)closer.register((Closeable)this.openStream());
            boolean bl = reader.read() == -1;
            return bl;
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    public static CharSource concat(Iterable<? extends CharSource> sources) {
        return new ConcatenatedCharSource(sources);
    }

    public static CharSource concat(Iterator<? extends CharSource> sources) {
        return CharSource.concat((Iterable)ImmutableList.copyOf(sources));
    }

    public static CharSource concat(CharSource ... sources) {
        return CharSource.concat((Iterable)ImmutableList.copyOf((Object[])sources));
    }

    public static CharSource wrap(CharSequence charSequence) {
        return new CharSequenceCharSource(charSequence);
    }

    public static CharSource empty() {
        return EmptyCharSource.access$000();
    }
}

