/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;

/*
 * Exception performing whole class analysis ignored.
 */
@Beta
public final class ByteStreams {
    private static final int BUF_SIZE = 4096;
    private static final OutputStream NULL_OUTPUT_STREAM = new /* Unavailable Anonymous Inner Class!! */;

    private ByteStreams() {
    }

    @Deprecated
    public static InputSupplier<ByteArrayInputStream> newInputStreamSupplier(byte[] b2) {
        return ByteStreams.asInputSupplier((ByteSource)ByteSource.wrap((byte[])b2));
    }

    @Deprecated
    public static InputSupplier<ByteArrayInputStream> newInputStreamSupplier(byte[] b2, int off, int len) {
        return ByteStreams.asInputSupplier((ByteSource)ByteSource.wrap((byte[])b2).slice((long)off, (long)len));
    }

    @Deprecated
    public static void write(byte[] from, OutputSupplier<? extends OutputStream> to) throws IOException {
        ByteStreams.asByteSink(to).write(from);
    }

    @Deprecated
    public static long copy(InputSupplier<? extends InputStream> from, OutputSupplier<? extends OutputStream> to) throws IOException {
        return ByteStreams.asByteSource(from).copyTo(ByteStreams.asByteSink(to));
    }

    @Deprecated
    public static long copy(InputSupplier<? extends InputStream> from, OutputStream to) throws IOException {
        return ByteStreams.asByteSource(from).copyTo(to);
    }

    @Deprecated
    public static long copy(InputStream from, OutputSupplier<? extends OutputStream> to) throws IOException {
        return ByteStreams.asByteSink(to).writeFrom(from);
    }

    public static long copy(InputStream from, OutputStream to) throws IOException {
        int r;
        Preconditions.checkNotNull((Object)from);
        Preconditions.checkNotNull((Object)to);
        byte[] buf = new byte[4096];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    public static long copy(ReadableByteChannel from, WritableByteChannel to) throws IOException {
        Preconditions.checkNotNull((Object)from);
        Preconditions.checkNotNull((Object)to);
        ByteBuffer buf = ByteBuffer.allocate(4096);
        long total = 0L;
        while (from.read(buf) != -1) {
            buf.flip();
            while (buf.hasRemaining()) {
                total += (long)to.write(buf);
            }
            buf.clear();
        }
        return total;
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteStreams.copy((InputStream)in, (OutputStream)out);
        return out.toByteArray();
    }

    static byte[] toByteArray(InputStream in, int expectedSize) throws IOException {
        int read;
        byte[] bytes = new byte[expectedSize];
        for (int remaining = expectedSize; remaining > 0; remaining -= read) {
            int off = expectedSize - remaining;
            read = in.read(bytes, off, remaining);
            if (read != -1) continue;
            return Arrays.copyOf(bytes, off);
        }
        int b2 = in.read();
        if (b2 == -1) {
            return bytes;
        }
        FastByteArrayOutputStream out = new FastByteArrayOutputStream(null);
        out.write(b2);
        ByteStreams.copy((InputStream)in, (OutputStream)out);
        byte[] result = new byte[bytes.length + out.size()];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        out.writeTo(result, bytes.length);
        return result;
    }

    @Deprecated
    public static byte[] toByteArray(InputSupplier<? extends InputStream> supplier) throws IOException {
        return ByteStreams.asByteSource(supplier).read();
    }

    public static ByteArrayDataInput newDataInput(byte[] bytes) {
        return ByteStreams.newDataInput((ByteArrayInputStream)new ByteArrayInputStream(bytes));
    }

    public static ByteArrayDataInput newDataInput(byte[] bytes, int start) {
        Preconditions.checkPositionIndex((int)start, (int)bytes.length);
        return ByteStreams.newDataInput((ByteArrayInputStream)new ByteArrayInputStream(bytes, start, bytes.length - start));
    }

    public static ByteArrayDataInput newDataInput(ByteArrayInputStream byteArrayInputStream) {
        return new ByteArrayDataInputStream((ByteArrayInputStream)Preconditions.checkNotNull((Object)byteArrayInputStream));
    }

    public static ByteArrayDataOutput newDataOutput() {
        return ByteStreams.newDataOutput((ByteArrayOutputStream)new ByteArrayOutputStream());
    }

    public static ByteArrayDataOutput newDataOutput(int size) {
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0, (String)"Invalid size: %s", (Object[])new Object[]{size});
        return ByteStreams.newDataOutput((ByteArrayOutputStream)new ByteArrayOutputStream(size));
    }

    public static ByteArrayDataOutput newDataOutput(ByteArrayOutputStream byteArrayOutputSteam) {
        return new ByteArrayDataOutputStream((ByteArrayOutputStream)Preconditions.checkNotNull((Object)byteArrayOutputSteam));
    }

    public static OutputStream nullOutputStream() {
        return NULL_OUTPUT_STREAM;
    }

    public static InputStream limit(InputStream in, long limit) {
        return new LimitedInputStream(in, limit);
    }

    @Deprecated
    public static long length(InputSupplier<? extends InputStream> supplier) throws IOException {
        return ByteStreams.asByteSource(supplier).size();
    }

    @Deprecated
    public static boolean equal(InputSupplier<? extends InputStream> supplier1, InputSupplier<? extends InputStream> supplier2) throws IOException {
        return ByteStreams.asByteSource(supplier1).contentEquals(ByteStreams.asByteSource(supplier2));
    }

    public static void readFully(InputStream in, byte[] b2) throws IOException {
        ByteStreams.readFully((InputStream)in, (byte[])b2, (int)0, (int)b2.length);
    }

    public static void readFully(InputStream in, byte[] b2, int off, int len) throws IOException {
        int read = ByteStreams.read((InputStream)in, (byte[])b2, (int)off, (int)len);
        if (read != len) {
            throw new EOFException("reached end of stream after reading " + read + " bytes; " + len + " bytes expected");
        }
    }

    public static void skipFully(InputStream in, long n) throws IOException {
        long toSkip = n;
        while (n > 0L) {
            long amt = in.skip(n);
            if (amt == 0L) {
                if (in.read() == -1) {
                    long skipped = toSkip - n;
                    throw new EOFException("reached end of stream after skipping " + skipped + " bytes; " + toSkip + " bytes expected");
                }
                --n;
                continue;
            }
            n -= amt;
        }
    }

    @Deprecated
    public static <T> T readBytes(InputSupplier<? extends InputStream> supplier, ByteProcessor<T> processor) throws IOException {
        Preconditions.checkNotNull(supplier);
        Preconditions.checkNotNull(processor);
        Closer closer = Closer.create();
        try {
            InputStream in = (InputStream)closer.register((Closeable)supplier.getInput());
            Object object = ByteStreams.readBytes((InputStream)in, processor);
            return (T)object;
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    public static <T> T readBytes(InputStream input, ByteProcessor<T> processor) throws IOException {
        int read;
        Preconditions.checkNotNull((Object)input);
        Preconditions.checkNotNull(processor);
        byte[] buf = new byte[4096];
        while ((read = input.read(buf)) != -1 && processor.processBytes(buf, 0, read)) {
        }
        return (T)processor.getResult();
    }

    @Deprecated
    public static HashCode hash(InputSupplier<? extends InputStream> supplier, HashFunction hashFunction) throws IOException {
        return ByteStreams.asByteSource(supplier).hash(hashFunction);
    }

    public static int read(InputStream in, byte[] b2, int off, int len) throws IOException {
        int total;
        int result;
        Preconditions.checkNotNull((Object)in);
        Preconditions.checkNotNull((Object)b2);
        if (len < 0) {
            throw new IndexOutOfBoundsException("len is negative");
        }
        for (total = 0; total < len && (result = in.read(b2, off + total, len - total)) != -1; total += result) {
        }
        return total;
    }

    @Deprecated
    public static InputSupplier<InputStream> slice(InputSupplier<? extends InputStream> supplier, long offset, long length) {
        return ByteStreams.asInputSupplier((ByteSource)ByteStreams.asByteSource(supplier).slice(offset, length));
    }

    @Deprecated
    public static InputSupplier<InputStream> join(Iterable<? extends InputSupplier<? extends InputStream>> suppliers) {
        Preconditions.checkNotNull(suppliers);
        Iterable sources = Iterables.transform(suppliers, (Function)new /* Unavailable Anonymous Inner Class!! */);
        return ByteStreams.asInputSupplier((ByteSource)ByteSource.concat((Iterable)sources));
    }

    @Deprecated
    public static InputSupplier<InputStream> join(InputSupplier<? extends InputStream> ... suppliers) {
        return ByteStreams.join(Arrays.asList(suppliers));
    }

    @Deprecated
    public static ByteSource asByteSource(InputSupplier<? extends InputStream> supplier) {
        Preconditions.checkNotNull(supplier);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Deprecated
    public static ByteSink asByteSink(OutputSupplier<? extends OutputStream> supplier) {
        Preconditions.checkNotNull(supplier);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static <S extends InputStream> InputSupplier<S> asInputSupplier(ByteSource source) {
        return (InputSupplier)Preconditions.checkNotNull((Object)source);
    }

    static <S extends OutputStream> OutputSupplier<S> asOutputSupplier(ByteSink sink) {
        return (OutputSupplier)Preconditions.checkNotNull((Object)sink);
    }
}

