/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.hash.AbstractStreamingHashFunction;
import com.google.common.hash.ChecksumHashFunction;
import com.google.common.hash.Hasher;
import java.io.Serializable;
import java.util.zip.Checksum;

final class ChecksumHashFunction
extends AbstractStreamingHashFunction
implements Serializable {
    private final Supplier<? extends Checksum> checksumSupplier;
    private final int bits;
    private final String toString;
    private static final long serialVersionUID = 0L;

    ChecksumHashFunction(Supplier<? extends Checksum> checksumSupplier, int bits, String toString) {
        this.checksumSupplier = (Supplier)Preconditions.checkNotNull(checksumSupplier);
        Preconditions.checkArgument((bits == 32 || bits == 64 ? 1 : 0) != 0, (String)"bits (%s) must be either 32 or 64", (Object[])new Object[]{bits});
        this.bits = bits;
        this.toString = (String)Preconditions.checkNotNull((Object)toString);
    }

    public int bits() {
        return this.bits;
    }

    public Hasher newHasher() {
        return new ChecksumHasher(this, (Checksum)this.checksumSupplier.get(), null);
    }

    public String toString() {
        return this.toString;
    }

    static /* synthetic */ int access$100(ChecksumHashFunction x0) {
        return x0.bits;
    }
}

