/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractSortedMultiset;
import com.google.common.collect.BoundType;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.GeneralRange;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.Serialization;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.TreeMultiset;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@GwtCompatible(emulated=true)
public final class TreeMultiset<E>
extends AbstractSortedMultiset<E>
implements Serializable {
    private final transient Reference<AvlNode<E>> rootReference;
    private final transient GeneralRange<E> range;
    private final transient AvlNode<E> header;
    @GwtIncompatible(value="not needed in emulated source")
    private static final long serialVersionUID = 1L;

    public static <E extends Comparable> TreeMultiset<E> create() {
        return new TreeMultiset((Comparator)Ordering.natural());
    }

    public static <E> TreeMultiset<E> create(@Nullable Comparator<? super E> comparator) {
        return comparator == null ? new TreeMultiset((Comparator)Ordering.natural()) : new TreeMultiset(comparator);
    }

    public static <E extends Comparable> TreeMultiset<E> create(Iterable<? extends E> elements) {
        TreeMultiset multiset = TreeMultiset.create();
        Iterables.addAll((Collection)multiset, elements);
        return multiset;
    }

    TreeMultiset(Reference<AvlNode<E>> rootReference, GeneralRange<E> range, AvlNode<E> endLink) {
        super(range.comparator());
        this.rootReference = rootReference;
        this.range = range;
        this.header = endLink;
    }

    TreeMultiset(Comparator<? super E> comparator) {
        super(comparator);
        this.range = GeneralRange.all(comparator);
        this.header = new AvlNode(null, 1);
        TreeMultiset.successor((AvlNode)this.header, (AvlNode)this.header);
        this.rootReference = new Reference(null);
    }

    private long aggregateForEntries(Aggregate aggr) {
        AvlNode root = (AvlNode)this.rootReference.get();
        long total = aggr.treeAggregate(root);
        if (this.range.hasLowerBound()) {
            total -= this.aggregateBelowRange(aggr, root);
        }
        if (this.range.hasUpperBound()) {
            total -= this.aggregateAboveRange(aggr, root);
        }
        return total;
    }

    private long aggregateBelowRange(Aggregate aggr, @Nullable AvlNode<E> node) {
        if (node == null) {
            return 0L;
        }
        int cmp = this.comparator().compare(this.range.getLowerEndpoint(), AvlNode.access$500(node));
        if (cmp < 0) {
            return this.aggregateBelowRange(aggr, AvlNode.access$600(node));
        }
        if (cmp == 0) {
            switch (4.$SwitchMap$com$google$common$collect$BoundType[this.range.getLowerBoundType().ordinal()]) {
                case 1: {
                    return (long)aggr.nodeAggregate(node) + aggr.treeAggregate(AvlNode.access$600(node));
                }
                case 2: {
                    return aggr.treeAggregate(AvlNode.access$600(node));
                }
            }
            throw new AssertionError();
        }
        return aggr.treeAggregate(AvlNode.access$600(node)) + (long)aggr.nodeAggregate(node) + this.aggregateBelowRange(aggr, AvlNode.access$700(node));
    }

    private long aggregateAboveRange(Aggregate aggr, @Nullable AvlNode<E> node) {
        if (node == null) {
            return 0L;
        }
        int cmp = this.comparator().compare(this.range.getUpperEndpoint(), AvlNode.access$500(node));
        if (cmp > 0) {
            return this.aggregateAboveRange(aggr, AvlNode.access$700(node));
        }
        if (cmp == 0) {
            switch (4.$SwitchMap$com$google$common$collect$BoundType[this.range.getUpperBoundType().ordinal()]) {
                case 1: {
                    return (long)aggr.nodeAggregate(node) + aggr.treeAggregate(AvlNode.access$700(node));
                }
                case 2: {
                    return aggr.treeAggregate(AvlNode.access$700(node));
                }
            }
            throw new AssertionError();
        }
        return aggr.treeAggregate(AvlNode.access$700(node)) + (long)aggr.nodeAggregate(node) + this.aggregateAboveRange(aggr, AvlNode.access$600(node));
    }

    public int size() {
        return Ints.saturatedCast((long)this.aggregateForEntries(Aggregate.SIZE));
    }

    int distinctElements() {
        return Ints.saturatedCast((long)this.aggregateForEntries(Aggregate.DISTINCT));
    }

    public int count(@Nullable Object element) {
        try {
            Object e = element;
            AvlNode root = (AvlNode)this.rootReference.get();
            if (!this.range.contains(e) || root == null) {
                return 0;
            }
            return root.count(this.comparator(), e);
        }
        catch (ClassCastException e) {
            return 0;
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    public int add(@Nullable E element, int occurrences) {
        CollectPreconditions.checkNonnegative((int)occurrences, (String)"occurrences");
        if (occurrences == 0) {
            return this.count(element);
        }
        Preconditions.checkArgument((boolean)this.range.contains(element));
        AvlNode root = (AvlNode)this.rootReference.get();
        if (root == null) {
            this.comparator().compare(element, element);
            AvlNode newRoot = new AvlNode(element, occurrences);
            TreeMultiset.successor((AvlNode)this.header, (AvlNode)newRoot, (AvlNode)this.header);
            this.rootReference.checkAndSet((Object)root, (Object)newRoot);
            return 0;
        }
        int[] result = new int[1];
        AvlNode newRoot = root.add(this.comparator(), element, occurrences, result);
        this.rootReference.checkAndSet((Object)root, (Object)newRoot);
        return result[0];
    }

    public int remove(@Nullable Object element, int occurrences) {
        AvlNode newRoot;
        CollectPreconditions.checkNonnegative((int)occurrences, (String)"occurrences");
        if (occurrences == 0) {
            return this.count(element);
        }
        AvlNode root = (AvlNode)this.rootReference.get();
        int[] result = new int[1];
        try {
            Object e = element;
            if (!this.range.contains(e) || root == null) {
                return 0;
            }
            newRoot = root.remove(this.comparator(), e, occurrences, result);
        }
        catch (ClassCastException e) {
            return 0;
        }
        catch (NullPointerException e) {
            return 0;
        }
        this.rootReference.checkAndSet((Object)root, (Object)newRoot);
        return result[0];
    }

    public int setCount(@Nullable E element, int count) {
        CollectPreconditions.checkNonnegative((int)count, (String)"count");
        if (!this.range.contains(element)) {
            Preconditions.checkArgument((count == 0 ? 1 : 0) != 0);
            return 0;
        }
        AvlNode root = (AvlNode)this.rootReference.get();
        if (root == null) {
            if (count > 0) {
                this.add(element, count);
            }
            return 0;
        }
        int[] result = new int[1];
        AvlNode newRoot = root.setCount(this.comparator(), element, count, result);
        this.rootReference.checkAndSet((Object)root, (Object)newRoot);
        return result[0];
    }

    public boolean setCount(@Nullable E element, int oldCount, int newCount) {
        CollectPreconditions.checkNonnegative((int)newCount, (String)"newCount");
        CollectPreconditions.checkNonnegative((int)oldCount, (String)"oldCount");
        Preconditions.checkArgument((boolean)this.range.contains(element));
        AvlNode root = (AvlNode)this.rootReference.get();
        if (root == null) {
            if (oldCount == 0) {
                if (newCount > 0) {
                    this.add(element, newCount);
                }
                return true;
            }
            return false;
        }
        int[] result = new int[1];
        AvlNode newRoot = root.setCount(this.comparator(), element, oldCount, newCount, result);
        this.rootReference.checkAndSet((Object)root, (Object)newRoot);
        return result[0] == oldCount;
    }

    private Multiset.Entry<E> wrapEntry(AvlNode<E> baseEntry) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Nullable
    private AvlNode<E> firstNode() {
        AvlNode node;
        AvlNode root = (AvlNode)this.rootReference.get();
        if (root == null) {
            return null;
        }
        if (this.range.hasLowerBound()) {
            Object endpoint = this.range.getLowerEndpoint();
            node = AvlNode.access$800((AvlNode)((AvlNode)this.rootReference.get()), (Comparator)this.comparator(), (Object)endpoint);
            if (node == null) {
                return null;
            }
            if (this.range.getLowerBoundType() == BoundType.OPEN && this.comparator().compare(endpoint, node.getElement()) == 0) {
                node = AvlNode.access$900((AvlNode)node);
            }
        } else {
            node = AvlNode.access$900((AvlNode)this.header);
        }
        return node == this.header || !this.range.contains(node.getElement()) ? null : node;
    }

    @Nullable
    private AvlNode<E> lastNode() {
        AvlNode node;
        AvlNode root = (AvlNode)this.rootReference.get();
        if (root == null) {
            return null;
        }
        if (this.range.hasUpperBound()) {
            Object endpoint = this.range.getUpperEndpoint();
            node = AvlNode.access$1000((AvlNode)((AvlNode)this.rootReference.get()), (Comparator)this.comparator(), (Object)endpoint);
            if (node == null) {
                return null;
            }
            if (this.range.getUpperBoundType() == BoundType.OPEN && this.comparator().compare(endpoint, node.getElement()) == 0) {
                node = AvlNode.access$1100((AvlNode)node);
            }
        } else {
            node = AvlNode.access$1100((AvlNode)this.header);
        }
        return node == this.header || !this.range.contains(node.getElement()) ? null : node;
    }

    Iterator<Multiset.Entry<E>> entryIterator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    Iterator<Multiset.Entry<E>> descendingEntryIterator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public SortedMultiset<E> headMultiset(@Nullable E upperBound, BoundType boundType) {
        return new TreeMultiset(this.rootReference, this.range.intersect(GeneralRange.upTo((Comparator)this.comparator(), upperBound, (BoundType)boundType)), this.header);
    }

    public SortedMultiset<E> tailMultiset(@Nullable E lowerBound, BoundType boundType) {
        return new TreeMultiset(this.rootReference, this.range.intersect(GeneralRange.downTo((Comparator)this.comparator(), lowerBound, (BoundType)boundType)), this.header);
    }

    static int distinctElements(@Nullable AvlNode<?> node) {
        return node == null ? 0 : AvlNode.access$400(node);
    }

    private static <T> void successor(AvlNode<T> a2, AvlNode<T> b2) {
        AvlNode.access$902(a2, b2);
        AvlNode.access$1102(b2, a2);
    }

    private static <T> void successor(AvlNode<T> a2, AvlNode<T> b2, AvlNode<T> c) {
        TreeMultiset.successor(a2, b2);
        TreeMultiset.successor(b2, c);
    }

    @GwtIncompatible(value="java.io.ObjectOutputStream")
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(this.elementSet().comparator());
        Serialization.writeMultiset((Multiset)this, (ObjectOutputStream)stream);
    }

    @GwtIncompatible(value="java.io.ObjectInputStream")
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        Comparator comparator = (Comparator)stream.readObject();
        Serialization.getFieldSetter(AbstractSortedMultiset.class, (String)"comparator").set((Object)this, (Object)comparator);
        Serialization.getFieldSetter(TreeMultiset.class, (String)"range").set((Object)this, (Object)GeneralRange.all((Comparator)comparator));
        Serialization.getFieldSetter(TreeMultiset.class, (String)"rootReference").set((Object)this, (Object)new Reference(null));
        AvlNode header = new AvlNode(null, 1);
        Serialization.getFieldSetter(TreeMultiset.class, (String)"header").set((Object)this, (Object)header);
        TreeMultiset.successor((AvlNode)header, (AvlNode)header);
        Serialization.populateMultiset((Multiset)this, (ObjectInputStream)stream);
    }

    static /* synthetic */ AvlNode access$1200(TreeMultiset x0) {
        return x0.firstNode();
    }

    static /* synthetic */ GeneralRange access$1300(TreeMultiset x0) {
        return x0.range;
    }

    static /* synthetic */ Multiset.Entry access$1400(TreeMultiset x0, AvlNode x1) {
        return x0.wrapEntry(x1);
    }

    static /* synthetic */ AvlNode access$1500(TreeMultiset x0) {
        return x0.header;
    }

    static /* synthetic */ AvlNode access$1600(TreeMultiset x0) {
        return x0.lastNode();
    }

    static /* synthetic */ void access$1700(AvlNode x0, AvlNode x1, AvlNode x2) {
        TreeMultiset.successor((AvlNode)x0, (AvlNode)x1, (AvlNode)x2);
    }

    static /* synthetic */ void access$1800(AvlNode x0, AvlNode x1) {
        TreeMultiset.successor((AvlNode)x0, (AvlNode)x1);
    }
}

