/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedAsList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.SortedIterables;
import com.google.common.collect.SortedLists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableSortedSet<E>
extends ImmutableSortedSet<E> {
    private final transient ImmutableList<E> elements;

    RegularImmutableSortedSet(ImmutableList<E> elements, Comparator<? super E> comparator) {
        super(comparator);
        this.elements = elements;
        Preconditions.checkArgument((!elements.isEmpty() ? 1 : 0) != 0);
    }

    public UnmodifiableIterator<E> iterator() {
        return this.elements.iterator();
    }

    @GwtIncompatible(value="NavigableSet")
    public UnmodifiableIterator<E> descendingIterator() {
        return this.elements.reverse().iterator();
    }

    public boolean isEmpty() {
        return false;
    }

    public int size() {
        return this.elements.size();
    }

    public boolean contains(Object o) {
        try {
            return o != null && this.unsafeBinarySearch(o) >= 0;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean containsAll(Collection<?> targets) {
        if (targets instanceof Multiset) {
            targets = ((Multiset)targets).elementSet();
        }
        if (!SortedIterables.hasSameComparator((Comparator)this.comparator(), (Iterable)targets) || targets.size() <= 1) {
            return super.containsAll((Collection)targets);
        }
        PeekingIterator thisIterator = Iterators.peekingIterator((Iterator)this.iterator());
        Iterator thatIterator = targets.iterator();
        Object target = thatIterator.next();
        try {
            while (thisIterator.hasNext()) {
                int cmp = this.unsafeCompare(thisIterator.peek(), target);
                if (cmp < 0) {
                    thisIterator.next();
                    continue;
                }
                if (cmp == 0) {
                    if (!thatIterator.hasNext()) {
                        return true;
                    }
                    target = thatIterator.next();
                    continue;
                }
                if (cmp <= 0) continue;
                return false;
            }
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
        return false;
    }

    private int unsafeBinarySearch(Object key) throws ClassCastException {
        return Collections.binarySearch(this.elements, key, this.unsafeComparator());
    }

    boolean isPartialView() {
        return this.elements.isPartialView();
    }

    int copyIntoArray(Object[] dst, int offset) {
        return this.elements.copyIntoArray(dst, offset);
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set that = (Set)object;
        if (this.size() != that.size()) {
            return false;
        }
        if (SortedIterables.hasSameComparator((Comparator)this.comparator, (Iterable)that)) {
            Iterator otherIterator = that.iterator();
            try {
                for (Object element : this) {
                    Object otherElement = otherIterator.next();
                    if (otherElement != null && this.unsafeCompare(element, otherElement) == 0) continue;
                    return false;
                }
                return true;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NoSuchElementException e) {
                return false;
            }
        }
        return this.containsAll((Collection)that);
    }

    public E first() {
        return (E)this.elements.get(0);
    }

    public E last() {
        return (E)this.elements.get(this.size() - 1);
    }

    public E lower(E element) {
        int index = this.headIndex(element, false) - 1;
        return (E)(index == -1 ? null : this.elements.get(index));
    }

    public E floor(E element) {
        int index = this.headIndex(element, true) - 1;
        return (E)(index == -1 ? null : this.elements.get(index));
    }

    public E ceiling(E element) {
        int index = this.tailIndex(element, true);
        return (E)(index == this.size() ? null : this.elements.get(index));
    }

    public E higher(E element) {
        int index = this.tailIndex(element, false);
        return (E)(index == this.size() ? null : this.elements.get(index));
    }

    ImmutableSortedSet<E> headSetImpl(E toElement, boolean inclusive) {
        return this.getSubSet(0, this.headIndex(toElement, inclusive));
    }

    int headIndex(E toElement, boolean inclusive) {
        return SortedLists.binarySearch((List)this.elements, (Object)Preconditions.checkNotNull(toElement), (Comparator)this.comparator(), (SortedLists.KeyPresentBehavior)(inclusive ? SortedLists.KeyPresentBehavior.FIRST_AFTER : SortedLists.KeyPresentBehavior.FIRST_PRESENT), (SortedLists.KeyAbsentBehavior)SortedLists.KeyAbsentBehavior.NEXT_HIGHER);
    }

    ImmutableSortedSet<E> subSetImpl(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return this.tailSetImpl(fromElement, fromInclusive).headSetImpl(toElement, toInclusive);
    }

    ImmutableSortedSet<E> tailSetImpl(E fromElement, boolean inclusive) {
        return this.getSubSet(this.tailIndex(fromElement, inclusive), this.size());
    }

    int tailIndex(E fromElement, boolean inclusive) {
        return SortedLists.binarySearch((List)this.elements, (Object)Preconditions.checkNotNull(fromElement), (Comparator)this.comparator(), (SortedLists.KeyPresentBehavior)(inclusive ? SortedLists.KeyPresentBehavior.FIRST_PRESENT : SortedLists.KeyPresentBehavior.FIRST_AFTER), (SortedLists.KeyAbsentBehavior)SortedLists.KeyAbsentBehavior.NEXT_HIGHER);
    }

    Comparator<Object> unsafeComparator() {
        return this.comparator;
    }

    ImmutableSortedSet<E> getSubSet(int newFromIndex, int newToIndex) {
        if (newFromIndex == 0 && newToIndex == this.size()) {
            return this;
        }
        if (newFromIndex < newToIndex) {
            return new RegularImmutableSortedSet(this.elements.subList(newFromIndex, newToIndex), this.comparator);
        }
        return RegularImmutableSortedSet.emptySet((Comparator)this.comparator);
    }

    int indexOf(@Nullable Object target) {
        int position;
        if (target == null) {
            return -1;
        }
        try {
            position = SortedLists.binarySearch((List)this.elements, (Object)target, (Comparator)this.unsafeComparator(), (SortedLists.KeyPresentBehavior)SortedLists.KeyPresentBehavior.ANY_PRESENT, (SortedLists.KeyAbsentBehavior)SortedLists.KeyAbsentBehavior.INVERTED_INSERTION_INDEX);
        }
        catch (ClassCastException e) {
            return -1;
        }
        return position >= 0 ? position : -1;
    }

    ImmutableList<E> createAsList() {
        return new ImmutableSortedAsList((ImmutableSortedSet)this, this.elements);
    }

    ImmutableSortedSet<E> createDescendingSet() {
        return new RegularImmutableSortedSet(this.elements.reverse(), (Comparator)Ordering.from((Comparator)this.comparator).reverse());
    }
}

