/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableAsList;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;

@GwtCompatible(serializable=true, emulated=true)
abstract class ImmutableAsList<E>
extends ImmutableList<E> {
    ImmutableAsList() {
    }

    abstract ImmutableCollection<E> delegateCollection();

    public boolean contains(Object target) {
        return this.delegateCollection().contains(target);
    }

    public int size() {
        return this.delegateCollection().size();
    }

    public boolean isEmpty() {
        return this.delegateCollection().isEmpty();
    }

    boolean isPartialView() {
        return this.delegateCollection().isPartialView();
    }

    @GwtIncompatible(value="serialization")
    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Use SerializedForm");
    }

    @GwtIncompatible(value="serialization")
    Object writeReplace() {
        return new SerializedForm(this.delegateCollection());
    }
}

