/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FilteredMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

@GwtCompatible
final class FilteredMultimapValues<K, V>
extends AbstractCollection<V> {
    private final FilteredMultimap<K, V> multimap;

    FilteredMultimapValues(FilteredMultimap<K, V> multimap) {
        this.multimap = (FilteredMultimap)Preconditions.checkNotNull(multimap);
    }

    @Override
    public Iterator<V> iterator() {
        return Maps.valueIterator(this.multimap.entries().iterator());
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.multimap.containsValue(o);
    }

    @Override
    public int size() {
        return this.multimap.size();
    }

    @Override
    public boolean remove(@Nullable Object o) {
        Predicate entryPredicate = this.multimap.entryPredicate();
        Iterator unfilteredItr = this.multimap.unfiltered().entries().iterator();
        while (unfilteredItr.hasNext()) {
            Map.Entry entry = (Map.Entry)unfilteredItr.next();
            if (!entryPredicate.apply((Object)entry) || !Objects.equal(entry.getValue(), (Object)o)) continue;
            unfilteredItr.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return Iterables.removeIf((Iterable)this.multimap.unfiltered().entries(), (Predicate)Predicates.and((Predicate)this.multimap.entryPredicate(), (Predicate)Maps.valuePredicateOnEntries((Predicate)Predicates.in(c))));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return Iterables.removeIf((Iterable)this.multimap.unfiltered().entries(), (Predicate)Predicates.and((Predicate)this.multimap.entryPredicate(), (Predicate)Maps.valuePredicateOnEntries((Predicate)Predicates.not((Predicate)Predicates.in(c)))));
    }

    @Override
    public void clear() {
        this.multimap.clear();
    }
}

