/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.AbstractMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.FilteredEntryMultimap;
import com.google.common.collect.FilteredMultimap;
import com.google.common.collect.FilteredMultimapValues;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@GwtCompatible
class FilteredEntryMultimap<K, V>
extends AbstractMultimap<K, V>
implements FilteredMultimap<K, V> {
    final Multimap<K, V> unfiltered;
    final Predicate<? super Map.Entry<K, V>> predicate;

    FilteredEntryMultimap(Multimap<K, V> unfiltered, Predicate<? super Map.Entry<K, V>> predicate) {
        this.unfiltered = (Multimap)Preconditions.checkNotNull(unfiltered);
        this.predicate = (Predicate)Preconditions.checkNotNull(predicate);
    }

    public Multimap<K, V> unfiltered() {
        return this.unfiltered;
    }

    public Predicate<? super Map.Entry<K, V>> entryPredicate() {
        return this.predicate;
    }

    public int size() {
        return this.entries().size();
    }

    private boolean satisfies(K key, V value) {
        return this.predicate.apply((Object)Maps.immutableEntry(key, value));
    }

    static <E> Collection<E> filterCollection(Collection<E> collection, Predicate<? super E> predicate) {
        if (collection instanceof Set) {
            return Sets.filter((Set)((Set)collection), predicate);
        }
        return Collections2.filter(collection, predicate);
    }

    public boolean containsKey(@Nullable Object key) {
        return this.asMap().get(key) != null;
    }

    public Collection<V> removeAll(@Nullable Object key) {
        return (Collection)Objects.firstNonNull(this.asMap().remove(key), (Object)this.unmodifiableEmptyCollection());
    }

    Collection<V> unmodifiableEmptyCollection() {
        return this.unfiltered instanceof SetMultimap ? Collections.emptySet() : Collections.emptyList();
    }

    public void clear() {
        this.entries().clear();
    }

    public Collection<V> get(K key) {
        return FilteredEntryMultimap.filterCollection((Collection)this.unfiltered.get(key), (Predicate)new ValuePredicate(this, key));
    }

    Collection<Map.Entry<K, V>> createEntries() {
        return FilteredEntryMultimap.filterCollection((Collection)this.unfiltered.entries(), (Predicate)this.predicate);
    }

    Collection<V> createValues() {
        return new FilteredMultimapValues((FilteredMultimap)this);
    }

    Iterator<Map.Entry<K, V>> entryIterator() {
        throw new AssertionError((Object)"should never be called");
    }

    Map<K, Collection<V>> createAsMap() {
        return new AsMap(this);
    }

    public Set<K> keySet() {
        return this.asMap().keySet();
    }

    boolean removeEntriesIf(Predicate<? super Map.Entry<K, Collection<V>>> predicate) {
        Iterator entryIterator = this.unfiltered.asMap().entrySet().iterator();
        boolean changed = false;
        while (entryIterator.hasNext()) {
            Map.Entry entry = entryIterator.next();
            Object key = entry.getKey();
            Collection collection = FilteredEntryMultimap.filterCollection((Collection)((Collection)entry.getValue()), (Predicate)new ValuePredicate(this, key));
            if (collection.isEmpty() || !predicate.apply((Object)Maps.immutableEntry(key, (Object)collection))) continue;
            if (collection.size() == ((Collection)entry.getValue()).size()) {
                entryIterator.remove();
            } else {
                collection.clear();
            }
            changed = true;
        }
        return changed;
    }

    Multiset<K> createKeys() {
        return new Keys(this);
    }

    static /* synthetic */ boolean access$000(FilteredEntryMultimap x0, Object x1, Object x2) {
        return x0.satisfies(x1, x2);
    }
}

