/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.network;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import java.util.EnumMap;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import org.spongepowered.api.Platform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.network.ChannelBinding;
import org.spongepowered.api.network.ChannelBuf;
import org.spongepowered.api.network.ChannelRegistrar;
import org.spongepowered.api.network.RawDataListener;
import org.spongepowered.api.network.RemoteConnection;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.common.network.SpongeNetworkManager;
import org.spongepowered.mod.network.SpongeModChannelBinding;
import org.spongepowered.mod.network.SpongeRawDataInboundHandler;

public class SpongeRawChannel
extends SpongeModChannelBinding
implements ChannelBinding.RawDataChannel {
    private final EnumMap<Platform.Type, Set<RawDataListener>> listeners = Maps.newEnumMap(Platform.Type.class);

    public SpongeRawChannel(ChannelRegistrar registrar, String channelName, PluginContainer owner) {
        super(registrar, channelName, owner);
        this.listeners.put(Platform.Type.CLIENT, Sets.newHashSet());
        this.listeners.put(Platform.Type.SERVER, Sets.newHashSet());
    }

    @Override
    protected ChannelHandler[] getHandlers() {
        return new ChannelHandler[]{new SpongeRawDataInboundHandler(this)};
    }

    @Override
    public void addListener(RawDataListener listener) {
        this.checkValidState();
        this.listeners.get((Object)Platform.Type.SERVER).add((RawDataListener)Preconditions.checkNotNull((Object)listener, (Object)"listener"));
        this.listeners.get((Object)Platform.Type.CLIENT).add(listener);
    }

    @Override
    public void addListener(Platform.Type side, RawDataListener listener) {
        this.checkValidState();
        Preconditions.checkArgument((boolean)((Platform.Type)((Object)Preconditions.checkNotNull((Object)((Object)side), (Object)"side"))).isKnown(), (Object)"Invalid side");
        this.listeners.get((Object)side).add((RawDataListener)Preconditions.checkNotNull((Object)listener, (Object)"listener"));
    }

    @Override
    public void removeListener(RawDataListener listener) {
        this.checkValidState();
        this.listeners.get((Object)Platform.Type.SERVER).remove(Preconditions.checkNotNull((Object)listener, (Object)"listener"));
        this.listeners.get((Object)Platform.Type.CLIENT).remove(listener);
    }

    void handlePacket(FMLProxyPacket msg, RemoteConnection con) {
        ChannelBuf payload = SpongeNetworkManager.toChannelBuf(msg.payload());
        Platform.Type side = msg.getTarget().isClient() ? Platform.Type.CLIENT : Platform.Type.SERVER;
        Set<RawDataListener> listeners = this.listeners.get((Object)side);
        for (RawDataListener listener : listeners) {
            listener.handlePayload(payload, con, side);
        }
    }

    private FMLProxyPacket createPacket(Consumer<ChannelBuf> payloadConsumer) {
        PacketBuffer payload = new PacketBuffer(Unpooled.buffer());
        ((Consumer)Preconditions.checkNotNull(payloadConsumer, (Object)"payloadConsumer")).accept((ChannelBuf)payload);
        return new FMLProxyPacket(payload, this.getName());
    }

    @Override
    public void sendTo(Player player, Consumer<ChannelBuf> payload) {
        super.sendTo(player, this.createPacket(payload));
    }

    @Override
    public void sendToServer(Consumer<ChannelBuf> payload) {
        super.sendToServer(this.createPacket(payload));
    }

    @Override
    public void sendToAll(Consumer<ChannelBuf> payload) {
        super.sendToAll(this.createPacket(payload));
    }
}

