/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.item.inventory;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.interfaces.IMixinInventory;
import org.spongepowered.common.item.inventory.adapter.impl.MinecraftInventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.collections.SlotCollection;
import org.spongepowered.common.item.inventory.lens.impl.comp.OrderedInventoryLensImpl;
import org.spongepowered.mod.item.inventory.fabric.IItemHandlerFabric;

@Mixin(value={InvWrapper.class})
@Implements(value={@Interface(iface=Inventory.class, prefix="inventory$")})
public abstract class MixinInvWrapper
implements MinecraftInventoryAdapter,
IMixinInventory {
    @Nullable
    protected Inventory parent;
    protected SlotCollection slots;
    protected List<Inventory> children = new ArrayList<Inventory>();
    @Nullable
    protected Iterable<Slot> slotIterator;
    private Fabric fabric;
    @Nullable
    protected Lens lens = null;
    private List<SlotTransaction> capturedTransactions = new ArrayList<SlotTransaction>();
    private boolean initalized = false;

    private void init() {
        if (!this.initalized) {
            this.initalized = true;
            this.fabric = new IItemHandlerFabric((IItemHandler)((InvWrapper)this));
            this.slots = new SlotCollection.Builder().add(this.fabric.getSize()).build();
            this.lens = new OrderedInventoryLensImpl(0, this.fabric.getSize(), 1, (SlotProvider)this.slots);
        }
    }

    @Override
    public Inventory parent() {
        return this.parent == null ? this : this.parent;
    }

    @Override
    public SlotProvider getSlotProvider() {
        this.init();
        return this.slots;
    }

    @Override
    public Inventory getChild(int index) {
        if (index < 0 || index >= this.getRootLens().getChildren().size()) {
            throw new IndexOutOfBoundsException("No child at index: " + index);
        }
        while (index >= this.children.size()) {
            this.children.add(null);
        }
        Inventory child = this.children.get(index);
        if (child == null) {
            child = this.getRootLens().getChildren().get(index).getAdapter(this.getFabric(), this);
            this.children.set(index, child);
        }
        return child;
    }

    @Override
    public <T extends Inventory> Iterable<T> slots() {
        this.init();
        if (this.slotIterator == null) {
            this.slotIterator = this.slots.getIterator(this);
        }
        return this.slotIterator;
    }

    @Intrinsic
    public void inventory$clear() {
        this.getFabric().clear();
    }

    @Override
    public Lens getRootLens() {
        this.init();
        return this.lens;
    }

    @Override
    public Fabric getFabric() {
        this.init();
        return this.fabric;
    }

    @Override
    public List<SlotTransaction> getCapturedTransactions() {
        return this.capturedTransactions;
    }
}

