/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.forge;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.VanillaInventoryCodeHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.interfaces.IMixinInventory;
import org.spongepowered.common.item.inventory.util.InventoryUtil;

@Mixin(value={VanillaInventoryCodeHooks.class})
public abstract class MixinVanillaInventoryCodeHooks {
    @Shadow(remap=false)
    private static ItemStack insertStack(TileEntity source, Object destination, IItemHandler destInventory, ItemStack stack, int slot) {
        throw new AbstractMethodError("Shadow");
    }

    @Shadow(remap=false)
    @Nullable
    private static Pair<IItemHandler, Object> getItemHandler(IHopper hopper, EnumFacing side) {
        throw new AbstractMethodError("Shadow");
    }

    @Inject(method={"insertHook"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILEXCEPTION, at={@At(value="INVOKE", target="Lnet/minecraft/tileentity/TileEntityHopper;getSizeInventory()I")})
    private static void onTransferItemsOut(TileEntityHopper hopper, CallbackInfoReturnable<Boolean> cir, EnumFacing hopperFacing, Pair<IItemHandler, Object> destinationResult, IItemHandler itemHandler, Object destination) {
        if (ShouldFire.CHANGE_INVENTORY_EVENT_TRANSFER_PRE && SpongeCommonEventFactory.callTransferPre(InventoryUtil.toInventory(hopper, null), InventoryUtil.toInventory(destination, itemHandler)).isCancelled()) {
            cir.setReturnValue(true);
        }
    }

    @Inject(remap=false, method={"extractHook"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILEXCEPTION, at={@At(value="INVOKE", target="Lorg/apache/commons/lang3/tuple/Pair;getKey()Ljava/lang/Object;")})
    private static void onExtractHook(IHopper hopper, CallbackInfoReturnable<Boolean> cir, Pair<IItemHandler, Object> itemHandlerResult) {
        if (ShouldFire.CHANGE_INVENTORY_EVENT_TRANSFER_PRE) {
            IItemHandler itemHandler = (IItemHandler)itemHandlerResult.getKey();
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                if (itemHandler.extractItem(i, 1, true).func_190926_b()) continue;
                Inventory source = InventoryUtil.toInventory(itemHandlerResult.getValue(), itemHandler);
                if (source.totalItems() == 0 || !SpongeCommonEventFactory.callTransferPre(source, InventoryUtil.toInventory(hopper, null)).isCancelled()) break;
                cir.setReturnValue(false);
                break;
            }
        }
    }

    @Inject(method={"dropperInsertHook"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILEXCEPTION, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;copy()Lnet/minecraft/item/ItemStack;", ordinal=0)})
    private static void onDispense(World world, BlockPos pos, TileEntityDispenser dropper, int slot, ItemStack stack, CallbackInfoReturnable<Boolean> cir, EnumFacing enumFacing, BlockPos blockPos, Pair<IItemHandler, Object> destinationResult, IItemHandler itemHandler, Object destination) {
        if (ShouldFire.CHANGE_INVENTORY_EVENT_TRANSFER_PRE && SpongeCommonEventFactory.callTransferPre(InventoryUtil.toInventory(dropper, null), InventoryUtil.toInventory(destination, itemHandler)).isCancelled()) {
            cir.setReturnValue(false);
        }
    }

    @Redirect(remap=false, method={"putStackInInventoryAllSlots"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/items/VanillaInventoryCodeHooks;insertStack(Lnet/minecraft/tileentity/TileEntity;Ljava/lang/Object;Lnet/minecraftforge/items/IItemHandler;Lnet/minecraft/item/ItemStack;I)Lnet/minecraft/item/ItemStack;"))
    private static ItemStack onInsertStack(TileEntity source, Object destination, IItemHandler destInventory, ItemStack stack, int slot) {
        if (ShouldFire.CHANGE_INVENTORY_EVENT_TRANSFER_POST) {
            return SpongeCommonEventFactory.captureTransaction(InventoryUtil.forCapture(source), InventoryUtil.toInventory(destination, destInventory), slot, () -> MixinVanillaInventoryCodeHooks.insertStack(source, destination, destInventory, stack, slot));
        }
        return MixinVanillaInventoryCodeHooks.insertStack(source, destination, destInventory, stack, slot);
    }

    @Redirect(remap=false, method={"extractHook"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/items/IItemHandler;extractItem(IIZ)Lnet/minecraft/item/ItemStack;", ordinal=1))
    private static ItemStack onPullItemOut(IItemHandler handler, int slot, int amount, boolean simulate, IHopper dest) {
        if (ShouldFire.CHANGE_INVENTORY_EVENT_TRANSFER_POST) {
            Object inv = MixinVanillaInventoryCodeHooks.getItemHandler(dest, EnumFacing.UP).getValue();
            ItemStack origin = handler.getStackInSlot(slot).func_77946_l();
            ItemStack result = handler.extractItem(slot, amount, simulate);
            if (!result.func_190926_b()) {
                SpongeCommonEventFactory.captureTransaction(InventoryUtil.forCapture(dest), InventoryUtil.toInventory(inv, handler), slot, origin);
            }
            return result;
        }
        return handler.extractItem(slot, amount, simulate);
    }

    @Redirect(method={"extractHook"}, at=@At(value="INVOKE", target="Lnet/minecraft/tileentity/IHopper;setInventorySlotContents(ILnet/minecraft/item/ItemStack;)V"))
    private static void onPullItemIn(IHopper dest, int index, ItemStack stack) {
        if (ShouldFire.CHANGE_INVENTORY_EVENT_TRANSFER_POST) {
            ItemStack destStack = dest.func_70301_a(index).func_77946_l();
            destStack.func_190918_g(1);
            dest.func_70299_a(index, stack);
            SpongeCommonEventFactory.captureTransaction(InventoryUtil.forCapture(dest), InventoryUtil.toInventory(dest, null), index, destStack);
        } else {
            dest.func_70299_a(index, stack);
        }
    }

    @Inject(method={"insertHook"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isEmpty()Z", ordinal=1)})
    private static void afterPutStackInSlots(TileEntityHopper hopper, CallbackInfoReturnable<Boolean> cir, EnumFacing hopperFacing, Pair<IItemHandler, Object> destinationResult, IItemHandler itemHandler, Object destination, int i, ItemStack originalSlotContents, ItemStack insertStack, ItemStack remainder) {
        if (ShouldFire.CHANGE_INVENTORY_EVENT_TRANSFER_POST && remainder.func_190926_b()) {
            IMixinInventory capture = InventoryUtil.forCapture(hopper);
            if (capture == null) {
                return;
            }
            Inventory sInv = InventoryUtil.toInventory(hopper, null);
            Inventory dInv = InventoryUtil.toInventory(destination, itemHandler);
            SpongeCommonEventFactory.captureTransaction(capture, sInv, i, originalSlotContents);
            if (SpongeCommonEventFactory.callTransferPost(capture, sInv, dInv) && originalSlotContents.func_190926_b()) {
                cir.setReturnValue(true);
            }
        }
    }

    @Inject(method={"extractHook"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, at={@At(value="INVOKE", target="Lnet/minecraft/tileentity/IHopper;markDirty()V")})
    private static void onPullItemsDone(IHopper dest, CallbackInfoReturnable<Boolean> cir, Pair<IItemHandler, Object> itemHandlerResult, IItemHandler handler, int i, ItemStack extractItem, int j, ItemStack destStack) {
        if (ShouldFire.CHANGE_INVENTORY_EVENT_TRANSFER_POST) {
            SpongeCommonEventFactory.callTransferPost(InventoryUtil.forCapture(dest), InventoryUtil.toInventory(itemHandlerResult.getValue(), handler), InventoryUtil.toInventory(dest, null));
        }
    }

    @Inject(remap=false, method={"dropperInsertHook"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, at={@At(value="RETURN", ordinal=1)})
    private static void afterDispense(World world, BlockPos pos, TileEntityDispenser dropper, int slot, ItemStack stack, CallbackInfoReturnable<Boolean> cir, EnumFacing enumFacing, BlockPos blockPos, Pair<IItemHandler, Object> destinationResult, IItemHandler itemHandler, Object destination, ItemStack dispensedStack, ItemStack remainder) {
        if (ShouldFire.CHANGE_INVENTORY_EVENT_TRANSFER_POST) {
            IMixinInventory capture = InventoryUtil.forCapture(dropper);
            Inventory source = InventoryUtil.toInventory(dropper, null);
            Inventory destInv = InventoryUtil.toInventory(destination, itemHandler);
            SpongeCommonEventFactory.captureTransaction(capture, source, slot, stack);
            SpongeCommonEventFactory.callTransferPost(capture, source, destInv);
        }
    }
}

