/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.forge;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.interfaces.data.IMixinCustomDataHolder;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.mod.interfaces.IMixinBlockSnapshot;

@NonnullByDefault
@Mixin(value={BlockSnapshot.class}, remap=false)
public abstract class MixinBlockSnapshot
implements IMixinBlockSnapshot {
    @Shadow
    @Final
    private BlockPos pos;
    @Shadow
    @Final
    private NBTTagCompound nbt;
    @Shadow
    @Nullable
    private IBlockState replacedBlock;

    @Shadow
    public abstract TileEntity getTileEntity();

    @Shadow
    public abstract World getWorld();

    @Override
    public org.spongepowered.api.block.BlockSnapshot createSpongeBlockSnapshot() {
        TileEntity te;
        Location<org.spongepowered.api.world.World> location = new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)this.getWorld(), VecHelper.toVector3i(this.pos));
        SpongeBlockSnapshotBuilder builder = new SpongeBlockSnapshotBuilder();
        builder.blockState((BlockState)this.replacedBlock).worldId(location.getExtent().getUniqueId()).position(location.getBlockPosition());
        if (this.nbt != null) {
            builder.unsafeNbt(this.nbt);
        }
        if ((te = this.getTileEntity()) != null) {
            if (!te.func_145830_o()) {
                te.func_145834_a(this.getWorld());
            }
            for (DataManipulator<?, ?> manipulator : ((IMixinCustomDataHolder)te).getCustomManipulators()) {
                builder.add((DataManipulator)manipulator);
            }
        }
        return builder.build();
    }
}

