/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.fml.common.registry;

import co.aikar.timings.SpongeTimingsFactory;
import co.aikar.timings.Timing;
import co.aikar.timings.Timings;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.mod.util.StaticMixinForgeHelper;

@NonnullByDefault
@Mixin(value={GameRegistry.class}, remap=false)
public class MixinGameRegistry {
    private static final String WORLD_GENERATOR_GENERATE = "Lnet/minecraftforge/fml/common/IWorldGenerator;generate(Ljava/util/Random;IILnet/minecraft/world/World;Lnet/minecraft/world/gen/IChunkGenerator;Lnet/minecraft/world/chunk/IChunkProvider;)V";
    private static Map<Class<?>, Timing> worldGeneratorTimings = Maps.newHashMap();

    @Redirect(method={"generateWorld"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/fml/common/IWorldGenerator;generate(Ljava/util/Random;IILnet/minecraft/world/World;Lnet/minecraft/world/gen/IChunkGenerator;Lnet/minecraft/world/chunk/IChunkProvider;)V", remap=false))
    private static void onGenerateWorld(IWorldGenerator worldGenerator, Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        Timing timing = null;
        if (Timings.isTimingsEnabled()) {
            timing = worldGeneratorTimings.get(worldGenerator.getClass());
            if (timing == null) {
                String modId = StaticMixinForgeHelper.getModIdFromClass(worldGenerator.getClass());
                timing = SpongeTimingsFactory.ofSafe("worldGenerator (" + modId + ":" + worldGenerator.getClass().getName() + ")");
                worldGeneratorTimings.put(worldGenerator.getClass(), timing);
            }
            timing.startTimingIfSync();
        }
        worldGenerator.generate(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        if (Timings.isTimingsEnabled()) {
            timing.stopTimingIfSync();
        }
    }

    @Inject(method={"generateWorld"}, at={@At(value="HEAD")})
    private static void onGenerateWorldHead(int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider, CallbackInfo ci) {
        if (Timings.isTimingsEnabled()) {
            ((IMixinWorldServer)world).getTimingsHandler().chunkPopulate.startTimingIfSync();
        }
    }

    @Inject(method={"generateWorld"}, at={@At(value="RETURN")})
    private static void onGenerateWorldEnd(int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider, CallbackInfo ci) {
        if (Timings.isTimingsEnabled()) {
            ((IMixinWorldServer)world).getTimingsHandler().chunkPopulate.stopTimingIfSync();
        }
    }
}

