/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.asm.transformer.adapter;

import java.io.IOException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.spongepowered.mod.asm.transformer.adapter.ISpongeAdviceAdapter;

public class SpongeClassVisitorAdapter
extends ClassVisitor {
    private final ISpongeAdviceAdapter adapter;
    private final String className;
    private final String superClassName;
    private final String methodName;
    private final String methodDesc;

    public SpongeClassVisitorAdapter(ISpongeAdviceAdapter adapter, ClassVisitor cv, String className, String superClassName, String methodName, String methodDesc) {
        super(327680, cv);
        this.adapter = adapter;
        this.className = className;
        this.superClassName = superClassName;
        this.methodName = methodName;
        this.methodDesc = methodDesc;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (name.equals(this.methodName) && desc.equals(this.methodDesc) && this.findSuperClass(this.className)) {
            MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
            return this.adapter.createMethodAdviceAdapter(327680, this.className, access, name, desc, mv);
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    public boolean findSuperClass(String className) {
        ClassReader cr = null;
        try {
            cr = new ClassReader(className);
        }
        catch (IOException e) {
            return false;
        }
        String superName = cr.getSuperName();
        if (superName != null && !superName.equals("java/lang/Object")) {
            if (superName.equals(this.superClassName)) {
                return true;
            }
            String superClass = superName.replace('.', '/');
            this.findSuperClass(superClass);
        }
        return false;
    }
}

