/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod;

import com.google.common.base.Preconditions;
import com.google.inject.Singleton;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.spongepowered.api.GameDictionary;
import org.spongepowered.api.Server;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.common.SpongeGame;
import org.spongepowered.mod.registry.SpongeForgeGameDictionary;

@NonnullByDefault
@Singleton
public final class SpongeModGame
extends SpongeGame {
    @Override
    public Path getSavesDirectory() {
        return FMLCommonHandler.instance().getSavesDirectory().toPath();
    }

    @Override
    public boolean isServerAvailable() {
        return FMLCommonHandler.instance().getSidedDelegate().getServer() != null;
    }

    @Override
    public Server getServer() {
        MinecraftServer server = FMLCommonHandler.instance().getSidedDelegate().getServer();
        Preconditions.checkState((server != null ? 1 : 0) != 0, (Object)"Server has not been initialized yet!");
        return (Server)server;
    }

    @Override
    public Optional<GameDictionary> getGameDictionary() {
        return Optional.of(SpongeForgeGameDictionary.instance);
    }
}

