/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.launch;

import java.awt.GraphicsEnvironment;
import javax.swing.JOptionPane;

public class JavaVersionCheckUtils {
    private static final String REQUIRED_VERSION = "1.8.0_20";
    private static final String ERROR_MESSAGE = "We have detected that you are JRE version %s, which is not supported!!\nIn order to run Sponge, you **must** be running JRE version %s or above.\nOlder builds or newer Java major versions (like 9 or 10) are not supported.\nThis can be downloaded from Oracle: http://www.oracle.com/technetwork/java/javase/downloads/jre8-downloads-2133155.html";

    public static void ensureJava8() {
        String version = JavaVersionCheckUtils.getCurrentVersion();
        if (JavaVersionCheckUtils.getVersionValue(version) < JavaVersionCheckUtils.getVersionValue(REQUIRED_VERSION)) {
            if (!version.startsWith("1.8")) {
                String error = String.format(ERROR_MESSAGE, version, REQUIRED_VERSION);
                if (!GraphicsEnvironment.isHeadless()) {
                    JOptionPane.showMessageDialog(null, error, "PEBKACException!", 0);
                }
                throw new RuntimeException(error);
            }
            System.out.println("You may be running an outdated version of Java. Any crashes from Sponge may require an update to Java.");
        }
    }

    private static String getCurrentVersion() {
        return System.getProperty("java.version");
    }

    private static double getVersionValue(String version) {
        if (version.contains("-")) {
            version = version.substring(0, version.indexOf(45));
        }
        version = version.replace('_', '.');
        String[] versionParts = version.split("\\.");
        double versionValue = 0.0;
        for (int i = 0; i < versionParts.length; ++i) {
            try {
                int part = Integer.valueOf(versionParts[i]);
                versionValue += (double)part * Math.pow(10.0, versionParts.length - (i - 1) * 3);
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return versionValue;
    }
}

