/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.Populator;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.common.registry.type.world.gen.PopulatorTypeRegistryModule;
import org.spongepowered.common.util.VecHelper;

public class WrappedBiomeDecorator
implements Populator {
    private BiomeDecorator wrapped;
    private Biome biome;
    private final PopulatorType type;

    public WrappedBiomeDecorator(Biome dec) {
        this.biome = dec;
        this.type = PopulatorTypeRegistryModule.getInstance().getOrCreateForType(this.biome.getClass());
    }

    public WrappedBiomeDecorator(BiomeDecorator dec) {
        this.wrapped = dec;
        this.type = PopulatorTypeRegistryModule.getInstance().getOrCreateForType(this.wrapped.getClass());
    }

    @Override
    public PopulatorType getType() {
        return this.type;
    }

    @Override
    public void populate(org.spongepowered.api.world.World world, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World worldIn = (World)world;
        if (this.biome != null) {
            this.biome.func_180624_a(worldIn, random, VecHelper.toBlockPos(min.sub(8, 0, 8)));
        } else {
            Biome biome = (Biome)extent.getBiome(size.getX() / 2 + min.getX(), 0, size.getZ() / 2 + min.getZ());
            this.wrapped.func_180292_a(worldIn, random, biome, VecHelper.toBlockPos(min.sub(8, 0, 8)));
        }
    }
}

