/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import com.google.common.base.Preconditions;
import net.minecraft.world.gen.feature.WorldGenIcePath;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.gen.populator.IcePath;

public class IcePathBuilder
implements IcePath.Builder {
    private VariableAmount radius;
    private VariableAmount count;

    public IcePathBuilder() {
        this.reset();
    }

    @Override
    public IcePath.Builder radius(VariableAmount radius) {
        this.radius = (VariableAmount)Preconditions.checkNotNull((Object)radius);
        return this;
    }

    @Override
    public IcePath.Builder perChunk(VariableAmount sections) {
        this.count = (VariableAmount)Preconditions.checkNotNull((Object)sections);
        return this;
    }

    @Override
    public IcePath.Builder from(IcePath value) {
        return this.radius(value.getRadius()).perChunk(value.getSectionsPerChunk());
    }

    @Override
    public IcePath.Builder reset() {
        this.radius = VariableAmount.baseWithRandomAddition(2.0, 2.0);
        this.count = VariableAmount.fixed(2.0);
        return this;
    }

    @Override
    public IcePath build() throws IllegalStateException {
        IcePath pop = (IcePath)new WorldGenIcePath(4);
        pop.setRadius(this.radius);
        pop.setSectionsPerChunk(this.count);
        return pop;
    }
}

