/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import com.google.common.base.Preconditions;
import net.minecraft.world.gen.feature.WorldGenEndIsland;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.gen.populator.EndIsland;

public class EndIslandBuilder
implements EndIsland.Builder {
    private VariableAmount initial;
    private VariableAmount decrement;
    private BlockState state;
    private int exclusion;

    public EndIslandBuilder() {
        this.reset();
    }

    @Override
    public EndIsland.Builder startingRadius(VariableAmount radius) {
        this.initial = (VariableAmount)Preconditions.checkNotNull((Object)radius);
        return this;
    }

    @Override
    public EndIsland.Builder radiusDecrement(VariableAmount radius) {
        this.decrement = (VariableAmount)Preconditions.checkNotNull((Object)radius);
        return this;
    }

    @Override
    public EndIsland.Builder islandBlock(BlockState state) {
        this.state = (BlockState)Preconditions.checkNotNull((Object)state, (Object)"state");
        return this;
    }

    @Override
    public EndIsland.Builder exclusionRadius(int radius) {
        Preconditions.checkArgument((radius >= 0 ? 1 : 0) != 0, (Object)"Exclusion radius must be postive or zero");
        this.exclusion = radius;
        return this;
    }

    @Override
    public EndIsland.Builder from(EndIsland value) {
        this.startingRadius(value.getStartingRadius());
        this.radiusDecrement(value.getRadiusDecrement());
        this.islandBlock(value.getIslandBlock());
        return this;
    }

    @Override
    public EndIsland.Builder reset() {
        this.initial = VariableAmount.baseWithRandomAddition(4.0, 3.0);
        this.decrement = VariableAmount.baseWithRandomAddition(0.5, 2.0);
        this.state = BlockTypes.END_STONE.getDefaultState();
        this.exclusion = 1024;
        return this;
    }

    @Override
    public EndIsland build() throws IllegalStateException {
        EndIsland island = (EndIsland)new WorldGenEndIsland();
        island.setIslandBlock(this.state);
        island.setStartingRadius(this.initial);
        island.setRadiusDecrement(this.decrement);
        island.setExclusionRadius(this.exclusion);
        return island;
    }
}

