/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.world.gen.ChunkGeneratorEnd;
import net.minecraft.world.gen.ChunkGeneratorFlat;
import net.minecraft.world.gen.ChunkGeneratorHell;
import net.minecraft.world.gen.ChunkGeneratorOverworld;
import net.minecraft.world.gen.IChunkGenerator;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.util.weighted.SeededVariableAmount;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public final class WorldGenConstants {
    public static final String VILLAGE_FLAG = "VILLAGE";
    private static final Class<?>[] MIXINED_CHUNK_PROVIDERS = new Class[]{ChunkGeneratorOverworld.class, ChunkGeneratorFlat.class, ChunkGeneratorHell.class, ChunkGeneratorEnd.class};
    public static final SeededVariableAmount<Double> GROUND_COVER_DEPTH = new SeededVariableAmount<Double>(){

        @Override
        public double getAmount(Random rand, Double seed) {
            return (int)(seed / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        }
    };
    public static final Predicate<BlockState> DIRT_OR_GRASS = input -> input.getType().equals(BlockTypes.DIRT) || input.getType().equals(BlockTypes.GRASS);
    public static final Predicate<BlockState> DIRT = input -> input.getType().equals(BlockTypes.DIRT);
    public static final Predicate<BlockState> STONE = input -> input.getType().equals(BlockTypes.STONE);
    public static final Predicate<Location<World>> STONE_LOCATION = input -> input.getBlock().getType().equals(BlockTypes.STONE);
    public static final Predicate<Location<World>> CAVE_LIQUIDS = input -> {
        if (input.getBlockY() <= 0 || input.getBlockY() >= 255) {
            return false;
        }
        if (input.add(0.0, 1.0, 0.0).getBlock().getType() != BlockTypes.STONE || input.add(0.0, -1.0, 0.0).getBlock().getType() != BlockTypes.STONE || input.getBlock().getType() != BlockTypes.STONE && input.getBlock().getType() != BlockTypes.AIR) {
            return false;
        }
        int air = 0;
        int stone = 0;
        if (input.add(1.0, 0.0, 0.0).getBlock().getType() == BlockTypes.STONE) {
            ++stone;
        }
        if (input.add(-1.0, 0.0, 0.0).getBlock().getType() == BlockTypes.STONE) {
            ++stone;
        }
        if (input.add(0.0, 0.0, 1.0).getBlock().getType() == BlockTypes.STONE) {
            ++stone;
        }
        if (input.add(0.0, 0.0, -1.0).getBlock().getType() == BlockTypes.STONE) {
            ++stone;
        }
        if (input.add(1.0, 0.0, 0.0).getBlock().getType() == BlockTypes.AIR) {
            ++air;
        }
        if (input.add(-1.0, 0.0, 0.0).getBlock().getType() == BlockTypes.AIR) {
            ++air;
        }
        if (input.add(0.0, 0.0, 1.0).getBlock().getType() == BlockTypes.AIR) {
            ++air;
        }
        if (input.add(0.0, 0.0, -1.0).getBlock().getType() == BlockTypes.AIR) {
            ++air;
        }
        return air == 1 && stone == 3;
    };
    public static final Predicate<Location<World>> HELL_LAVA = input -> {
        if (input.add(0.0, 1.0, 0.0).getBlockType() != BlockTypes.NETHERRACK) {
            return false;
        }
        if (input.getBlockType() != BlockTypes.AIR && input.getBlockType() != BlockTypes.NETHERRACK) {
            return false;
        }
        int i = 0;
        if (input.add(-1.0, 0.0, 0.0).getBlockType() == BlockTypes.NETHERRACK) {
            ++i;
        }
        if (input.add(1.0, 0.0, 0.0).getBlockType() == BlockTypes.NETHERRACK) {
            ++i;
        }
        if (input.add(0.0, 0.0, -1.0).getBlockType() == BlockTypes.NETHERRACK) {
            ++i;
        }
        if (input.add(0.0, 0.0, 1.0).getBlockType() == BlockTypes.NETHERRACK) {
            ++i;
        }
        if (input.add(0.0, -1.0, 0.0).getBlockType() == BlockTypes.NETHERRACK) {
            ++i;
        }
        int j = 0;
        if (input.add(-1.0, 0.0, 0.0).getBlockType() == BlockTypes.AIR) {
            ++j;
        }
        if (input.add(1.0, 0.0, 0.0).getBlockType() == BlockTypes.AIR) {
            ++j;
        }
        if (input.add(0.0, 0.0, -1.0).getBlockType() == BlockTypes.AIR) {
            ++j;
        }
        if (input.add(0.0, 0.0, 1.0).getBlockType() == BlockTypes.AIR) {
            ++j;
        }
        if (input.add(0.0, -1.0, 0.0).getBlockType() == BlockTypes.AIR) {
            ++j;
        }
        return i == 4 && j == 1;
    };
    public static final Predicate<Location<World>> HELL_LAVA_ENCLOSED = input -> {
        if (input.add(0.0, 1.0, 0.0).getBlockType() != BlockTypes.NETHERRACK) {
            return false;
        }
        if (input.getBlockType() != BlockTypes.AIR && input.getBlockType() != BlockTypes.NETHERRACK) {
            return false;
        }
        int i = 0;
        if (input.add(-1.0, 0.0, 0.0).getBlockType() == BlockTypes.NETHERRACK) {
            ++i;
        }
        if (input.add(1.0, 0.0, 0.0).getBlockType() == BlockTypes.NETHERRACK) {
            ++i;
        }
        if (input.add(0.0, 0.0, -1.0).getBlockType() == BlockTypes.NETHERRACK) {
            ++i;
        }
        if (input.add(0.0, 0.0, 1.0).getBlockType() == BlockTypes.NETHERRACK) {
            ++i;
        }
        if (input.add(0.0, -1.0, 0.0).getBlockType() == BlockTypes.NETHERRACK) {
            ++i;
        }
        return i == 5;
    };
    public static boolean lightingEnabled = true;

    public static boolean isValid(IChunkGenerator cp, Class<?> api_type) {
        if (api_type.isInstance(cp)) {
            for (Class<?> mixind : MIXINED_CHUNK_PROVIDERS) {
                if (cp.getClass().equals(mixind)) {
                    return true;
                }
                if (!mixind.isInstance(cp)) continue;
                for (Class<?> anInterface : cp.getClass().getInterfaces()) {
                    if (!api_type.equals(anInterface)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static void disableLighting() {
        lightingEnabled = false;
    }

    public static void enableLighting() {
        lightingEnabled = true;
    }

    private WorldGenConstants() {
    }
}

