/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.extent.worker;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import java.util.function.BiFunction;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.extent.BiomeVolume;
import org.spongepowered.api.world.extent.MutableBiomeVolume;
import org.spongepowered.api.world.extent.UnmodifiableBiomeVolume;
import org.spongepowered.api.world.extent.worker.BiomeVolumeWorker;
import org.spongepowered.api.world.extent.worker.procedure.BiomeVolumeMapper;
import org.spongepowered.api.world.extent.worker.procedure.BiomeVolumeMerger;
import org.spongepowered.api.world.extent.worker.procedure.BiomeVolumeReducer;
import org.spongepowered.api.world.extent.worker.procedure.BiomeVolumeVisitor;

public class SpongeBiomeVolumeWorker<V extends BiomeVolume>
implements BiomeVolumeWorker<V> {
    protected final V volume;

    public SpongeBiomeVolumeWorker(V volume) {
        this.volume = volume;
    }

    @Override
    public V getVolume() {
        return this.volume;
    }

    @Override
    public void map(BiomeVolumeMapper mapper, MutableBiomeVolume destination) {
        Vector3i offset = this.align(destination);
        int xOffset = offset.getX();
        int yOffset = offset.getY();
        int zOffset = offset.getZ();
        UnmodifiableBiomeVolume unmodifiableArea = this.volume.getUnmodifiableBiomeView();
        int xMin = unmodifiableArea.getBiomeMin().getX();
        int yMin = unmodifiableArea.getBiomeMin().getY();
        int zMin = unmodifiableArea.getBiomeMin().getZ();
        int xMax = unmodifiableArea.getBiomeMax().getX();
        int yMax = unmodifiableArea.getBiomeMax().getY();
        int zMax = unmodifiableArea.getBiomeMax().getZ();
        for (int z = zMin; z <= zMax; ++z) {
            for (int y = yMin; y <= yMax; ++y) {
                for (int x = xMin; x <= xMax; ++x) {
                    BiomeType biome = mapper.map(unmodifiableArea, x, y, z);
                    destination.setBiome(x + xOffset, y + yOffset, z + zOffset, biome);
                }
            }
        }
    }

    @Override
    public void merge(BiomeVolume second, BiomeVolumeMerger merger, MutableBiomeVolume destination) {
        Vector3i offsetSecond = this.align(second);
        int xOffsetSecond = offsetSecond.getX();
        int yOffsetSecond = offsetSecond.getY();
        int zOffsetSecond = offsetSecond.getZ();
        Vector3i offsetDestination = this.align(destination);
        int xOffsetDestination = offsetDestination.getX();
        int yOffsetDestination = offsetDestination.getY();
        int zOffsetDestination = offsetDestination.getZ();
        UnmodifiableBiomeVolume firstUnmodifiableArea = this.volume.getUnmodifiableBiomeView();
        int xMin = firstUnmodifiableArea.getBiomeMin().getX();
        int yMin = firstUnmodifiableArea.getBiomeMin().getY();
        int zMin = firstUnmodifiableArea.getBiomeMin().getZ();
        int xMax = firstUnmodifiableArea.getBiomeMax().getX();
        int yMax = firstUnmodifiableArea.getBiomeMax().getY();
        int zMax = firstUnmodifiableArea.getBiomeMax().getZ();
        UnmodifiableBiomeVolume secondUnmodifiableArea = second.getUnmodifiableBiomeView();
        for (int z = zMin; z <= zMax; ++z) {
            for (int y = yMin; y <= yMax; ++y) {
                for (int x = xMin; x <= xMax; ++x) {
                    BiomeType biome = merger.merge(firstUnmodifiableArea, x, y, z, secondUnmodifiableArea, x + xOffsetSecond, y + yOffsetSecond, z + zOffsetSecond);
                    destination.setBiome(x + xOffsetDestination, y + yOffsetDestination, z + zOffsetDestination, biome);
                }
            }
        }
    }

    @Override
    public void iterate(BiomeVolumeVisitor<V> visitor) {
        int xMin = this.volume.getBiomeMin().getX();
        int yMin = this.volume.getBiomeMin().getY();
        int zMin = this.volume.getBiomeMin().getZ();
        int xMax = this.volume.getBiomeMax().getX();
        int yMax = this.volume.getBiomeMax().getY();
        int zMax = this.volume.getBiomeMax().getZ();
        for (int z = zMin; z <= zMax; ++z) {
            for (int y = yMin; y <= yMax; ++y) {
                for (int x = xMin; x <= xMax; ++x) {
                    visitor.visit(this.volume, x, y, z);
                }
            }
        }
    }

    @Override
    public <T> T reduce(BiomeVolumeReducer<T> reducer, BiFunction<T, T, T> merge, T identity) {
        UnmodifiableBiomeVolume unmodifiableArea = this.volume.getUnmodifiableBiomeView();
        int xMin = unmodifiableArea.getBiomeMin().getX();
        int yMin = unmodifiableArea.getBiomeMin().getY();
        int zMin = unmodifiableArea.getBiomeMin().getZ();
        int xMax = unmodifiableArea.getBiomeMax().getX();
        int yMax = unmodifiableArea.getBiomeMax().getY();
        int zMax = unmodifiableArea.getBiomeMax().getZ();
        T reduction = identity;
        for (int z = zMin; z <= zMax; ++z) {
            for (int y = yMin; y <= yMax; ++y) {
                for (int x = xMin; x <= xMax; ++x) {
                    reduction = reducer.reduce(unmodifiableArea, x, y, z, reduction);
                }
            }
        }
        return reduction;
    }

    private Vector3i align(BiomeVolume other) {
        Vector3i thisSize = this.volume.getBiomeSize();
        Vector3i otherSize = other.getBiomeSize();
        Preconditions.checkArgument((otherSize.getX() >= thisSize.getX() && otherSize.getY() >= thisSize.getY() && otherSize.getZ() >= thisSize.getZ() ? 1 : 0) != 0, (Object)"Other volume is smaller than work volume");
        return other.getBiomeMin().sub(this.volume.getBiomeMin());
    }
}

